/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.BCCoreSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum StatementParamGateSideOnly implements IStatementParameter
{
    ANY(false),
    SPECIFIC(true);

    public final boolean isSpecific;
    private static final StatementParamGateSideOnly[] POSSIBLE_ANY;
    private static final StatementParamGateSideOnly[] POSSIBLE_SPECIFIC;

    private StatementParamGateSideOnly(boolean isSpecific) {
        this.isSpecific = isSpecific;
    }

    public static StatementParamGateSideOnly readFromNbt(NBTTagCompound nbt) {
        if (nbt.func_74767_n("isOn")) {
            return SPECIFIC;
        }
        return ANY;
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        compound.func_74757_a("isOn", this.isSpecific);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        if (this.isSpecific) {
            return BCCoreSprites.PARAM_GATE_SIDE_ONLY;
        }
        return null;
    }

    @Override
    public IStatementParameter.DrawType getDrawType() {
        return IStatementParameter.DrawType.SPRITE_ONLY;
    }

    @Override
    public StatementParamGateSideOnly onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    @Override
    public String getDescription() {
        return this.isSpecific ? LocaleUtil.localize("gate.parameter.redstone.gateSideOnly") : "";
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:redstoneGateSideOnly";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source) {
        return this.isSpecific ? POSSIBLE_SPECIFIC : POSSIBLE_ANY;
    }

    static {
        POSSIBLE_ANY = new StatementParamGateSideOnly[]{ANY, SPECIFIC};
        POSSIBLE_SPECIFIC = new StatementParamGateSideOnly[]{SPECIFIC, ANY};
    }
}

