/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.configurate;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import slimeknights.mantle.configurate.ConfigValue;
import slimeknights.mantle.configurate.SimpleConfigurationNode;
import slimeknights.mantle.configurate.Types;

class ListConfigValue
extends ConfigValue {
    final AtomicReference<List<SimpleConfigurationNode>> values = new AtomicReference();

    ListConfigValue(SimpleConfigurationNode holder) {
        super(holder);
        this.values.set(new ArrayList());
    }

    ListConfigValue(SimpleConfigurationNode holder, Object startValue) {
        super(holder);
        this.values.set(new ArrayList());
        SimpleConfigurationNode child = holder.createNode(0);
        child.attached = true;
        child.setValue(startValue);
        this.values.get().add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() {
        List<SimpleConfigurationNode> values;
        List<SimpleConfigurationNode> list = values = this.values.get();
        synchronized (list) {
            ArrayList<Object> ret = new ArrayList<Object>(values.size());
            for (SimpleConfigurationNode obj : values) {
                ret.add(obj.getValue());
            }
            return ret.isEmpty() ? null : ret;
        }
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Collection)) {
            value = Collections.singleton(value);
        }
        Collection valueList = value;
        ArrayList<SimpleConfigurationNode> newValue = new ArrayList<SimpleConfigurationNode>(valueList.size());
        int count = 0;
        for (Object o : valueList) {
            if (o == null) continue;
            SimpleConfigurationNode child = this.holder.createNode(count);
            newValue.add(count, child);
            child.attached = true;
            child.setValue(o);
            ++count;
        }
        this.detachNodes(this.values.getAndSet(newValue));
    }

    @Override
    public SimpleConfigurationNode putChild(Object key, SimpleConfigurationNode value) {
        return this.putChild(key, value, false);
    }

    @Override
    SimpleConfigurationNode putChildIfAbsent(Object key, SimpleConfigurationNode value) {
        return this.putChild(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleConfigurationNode putChild(Object key, SimpleConfigurationNode value, boolean onlyIfAbsent) {
        List<SimpleConfigurationNode> values;
        SimpleConfigurationNode ret = null;
        do {
            List<SimpleConfigurationNode> list = values = this.values.get();
            synchronized (list) {
                int index = (Integer)key;
                if (value == null) {
                    if (index < values.size()) {
                        ret = values.remove(index);
                        for (int i = index; i < values.size(); ++i) {
                            values.get((int)i).key = index;
                        }
                    }
                } else if (index >= 0 && index < values.size()) {
                    if (onlyIfAbsent) {
                        return values.get(index);
                    }
                    ret = values.set(index, value);
                } else if (index == -1) {
                    values.add(value);
                    value.key = values.lastIndexOf(value);
                } else {
                    values.add(index, value);
                }
            }
        } while (!this.values.compareAndSet(values, values));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleConfigurationNode getChild(Object key) {
        List<SimpleConfigurationNode> values;
        List<SimpleConfigurationNode> list = values = this.values.get();
        synchronized (list) {
            Integer value = Types.asInt(key);
            if (value == null || value < 0 || value >= values.size()) {
                return null;
            }
            return values.get(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<SimpleConfigurationNode> iterateChildren() {
        List<SimpleConfigurationNode> values;
        List<SimpleConfigurationNode> list = values = this.values.get();
        synchronized (list) {
            return ImmutableList.copyOf(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachNodes(List<SimpleConfigurationNode> children) {
        List<SimpleConfigurationNode> list = children;
        synchronized (list) {
            for (SimpleConfigurationNode node : children) {
                node.attached = false;
                node.clear();
            }
        }
    }

    @Override
    public void clear() {
        List oldValues = this.values.getAndSet(new ArrayList());
        this.detachNodes(oldValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListConfigValue that = (ListConfigValue)o;
        return Objects.equal(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.values});
    }
}

