/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.recipe;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityAmphithereArrow;
import com.github.alexthe666.iceandfire.entity.EntityCockatriceEgg;
import com.github.alexthe666.iceandfire.entity.EntityDeathWormEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonArrow;
import com.github.alexthe666.iceandfire.entity.EntityHippogryphEgg;
import com.github.alexthe666.iceandfire.entity.EntityHydraArrow;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentArrow;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianArrow;
import com.github.alexthe666.iceandfire.enums.EnumDragonArmor;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class IafRecipeRegistry {
    public static List<DragonForgeRecipe> FIRE_FORGE_RECIPES = new ArrayList<DragonForgeRecipe>();
    public static List<DragonForgeRecipe> ICE_FORGE_RECIPES = new ArrayList<DragonForgeRecipe>();
    public static List<ItemStack> BANNER_ITEMS = new ArrayList<ItemStack>();

    public static void preInit() {
        FIRE_FORGE_RECIPES.add(new DragonForgeRecipe(new ItemStack(Items.field_151042_j), new ItemStack(IafItemRegistry.fire_dragon_blood), new ItemStack(IafItemRegistry.dragonsteel_fire_ingot)));
        ICE_FORGE_RECIPES.add(new DragonForgeRecipe(new ItemStack(Items.field_151042_j), new ItemStack(IafItemRegistry.ice_dragon_blood), new ItemStack(IafItemRegistry.dragonsteel_ice_ingot)));
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.stymphalian_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityStymphalianArrow entityarrow = new EntityStymphalianArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.amphithere_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityAmphithereArrow entityarrow = new EntityAmphithereArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.sea_serpent_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntitySeaSerpentArrow entityarrow = new EntitySeaSerpentArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.dragonbone_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityDragonArrow entityarrow = new EntityDragonArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.hydra_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityHydraArrow entityarrow = new EntityHydraArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.hippogryph_egg, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityHippogryphEgg entityarrow = new EntityHippogryphEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stackIn);
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.rotten_egg, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityCockatriceEgg entityarrow = new EntityCockatriceEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)IafItemRegistry.deathworm_egg, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityDeathWormEgg entityarrow = new EntityDeathWormEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stackIn.func_77960_j() == 1);
                return entityarrow;
            }
        });
        OreDictionary.registerOre((String)"desertMyrmexEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"jungleMyrmexEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"charredBlock", (Block)IafBlockRegistry.charedDirt);
        OreDictionary.registerOre((String)"charredBlock", (Block)IafBlockRegistry.charedGrass);
        OreDictionary.registerOre((String)"charredBlock", (Block)IafBlockRegistry.charedGrassPath);
        OreDictionary.registerOre((String)"charredBlock", (Block)IafBlockRegistry.charedGravel);
        OreDictionary.registerOre((String)"charredBlock", (Block)IafBlockRegistry.charedCobblestone);
        OreDictionary.registerOre((String)"charredBlock", (Block)IafBlockRegistry.charedStone);
        OreDictionary.registerOre((String)"frozenBlock", (Block)IafBlockRegistry.frozenDirt);
        OreDictionary.registerOre((String)"frozenBlock", (Block)IafBlockRegistry.frozenGrass);
        OreDictionary.registerOre((String)"frozenBlock", (Block)IafBlockRegistry.frozenGrassPath);
        OreDictionary.registerOre((String)"frozenBlock", (Block)IafBlockRegistry.frozenGravel);
        OreDictionary.registerOre((String)"frozenBlock", (Block)IafBlockRegistry.frozenCobblestone);
        OreDictionary.registerOre((String)"frozenBlock", (Block)IafBlockRegistry.frozenStone);
        OreDictionary.registerOre((String)"ingotFireDragonsteel", (Item)IafItemRegistry.dragonsteel_fire_ingot);
        OreDictionary.registerOre((String)"blockFireDragonsteel", (Block)IafBlockRegistry.dragonsteel_fire_block);
        OreDictionary.registerOre((String)"ingotIceDragonsteel", (Item)IafItemRegistry.dragonsteel_ice_ingot);
        OreDictionary.registerOre((String)"blockIceDragonsteel", (Block)IafBlockRegistry.dragonsteel_ice_block);
        OreDictionary.registerOre((String)"ingotSilver", (Item)IafItemRegistry.silverIngot);
        OreDictionary.registerOre((String)"nuggetSilver", (Item)IafItemRegistry.silverNugget);
        OreDictionary.registerOre((String)"oreSilver", (Block)IafBlockRegistry.silverOre);
        OreDictionary.registerOre((String)"blockSilver", (Block)IafBlockRegistry.silverBlock);
        OreDictionary.registerOre((String)"gemSapphire", (Item)IafItemRegistry.sapphireGem);
        OreDictionary.registerOre((String)"oreSapphire", (Block)IafBlockRegistry.sapphireOre);
        OreDictionary.registerOre((String)"blockSapphire", (Block)IafBlockRegistry.sapphireBlock);
        OreDictionary.registerOre((String)"boneWither", (Item)IafItemRegistry.witherbone);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_red);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_bronze);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_gray);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_green);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_blue);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_white);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_sapphire);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)IafBlockRegistry.dragonscale_silver);
        OreDictionary.registerOre((String)"woolBlock", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151076_bf);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151077_bg);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151082_bd);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151083_be);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151147_al);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151157_am);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179561_bm);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179557_bn);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179558_bo);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179559_bp);
        OreDictionary.registerOre((String)"boneWithered", (Item)IafItemRegistry.witherbone);
        OreDictionary.registerOre((String)"boneDragon", (Item)IafItemRegistry.dragonbone);
        for (EnumSeaSerpent enumSeaSerpent : EnumSeaSerpent.values()) {
            OreDictionary.registerOre((String)"seaSerpentScales", (Item)enumSeaSerpent.scale);
        }
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(IafItemRegistry.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(IafItemRegistry.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(IafItemRegistry.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(IafItemRegistry.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(IafItemRegistry.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(IafItemRegistry.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(IafItemRegistry.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(IafItemRegistry.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(IafItemRegistry.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(IafItemRegistry.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(IafItemRegistry.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(IafItemRegistry.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(IafItemRegistry.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolAxe", (Item)IafItemRegistry.dragonbone_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)IafItemRegistry.myrmex_desert_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)IafItemRegistry.myrmex_jungle_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)IafItemRegistry.silver_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)IafItemRegistry.dragonsteel_fire_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)IafItemRegistry.dragonsteel_ice_axe);
        OreDictionary.registerOre((String)"dragonSkull", (ItemStack)new ItemStack(IafItemRegistry.dragon_skull, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"mythicalSkull", (ItemStack)new ItemStack(IafItemRegistry.dragon_skull, 1, Short.MAX_VALUE));
        for (Enum enum_ : EnumSkullType.values()) {
            OreDictionary.registerOre((String)"mythicalSkull", (Item)((EnumSkullType)enum_).skull_item);
        }
        IafRecipeRegistry.addBanner("fire", new ItemStack(IafItemRegistry.fire_dragon_heart));
        IafRecipeRegistry.addBanner("ice", new ItemStack(IafItemRegistry.ice_dragon_heart));
        IafRecipeRegistry.addBanner("fire_head", new ItemStack(IafItemRegistry.dragon_skull, 1, 0));
        IafRecipeRegistry.addBanner("ice_head", new ItemStack(IafItemRegistry.dragon_skull, 1, 1));
        IafRecipeRegistry.addBanner("amphithere", new ItemStack(IafItemRegistry.amphithere_feather));
        IafRecipeRegistry.addBanner("bird", new ItemStack(IafItemRegistry.stymphalian_bird_feather));
        IafRecipeRegistry.addBanner("eye", new ItemStack(IafItemRegistry.cyclops_eye));
        IafRecipeRegistry.addBanner("fae", new ItemStack(IafItemRegistry.pixie_wings));
        IafRecipeRegistry.addBanner("feather", new ItemStack(Items.field_151008_G));
        IafRecipeRegistry.addBanner("gorgon", new ItemStack(IafItemRegistry.gorgon_head));
        IafRecipeRegistry.addBanner("hippocampus", new ItemStack(IafItemRegistry.hippocampus_fin));
        IafRecipeRegistry.addBanner("hippogryph_head", new ItemStack(EnumSkullType.HIPPOGRYPH.skull_item));
        IafRecipeRegistry.addBanner("mermaid", new ItemStack(IafItemRegistry.siren_tear));
        IafRecipeRegistry.addBanner("sea_serpent", new ItemStack(IafItemRegistry.sea_serpent_fang));
        IafRecipeRegistry.addBanner("troll", new ItemStack(IafItemRegistry.troll_tusk));
        IafRecipeRegistry.addBanner("weezer", new ItemStack(IafItemRegistry.weezer_blue_album));
        IafRecipeRegistry.addBanner("dread", new ItemStack(IafItemRegistry.dread_shard));
        GameRegistry.addSmelting((Block)IafBlockRegistry.silverOre, (ItemStack)new ItemStack(IafItemRegistry.silverIngot), (float)1.0f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.sapphireOre, (ItemStack)new ItemStack(IafItemRegistry.sapphireGem), (float)1.0f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.myrmex_desert_resin_block, (ItemStack)new ItemStack(IafBlockRegistry.myrmex_desert_resin_glass), (float)1.0f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.myrmex_jungle_resin_block, (ItemStack)new ItemStack(IafBlockRegistry.myrmex_jungle_resin_glass), (float)1.0f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenDirt, (ItemStack)new ItemStack(Blocks.field_150346_d), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenGrass, (ItemStack)new ItemStack((Block)Blocks.field_150349_c), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenGrassPath, (ItemStack)new ItemStack(Blocks.field_185774_da), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenCobblestone, (ItemStack)new ItemStack(Blocks.field_150347_e), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenStone, (ItemStack)new ItemStack(Blocks.field_150348_b), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenGravel, (ItemStack)new ItemStack(Blocks.field_150351_n), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.frozenSplinters, (ItemStack)new ItemStack(Items.field_151055_y, 3), (float)0.1f);
        GameRegistry.addSmelting((Block)IafBlockRegistry.dread_stone_bricks, (ItemStack)new ItemStack((Block)IafBlockRegistry.dread_stone_bricks_cracked), (float)0.1f);
        IafItemRegistry.blindfoldArmor.setRepairItem(new ItemStack(Items.field_151007_F));
        IafItemRegistry.silverMetal.setRepairItem(new ItemStack(IafItemRegistry.silverIngot));
        IafItemRegistry.silverTools.setRepairItem(new ItemStack(IafItemRegistry.silverIngot));
        IafItemRegistry.boneTools.setRepairItem(new ItemStack(IafItemRegistry.dragonbone));
        IafItemRegistry.fireBoneTools.setRepairItem(new ItemStack(IafItemRegistry.dragonbone));
        IafItemRegistry.iceBoneTools.setRepairItem(new ItemStack(IafItemRegistry.dragonbone));
        for (Enum enum_ : EnumDragonArmor.values()) {
            ((EnumDragonArmor)enum_).armorMaterial.setRepairItem(new ItemStack(EnumDragonArmor.getScaleItem((EnumDragonArmor)enum_)));
        }
        IafItemRegistry.dragonsteel_fire_armor.setRepairItem(new ItemStack(IafItemRegistry.dragonsteel_fire_ingot));
        IafItemRegistry.dragonsteel_ice_armor.setRepairItem(new ItemStack(IafItemRegistry.dragonsteel_ice_ingot));
        IafItemRegistry.sheep.setRepairItem(new ItemStack(Blocks.field_150325_L));
        IafItemRegistry.earplugsArmor.setRepairItem(new ItemStack(Blocks.field_150471_bO));
        IafItemRegistry.yellow_deathworm.setRepairItem(new ItemStack(IafItemRegistry.deathworm_chitin, 1, 0));
        IafItemRegistry.white_deathworm.setRepairItem(new ItemStack(IafItemRegistry.deathworm_chitin, 1, 1));
        IafItemRegistry.red_deathworm.setRepairItem(new ItemStack(IafItemRegistry.deathworm_chitin, 1, 2));
        IafItemRegistry.trollWeapon.setRepairItem(new ItemStack(Blocks.field_150348_b));
        IafItemRegistry.troll_mountain.setRepairItem(new ItemStack(EnumTroll.MOUNTAIN.leather));
        IafItemRegistry.troll_forest.setRepairItem(new ItemStack(EnumTroll.FOREST.leather));
        IafItemRegistry.troll_frost.setRepairItem(new ItemStack(EnumTroll.FROST.leather));
        IafItemRegistry.hippogryph_sword_tools.setRepairItem(new ItemStack(IafItemRegistry.hippogryph_talon));
        IafItemRegistry.hippocampus_sword_tools.setRepairItem(new ItemStack(IafItemRegistry.shiny_scales));
        IafItemRegistry.amphithere_sword_tools.setRepairItem(new ItemStack(IafItemRegistry.amphithere_feather));
        IafItemRegistry.dragonsteel_fire_tools.setRepairItem(new ItemStack(IafItemRegistry.dragonsteel_fire_ingot));
        IafItemRegistry.dragonsteel_ice_tools.setRepairItem(new ItemStack(IafItemRegistry.dragonsteel_ice_ingot));
        IafItemRegistry.stymphalian_sword_tools.setRepairItem(new ItemStack(IafItemRegistry.stymphalian_bird_feather));
        IafItemRegistry.myrmexChitin.setRepairItem(new ItemStack(IafItemRegistry.myrmex_desert_chitin));
        IafItemRegistry.myrmexDesert.setRepairItem(new ItemStack(IafItemRegistry.myrmex_desert_chitin));
        IafItemRegistry.myrmexJungle.setRepairItem(new ItemStack(IafItemRegistry.myrmex_jungle_chitin));
        IafItemRegistry.dread_sword_tools.setRepairItem(new ItemStack(IafItemRegistry.dread_shard));
        IafItemRegistry.dread_knight_sword_tools.setRepairItem(new ItemStack(IafItemRegistry.dread_shard));
        for (Enum enum_ : EnumSeaSerpent.values()) {
            ((EnumSeaSerpent)enum_).armorMaterial.setRepairItem(new ItemStack(((EnumSeaSerpent)enum_).scale));
        }
        ItemStack waterBreathingPotion = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Potion", "water_breathing");
        waterBreathingPotion.func_77982_d(tag);
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, 0), (ItemStack)new ItemStack(IafItemRegistry.shiny_scales), (ItemStack)waterBreathingPotion);
    }

    public static BannerPattern addBanner(String name, ItemStack craftingStack) {
        Class[] classes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] names = new Object[]{name, "iceandfire." + name, craftingStack};
        BANNER_ITEMS.add(craftingStack);
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])classes, (Object[])names);
    }

    public static void postInit() {
        block2: {
            NonNullList copperItems;
            block3: {
                NonNullList bronzeItems = OreDictionary.getOres((String)"nuggetBronze");
                copperItems = OreDictionary.getOres((String)"nuggetCopper");
                if (bronzeItems.isEmpty()) break block3;
                for (ItemStack bronzeIngot : bronzeItems) {
                    if (bronzeIngot == ItemStack.field_190927_a) continue;
                    GameRegistry.addSmelting((Item)IafItemRegistry.stymphalian_bird_feather, (ItemStack)bronzeIngot.func_77946_l(), (float)1.0f);
                    break block2;
                }
                break block2;
            }
            if (copperItems.isEmpty()) break block2;
            for (ItemStack copperIngot : copperItems) {
                if (copperIngot == ItemStack.field_190927_a) continue;
                GameRegistry.addSmelting((Item)IafItemRegistry.stymphalian_bird_feather, (ItemStack)copperIngot.func_77946_l(), (float)1.0f);
                break;
            }
        }
    }

    public static DragonForgeRecipe getFireForgeRecipe(ItemStack stack) {
        for (DragonForgeRecipe recipe : FIRE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static DragonForgeRecipe getIceForgeRecipe(ItemStack stack) {
        for (DragonForgeRecipe recipe : ICE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static DragonForgeRecipe getFireForgeRecipeForBlood(ItemStack stack) {
        for (DragonForgeRecipe recipe : FIRE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getBlood(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static DragonForgeRecipe getIceForgeRecipeForBlood(ItemStack stack) {
        for (DragonForgeRecipe recipe : ICE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getBlood(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }
}

