/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PathNavigateCyclops
extends PathNavigateGround {
    public BlockPos targetPosition;
    private EntityCyclops cyclops;
    private int ticksAtLastPos;
    private Vec3d lastPosCheck = Vec3d.field_186680_a;
    private Vec3d timeoutCachedNode = Vec3d.field_186680_a;
    private long timeoutTimer;
    private long lastTimeoutCheck;
    private double timeoutLimit;

    public PathNavigateCyclops(EntityCyclops entitylivingIn, World worldIn) {
        super((EntityLiving)entitylivingIn, worldIn);
        this.cyclops = entitylivingIn;
    }

    protected PathFinder func_179679_a() {
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        this.field_179695_a.func_186316_c(true);
        return new PathFinder(this.field_179695_a);
    }

    public Path func_179680_a(BlockPos pos) {
        this.targetPosition = pos;
        return super.func_179680_a(pos);
    }

    public Path func_75494_a(Entity entityIn) {
        this.targetPosition = new BlockPos(entityIn);
        return super.func_75494_a(entityIn);
    }

    public boolean func_75497_a(Entity entityIn, double speedIn) {
        Path path = this.func_75494_a(entityIn);
        if (path != null) {
            return this.func_75484_a(path, speedIn);
        }
        this.targetPosition = new BlockPos(entityIn);
        this.field_75511_d = speedIn;
        return true;
    }

    protected void func_75508_h() {
        Vec3d vec3d = this.func_75502_i();
        int i = this.field_75514_c.func_75874_d();
        for (int j = this.field_75514_c.func_75873_e(); j < this.field_75514_c.func_75874_d(); ++j) {
            if ((double)this.field_75514_c.func_75877_a((int)j).field_75837_b == Math.floor(vec3d.field_72448_b)) continue;
            i = j;
            break;
        }
        this.field_188561_o = this.field_75515_a.field_70130_N;
        Vec3d vec3d1 = this.field_75514_c.func_186310_f();
        float distX = MathHelper.func_76135_e((float)((float)(this.field_75515_a.field_70165_t - (vec3d1.field_72450_a + 0.5))));
        float distZ = MathHelper.func_76135_e((float)((float)(this.field_75515_a.field_70161_v - (vec3d1.field_72449_c + 0.5))));
        float distY = (float)Math.abs(this.field_75515_a.field_70163_u - vec3d1.field_72448_b);
        if (distX < this.field_188561_o && distZ < this.field_188561_o && distY < this.field_75515_a.field_70131_O) {
            this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
        }
        int k = MathHelper.func_76123_f((float)this.field_75515_a.field_70130_N);
        int l = MathHelper.func_76123_f((float)this.field_75515_a.field_70131_O);
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.field_75514_c.func_75873_e(); --j1) {
            if (!this.func_75493_a(vec3d, this.field_75514_c.func_75881_a((Entity)this.field_75515_a, j1), k, l, i1)) continue;
            this.field_75514_c.func_75872_c(j1);
            break;
        }
        this.func_179677_a(vec3d);
    }

    protected void func_179677_a(Vec3d positionVec3) {
        if (this.field_75510_g - this.ticksAtLastPos > 100) {
            if (positionVec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.func_75499_g();
            }
            this.ticksAtLastPos = this.field_75510_g;
            this.lastPosCheck = positionVec3;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vec3d vec3d = this.field_75514_c.func_186310_f();
            if (vec3d.equals((Object)this.timeoutCachedNode)) {
                this.timeoutTimer += System.currentTimeMillis() - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = vec3d;
                double d0 = positionVec3.func_72438_d(this.timeoutCachedNode);
                double d = this.timeoutLimit = this.field_75515_a.func_70689_ay() > 0.0f ? d0 / (double)this.field_75515_a.func_70689_ay() * 1000.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutCachedNode = Vec3d.field_186680_a;
                this.timeoutTimer = 0L;
                this.timeoutLimit = 0.0;
                this.func_75499_g();
            }
            this.lastTimeoutCheck = System.currentTimeMillis();
        }
    }

    public void func_75499_g() {
        super.func_75499_g();
    }

    protected boolean func_75493_a(Vec3d posVec31, Vec3d posVec32, int sizeX, int sizeY, int sizeZ) {
        int i = MathHelper.func_76128_c((double)posVec31.field_72450_a);
        int j = MathHelper.func_76128_c((double)posVec31.field_72449_c);
        double d0 = posVec32.field_72450_a - posVec31.field_72450_a;
        double d1 = posVec32.field_72449_c - posVec31.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        d0 *= d3;
        d1 *= d3;
        if (IceAndFire.CONFIG.completeDragonPathfinding) {
            sizeX += 2;
            sizeZ += 2;
        } else {
            sizeX = 1;
            sizeZ = 1;
        }
        if (!this.isSafeToStandAt(i, (int)posVec31.field_72448_b, j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)i - posVec31.field_72450_a;
        double d7 = (double)j - posVec31.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int k = d0 < 0.0 ? -1 : 1;
        int l = d1 < 0.0 ? -1 : 1;
        int i1 = MathHelper.func_76128_c((double)posVec32.field_72450_a);
        int j1 = MathHelper.func_76128_c((double)posVec32.field_72449_c);
        int k1 = i1 - i;
        int l1 = j1 - j;
        while (k1 * k > 0 || l1 * l > 0) {
            if (d6 < d7) {
                d6 += d4;
                k1 = i1 - (i += k);
            } else {
                d7 += d5;
                l1 = j1 - (j += l);
            }
            if (this.isSafeToStandAt(i, (int)posVec31.field_72448_b, j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d vec31, double p_179683_8_, double p_179683_10_) {
        int i = x - sizeX / 2;
        int j = z - sizeZ / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, vec31, p_179683_8_, p_179683_10_)) {
            return false;
        }
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - vec31.field_72450_a;
                double d1 = (double)l + 0.5 - vec31.field_72449_c;
                if (!(d0 * p_179683_8_ + d1 * p_179683_10_ >= 0.0)) continue;
                PathNodeType pathnodetype = this.field_179695_a.func_186319_a((IBlockAccess)this.field_75513_b, k, y - 1, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                if (pathnodetype == PathNodeType.WATER) {
                    return false;
                }
                if (pathnodetype == PathNodeType.LAVA) {
                    return false;
                }
                if (pathnodetype == PathNodeType.OPEN) {
                    return false;
                }
                pathnodetype = this.field_179695_a.func_186319_a((IBlockAccess)this.field_75513_b, k, y, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_75515_a.func_184643_a(pathnodetype);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (pathnodetype != PathNodeType.DAMAGE_FIRE && pathnodetype != PathNodeType.DANGER_FIRE && pathnodetype != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d p_179692_7_, double p_179692_8_, double p_179692_10_) {
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            Block block;
            double d1;
            double d0 = (double)blockpos.func_177958_n() + 0.5 - p_179692_7_.field_72450_a;
            if (!(d0 * p_179692_8_ + (d1 = (double)blockpos.func_177952_p() + 0.5 - p_179692_7_.field_72449_c) * p_179692_10_ >= 0.0) || (block = this.field_75513_b.func_180495_p(blockpos).func_177230_c()).func_176205_b((IBlockAccess)this.field_75513_b, blockpos)) continue;
            return false;
        }
        return true;
    }
}

