/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityCyclopsEye;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.IHumanoid;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.ai.CyclopsAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.CyclopsAITargetSheepPlayers;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateCyclops;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.multipart.PartEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityCyclops
extends EntityMob
implements IAnimatedEntity,
IBlacklistedFromStatues,
IVillagerFear,
IHumanoid {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "cyclops"));
    private static final DataParameter<Boolean> BLINDED = EntityDataManager.func_187226_a(EntityCyclops.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityCyclops.class, (DataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_STOMP;
    public static Animation ANIMATION_EATPLAYER;
    public static Animation ANIMATION_KICK;
    public static Animation ANIMATION_ROAR;
    public PartEntity eyeEntity;
    private int animationTick;
    private Animation currentAnimation;

    public EntityCyclops(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.95f, 7.4f);
        this.field_70138_W = 2.5f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, 0.0f);
        this.eyeEntity = new EntityCyclopsEye((EntityLiving)this, 0.2f, 0.0f, 7.4f, 1.2f, 0.5f, 1.0f);
        ANIMATION_STOMP = Animation.create((int)27);
        ANIMATION_EATPLAYER = Animation.create((int)40);
        ANIMATION_KICK = Animation.create((int)20);
        ANIMATION_ROAR = Animation.create((int)30);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateCyclops(this, this.field_70170_p);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 40;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new CyclopsAIAttackMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                return !EntityGorgon.isStoneMob(entity) && DragonUtils.isAlive(entity) && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityPlayer) && !(entity instanceof EntityCyclops) && !ServerEvents.isAnimaniaSheep((Entity)entity) && (!(entity instanceof EntityAnimal) || entity instanceof EntityWolf || entity instanceof EntityPolarBear || entity instanceof EntityDragonBase) || entity instanceof EntityGorgon || entity instanceof EntityVillager;
            }
        }));
        this.field_70715_bh.func_75776_a(3, new CyclopsAITargetSheepPlayers<Entity>((EntityCreature)this, EntityPlayer.class, 0, true, true, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return true;
            }
        }));
    }

    protected void func_82167_n(Entity entityIn) {
        if (!ServerEvents.isAnimaniaSheep(entityIn)) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        int attackDescision = this.func_70681_au().nextInt(3);
        if (attackDescision == 0) {
            this.setAnimation(ANIMATION_STOMP);
            return true;
        }
        if (attackDescision == 1) {
            if (!entityIn.func_184196_w((Entity)this) && entityIn.field_70130_N < 1.95f && !(entityIn instanceof EntityDragonBase)) {
                this.setAnimation(ANIMATION_EATPLAYER);
                entityIn.func_184210_p();
                entityIn.func_184205_a((Entity)this, true);
            } else {
                this.setAnimation(ANIMATION_STOMP);
            }
            return true;
        }
        this.setAnimation(ANIMATION_KICK);
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(IceAndFire.CONFIG.cyclopsAttackStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(IceAndFire.CONFIG.cyclopsMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BLINDED, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Blind", this.isBlinded());
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBlinded(compound.func_74767_n("Blind"));
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean isBlinded() {
        return (Boolean)this.field_70180_af.func_187225_a(BLINDED);
    }

    public void setBlinded(boolean blind) {
        this.field_70180_af.func_187227_b(BLINDED, (Object)blind);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            passenger.field_70159_w = 0.0;
            passenger.field_70179_y = 0.0;
            this.setAnimation(ANIMATION_EATPLAYER);
            double raiseUp = this.getAnimationTick() < 10 ? 0.0 : Math.min((double)(this.getAnimationTick() * 3 - 30) * 0.2, (double)5.2f);
            float pullIn = this.getAnimationTick() < 15 ? 0.0f : Math.min((float)(this.getAnimationTick() - 15) * 0.15f, 0.75f);
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z *= 0.0f;
            float radius = -2.75f + pullIn;
            float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = raiseUp;
            passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
            if (this.getAnimationTick() == 32) {
                passenger.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), passenger instanceof EntityPlayer ? (float)IceAndFire.CONFIG.cyclopsBiteStrength : (passenger instanceof EntityLivingBase ? ((EntityLivingBase)passenger).func_110138_aP() * 2.0f : (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2.0f));
                passenger.func_184210_p();
            }
        }
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        if (this.getAnimation() == ANIMATION_EATPLAYER) {
            strafe = 0.0f;
            forward = 0.0f;
            vertical = 0.0f;
            super.func_191986_a(strafe, forward, vertical);
            return;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.isBlinded() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 6.0) {
            this.func_70624_b(null);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.CYCLOPS_BLINDED, 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_EATPLAYER && this.getAnimationTick() == 25) {
            this.func_184185_a(IafSoundRegistry.CYCLOPS_BITE, 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_STOMP && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 12.0 && this.getAnimationTick() == 14) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        if (this.getAnimation() == ANIMATION_KICK && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 14.0 && this.getAnimationTick() == 12) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            this.func_70638_az().func_70653_a((Entity)this, 2.0f, 1.0, 1.0);
        }
        if (this.getAnimation() != ANIMATION_EATPLAYER && this.func_70638_az() != null && !this.func_184188_bt().isEmpty() && this.func_184188_bt().contains(this.func_70638_az())) {
            this.setAnimation(ANIMATION_EATPLAYER);
        }
        if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() != null && this.func_70681_au().nextInt(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() == 14) {
            for (int i1 = 0; i1 < 20; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = -1.5f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + extraX)), MathHelper.func_76128_c((double)(this.field_70163_u + extraY)) - 1, MathHelper.func_76128_c((double)(this.field_70161_v + extraZ))));
                if (iblockstate.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_175682_a(EnumParticleTypes.BLOCK_CRACK, true, this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.eyeEntity.func_70071_h_();
        this.breakBlock();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(this.func_70681_au().nextInt(4));
        return livingdata;
    }

    public void breakBlock() {
        if (IceAndFire.CONFIG.cyclopsGriefing) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 1; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 1; ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) + 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 1; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 1; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        IBlockState state = this.field_70170_p.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (state.func_185904_a() == Material.field_151579_a || block instanceof BlockBush || block instanceof BlockLiquid || block == Blocks.field_150357_h || !state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, pos) && !state.func_177230_c().canSustainLeaves(state, (IBlockAccess)this.field_70170_p, pos)) continue;
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        if (MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((EntityLiving)this, a, b, c)) || block == Blocks.field_150350_a || this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void func_70106_y() {
        if (this.eyeEntity != null) {
            this.field_70170_p.func_72973_f((Entity)this.eyeEntity);
        }
        super.func_70106_y();
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STOMP, ANIMATION_EATPLAYER, ANIMATION_KICK, ANIMATION_ROAR};
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 40 && !this.isBlinded();
    }

    public void onHitEye(DamageSource source, float damage) {
        if (!this.isBlinded()) {
            this.setBlinded(true);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(6.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
            this.setAnimation(ANIMATION_ROAR);
            this.func_70097_a(source, damage * 3.0f);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.CYCLOPS_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return IafSoundRegistry.CYCLOPS_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.CYCLOPS_DIE;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return !this.isBlinded();
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

