/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Maybe<T> {
    private static final Maybe<?> EMPTY = new Empty();

    public static <T> Maybe<T> of(T object) {
        return new Present(object);
    }

    public static <T> Maybe<T> empty() {
        return EMPTY;
    }

    private Maybe() {
    }

    public abstract boolean isPresent();

    public abstract <S> Maybe<S> map(Function<T, S> var1);

    public abstract T get() throws IllegalStateException;

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<T> var1);

    public abstract void ifPresent(Consumer<T> var1);

    private static class Empty
    extends Maybe<Object> {
        private Empty() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public <S> Maybe<S> map(Function<Object, S> mapper) {
            return this;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("Cannot call get on an empty maybe!");
        }

        @Override
        public Object orElse(Object other) {
            return other;
        }

        @Override
        public Object orElseGet(Supplier<Object> other) {
            return other.get();
        }

        @Override
        public void ifPresent(Consumer<Object> consumer) {
        }
    }

    private static class Present<T>
    extends Maybe<T> {
        private final T object;

        private Present(T object) {
            this.object = object;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public <S> Maybe<S> map(Function<T, S> mapper) {
            return Maybe.of(mapper.apply(this.object));
        }

        @Override
        public T get() {
            return this.object;
        }

        @Override
        public T orElse(T other) {
            return this.object;
        }

        @Override
        public T orElseGet(Supplier<T> other) {
            return this.object;
        }

        @Override
        public void ifPresent(Consumer<T> consumer) {
            consumer.accept(this.object);
        }
    }
}

