/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.gui.ObjectBaseContainer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public abstract class ItemBaseContainer
extends ObjectBaseContainer<ItemStack> {
    private final Supplier<ItemStack> stackSupplier;
    protected final Predicate<ItemStack> stackValidator;

    private ItemBaseContainer(BaseContainerType<?> type, EntityPlayer player, Supplier<ItemStack> itemStackSupplier, Predicate<ItemStack> stackValidator) {
        super(type, player, true);
        this.stackSupplier = itemStackSupplier;
        this.stackValidator = stackValidator;
    }

    protected ItemBaseContainer(BaseContainerType<?> type, EntityPlayer player, int playerSlot, Predicate<ItemStack> stackValidator) {
        this(type, player, () -> player.field_71071_by.func_70301_a(playerSlot), stackValidator);
    }

    protected ItemBaseContainer(BaseContainerType<?> type, EntityPlayer player, EnumHand hand, Predicate<ItemStack> stackValidator) {
        this(type, player, () -> ClientUtils.getPlayer().func_184586_b(hand), stackValidator);
    }

    @Override
    protected ItemStack getObject(ItemStack oldObject) {
        return this.stackSupplier.get();
    }

    @Override
    protected boolean validateObject(ItemStack object) {
        return object != null && this.stackValidator.test(object);
    }
}

