/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.gui.BaseContainer;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;

public final class BaseContainerType<T extends Container> {
    private final BiConsumer<T, PacketBuffer> containerSerializer;
    private final BiFunction<EntityPlayer, PacketBuffer, T> containerDeserializer;

    public static <T extends BaseContainer> BaseContainerType<T> create(BiConsumer<T, PacketBuffer> containerSerializer, BiFunction<EntityPlayer, PacketBuffer, T> containerDeserializer) {
        return new BaseContainerType<T>(containerSerializer, containerDeserializer);
    }

    private BaseContainerType(BiConsumer<T, PacketBuffer> containerSerializer, BiFunction<EntityPlayer, PacketBuffer, T> containerDeserializer) {
        this.containerSerializer = containerSerializer;
        this.containerDeserializer = containerDeserializer;
    }

    public void writeContainer(T container, PacketBuffer buffer) {
        this.containerSerializer.accept(container, buffer);
    }

    public T readContainer(EntityPlayer player, PacketBuffer buffer) {
        return (T)((Container)this.containerDeserializer.apply(player, buffer));
    }
}

