/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.extensions.ICriterionInstanceExtension;
import com.supermartijn642.core.extensions.IngredientExtension;
import com.supermartijn642.core.generator.AdvancementGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.advancements.critereon.OredictItemPredicate;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.oredict.OreIngredient;

public abstract class RecipeGenerator
extends ResourceGenerator {
    private static final Supplier<Map<ResourceLocation, IRecipeFactory>> CRAFTING_HELPER_RECIPES;
    private final Map<ResourceLocation, RecipeBuilder<?>> recipes = new HashMap();
    private final Advancements advancements;

    public RecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
        this.advancements = new Advancements(modid, cache);
    }

    @Override
    public void save() {
        this.advancements.generate();
        for (RecipeBuilder<?> recipeBuilder : this.recipes.values()) {
            JsonObject json = new JsonObject();
            HashMap<String, JsonObject> subRecipes = new HashMap<String, JsonObject>();
            subRecipes.put("", json);
            json.addProperty("type", ((RecipeBuilder)recipeBuilder).serializer);
            if (recipeBuilder instanceof ShapedRecipeBuilder) {
                Object character2;
                HashSet<Character> characters = new HashSet<Character>();
                for (String row : ((ShapedRecipeBuilder)recipeBuilder).pattern) {
                    for (char c : row.toCharArray()) {
                        if (c == ' ' || !characters.add(Character.valueOf(c)) || ((ShapedRecipeBuilder)recipeBuilder).inputs.containsKey(Character.valueOf(c))) continue;
                        throw new RuntimeException("Recipe '" + recipeBuilder.identifier + "' is missing an input for character '" + c + "'!");
                    }
                }
                for (Object character2 : ((ShapedRecipeBuilder)recipeBuilder).inputs.keySet()) {
                    if (characters.contains(character2)) continue;
                    throw new RuntimeException("Recipe '" + recipeBuilder.identifier + "' has unused input with key '" + character2 + "'!");
                }
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                json.add("pattern", (JsonElement)RecipeGenerator.createArray(((ShapedRecipeBuilder)recipeBuilder).pattern));
                JsonObject keysJson = new JsonObject();
                character2 = ((ShapedRecipeBuilder)recipeBuilder).inputs.entrySet().iterator();
                while (character2.hasNext()) {
                    Map.Entry input = (Map.Entry)character2.next();
                    keysJson.add(((Character)input.getKey()).toString(), ((IngredientExtension)input.getValue()).coreLibSerialize());
                }
                json.add("key", (JsonElement)keysJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output).toString());
                if (((RecipeBuilder)recipeBuilder).output.func_77614_k() || ((RecipeBuilder)recipeBuilder).output.func_77645_m() && ((RecipeBuilder)recipeBuilder).outputData >= 0) {
                    resultJson.addProperty("data", (Number)Math.max(((RecipeBuilder)recipeBuilder).outputData, 0));
                }
                if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                    resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
                }
                if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                    resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof ShapelessRecipeBuilder) {
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                JsonArray ingredientsJson = new JsonArray();
                for (Ingredient input : ((ShapelessRecipeBuilder)recipeBuilder).inputs) {
                    ingredientsJson.add(((IngredientExtension)input).coreLibSerialize());
                }
                json.add("ingredients", (JsonElement)ingredientsJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output).toString());
                if (((RecipeBuilder)recipeBuilder).output.func_77614_k() || ((RecipeBuilder)recipeBuilder).output.func_77645_m() && ((RecipeBuilder)recipeBuilder).outputData >= 0) {
                    resultJson.addProperty("data", (Number)Math.max(((RecipeBuilder)recipeBuilder).outputData, 0));
                }
                if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                    resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
                }
                if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                    resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof SmeltingRecipeBuilder) {
                JsonObject recipeJson;
                if (((SmeltingRecipeBuilder)recipeBuilder).includeBlasting) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:blasting");
                    RecipeGenerator.serializeCookingRecipe(recipeJson, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_blasting", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmoking) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:smoking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_smoking", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeCampfire) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:campfire_cooking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_campfire", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmelting) {
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 1, 200);
                } else {
                    subRecipes.remove("");
                }
            } else if (recipeBuilder instanceof StoneCuttingRecipeBuilder) {
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                json.add("ingredient", ((IngredientExtension)((StoneCuttingRecipeBuilder)recipeBuilder).input).coreLibSerialize());
                if (((RecipeBuilder)recipeBuilder).output.func_77614_k() || ((RecipeBuilder)recipeBuilder).output.func_77645_m() && ((RecipeBuilder)recipeBuilder).outputData >= 0) {
                    JsonObject resultJson = new JsonObject();
                    resultJson.addProperty("data", (Number)Math.max(((RecipeBuilder)recipeBuilder).outputData, 0));
                    resultJson.addProperty("result", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output).toString());
                    resultJson.add("result", (JsonElement)resultJson);
                } else {
                    json.addProperty("result", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output).toString());
                }
                if (((RecipeBuilder)recipeBuilder).output.func_77614_k() || ((RecipeBuilder)recipeBuilder).output.func_77645_m() && ((RecipeBuilder)recipeBuilder).outputData >= 0) {
                    json.addProperty("data", (Number)Math.max(((RecipeBuilder)recipeBuilder).outputData, 0));
                }
                json.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
            }
            for (Map.Entry subRecipe : subRecipes.entrySet()) {
                json = (JsonObject)subRecipe.getValue();
                if (!((RecipeBuilder)recipeBuilder).conditions.isEmpty()) {
                    json = ConditionalRecipeSerializer.wrapRecipe(json, ((RecipeBuilder)recipeBuilder).conditions);
                }
                ResourceLocation identifier = recipeBuilder.identifier;
                this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.func_110624_b(), "recipes", identifier.func_110623_a());
            }
        }
        this.advancements.save();
    }

    private static void serializeCookingRecipe(JsonObject json, SmeltingRecipeBuilder recipeBuilder, int durationDivider, int defaultDuration) {
        int duration;
        json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
        json.add("ingredient", ((IngredientExtension)recipeBuilder.input).coreLibSerialize());
        if (((RecipeBuilder)recipeBuilder).outputTag == null && ((RecipeBuilder)recipeBuilder).outputCount == 1) {
            json.addProperty("result", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output).toString());
        } else {
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output).toString());
            if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
            }
            if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
            }
            json.add("result", (JsonElement)resultJson);
        }
        if (recipeBuilder.experience != 0) {
            json.addProperty("experience", (Number)recipeBuilder.experience);
        }
        if ((duration = recipeBuilder.duration / durationDivider) != defaultDuration) {
            json.addProperty("cookingtime", (Number)duration);
        }
    }

    private static JsonArray createArray(Iterable<String> elements) {
        JsonArray array = new JsonArray();
        for (String element : elements) {
            array.add(element);
        }
        return array;
    }

    private static ResourceLocation getRecipeSerializerRegistration(IRecipeFactory serializer) {
        for (Map.Entry<ResourceLocation, IRecipeFactory> entry : CRAFTING_HELPER_RECIPES.get().entrySet()) {
            if (entry.getValue().getClass() != serializer.getClass()) continue;
            return entry.getKey();
        }
        return null;
    }

    protected <T extends RecipeBuilder<T>> T recipe(ResourceLocation recipeLocation, T builder) {
        if (this.recipes.containsKey(recipeLocation)) {
            throw new RuntimeException("Duplicate recipe '" + recipeLocation + "' of types '" + this.recipes.get(recipeLocation).getClass().getName() + "' and '" + builder.getClass().getName() + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, builder.identifier.func_110624_b(), "recipes", builder.identifier.func_110623_a(), ".json");
        this.recipes.put(recipeLocation, builder);
        return builder;
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.recipe(recipeLocation, new ShapedRecipeBuilder(recipeLocation, output, data, nbt, amount));
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, Item output, NBTTagCompound nbt, int amount) {
        return this.shaped(recipeLocation, output, -1, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, data, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, Item output, NBTTagCompound nbt, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.shaped(this.modid, identifier, output, data, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, Item output, NBTTagCompound nbt, int amount) {
        return this.shaped(this.modid, identifier, output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(Item output, int data, NBTTagCompound nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.shaped(identifier, output, data, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(Item output, NBTTagCompound nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.shaped(identifier, output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, Item output, int data, int amount) {
        return this.shaped(recipeLocation, output, data, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, Item output, int amount) {
        return this.shaped(recipeLocation, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, Item output, int data, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, data, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, Item output, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, Item output, int data, int amount) {
        return this.shaped(this.modid, identifier, output, data, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, Item output, int amount) {
        return this.shaped(this.modid, identifier, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(Item output, int data, int amount) {
        return this.shaped(output, data, null, amount);
    }

    protected ShapedRecipeBuilder shaped(Item output, int amount) {
        return this.shaped(output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, Item output) {
        return this.shaped(recipeLocation, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, Item output) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String identifier, Item output) {
        return this.shaped(this.modid, identifier, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(Item output) {
        return this.shaped(output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemStack output) {
        return this.shaped(recipeLocation, output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemStack output) {
        return this.shaped(new ResourceLocation(namespace, identifier), output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemStack output) {
        return this.shaped(this.modid, identifier, output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapedRecipeBuilder shaped(ItemStack output) {
        return this.shaped(output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.recipe(recipeLocation, new ShapelessRecipeBuilder(recipeLocation, output, data, nbt, amount));
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, Item output, NBTTagCompound nbt, int amount) {
        return this.shapeless(recipeLocation, output, -1, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, data, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, Item output, NBTTagCompound nbt, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.shapeless(this.modid, identifier, output, data, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, Item output, NBTTagCompound nbt, int amount) {
        return this.shapeless(this.modid, identifier, output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(Item output, int data, NBTTagCompound nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.shapeless(identifier, output, data, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(Item output, NBTTagCompound nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.shapeless(identifier, output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, Item output, int data, int amount) {
        return this.shapeless(recipeLocation, output, data, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, Item output, int amount) {
        return this.shapeless(recipeLocation, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, Item output, int data, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, data, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, Item output, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, Item output, int data, int amount) {
        return this.shapeless(this.modid, identifier, output, data, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, Item output, int amount) {
        return this.shapeless(this.modid, identifier, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(Item output, int data, int amount) {
        return this.shapeless(output, data, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(Item output, int amount) {
        return this.shapeless(output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, Item output) {
        return this.shapeless(recipeLocation, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, Item output) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, Item output) {
        return this.shapeless(this.modid, identifier, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(Item output) {
        return this.shapeless(output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemStack output) {
        return this.shapeless(recipeLocation, output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemStack output) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemStack output) {
        return this.shapeless(this.modid, identifier, output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(ItemStack output) {
        return this.shapeless(output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.recipe(recipeLocation, new SmeltingRecipeBuilder(recipeLocation, output, data, nbt, amount)).includeSmelting();
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, Item output, NBTTagCompound nbt, int amount) {
        return this.smelting(recipeLocation, output, -1, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, data, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, Item output, NBTTagCompound nbt, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, Item output, int data, NBTTagCompound nbt, int amount) {
        return this.smelting(this.modid, identifier, output, data, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, Item output, NBTTagCompound nbt, int amount) {
        return this.smelting(this.modid, identifier, output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(Item output, int data, NBTTagCompound nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.smelting(identifier, output, data, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(Item output, NBTTagCompound nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.smelting(identifier, output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, Item output, int data, int amount) {
        return this.smelting(recipeLocation, output, data, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, Item output, int amount) {
        return this.smelting(recipeLocation, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, Item output, int data, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, data, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, Item output, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, Item output, int data, int amount) {
        return this.smelting(this.modid, identifier, output, data, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, Item output, int amount) {
        return this.smelting(this.modid, identifier, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(Item output, int data, int amount) {
        return this.smelting(output, data, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(Item output, int amount) {
        return this.smelting(output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, Item output) {
        return this.smelting(recipeLocation, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, Item output) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, Item output) {
        return this.smelting(this.modid, identifier, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(Item output) {
        return this.smelting(output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemStack output) {
        return this.smelting(recipeLocation, output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemStack output) {
        return this.smelting(new ResourceLocation(namespace, identifier), output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemStack output) {
        return this.smelting(this.modid, identifier, output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(ItemStack output) {
        return this.smelting(output.func_77973_b(), output.func_77981_g() ? output.func_77960_j() : -1, output.func_77942_o() && !output.func_77978_p().func_82582_d() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, Item output, int data, int amount) {
        return this.recipe(recipeLocation, new StoneCuttingRecipeBuilder(recipeLocation, output, data, amount));
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, Item output, int amount) {
        return this.stoneCutting(recipeLocation, output, -1, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, Item output, int data, int amount) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, data, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, Item output, int amount) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, Item output, int data, int amount) {
        return this.stoneCutting(this.modid, identifier, output, data, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, Item output, int amount) {
        return this.stoneCutting(this.modid, identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(Item output, int data, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.stoneCutting(identifier, output, data, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(Item output, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output);
        return this.stoneCutting(identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, Item output) {
        return this.stoneCutting(recipeLocation, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, Item output) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, Item output) {
        return this.stoneCutting(this.modid, identifier, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(Item output) {
        return this.stoneCutting(output, 1);
    }

    @Override
    public String getName() {
        return this.modName + " Recipe Generator";
    }

    static {
        try {
            Field field = CraftingHelper.class.getDeclaredField("recipes");
            field.setAccessible(true);
            CRAFTING_HELPER_RECIPES = () -> {
                try {
                    return (Map)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private final class Advancements
    extends AdvancementGenerator {
        public Advancements(String modid, ResourceCache cache) {
            super(modid, cache);
        }

        @Override
        public void generate() {
            for (RecipeBuilder recipe : RecipeGenerator.this.recipes.values()) {
                if (!recipe.hasAdvancement) continue;
                CreativeTabs tab = recipe.output.func_77640_w();
                String namespace = recipe.identifier.func_110624_b();
                String identifier = "recipes/" + (tab == null ? "" : tab.func_78013_b() + "/") + recipe.identifier.func_110623_a();
                if (recipe instanceof SmeltingRecipeBuilder) {
                    if (((SmeltingRecipeBuilder)recipe).includeSmelting) {
                        this.createAdvancement(namespace, identifier + "_smelting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeBlasting) {
                        this.createAdvancement(namespace, identifier + "_blasting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeSmoking) {
                        this.createAdvancement(namespace, identifier + "_smoking", recipe);
                    }
                    if (!((SmeltingRecipeBuilder)recipe).includeCampfire) continue;
                    this.createAdvancement(namespace, identifier + "_campfire", recipe);
                    continue;
                }
                this.createAdvancement(namespace, identifier, recipe);
            }
        }

        private void createAdvancement(String namespace, String identifier, RecipeBuilder<?> recipe) {
            AdvancementGenerator.AdvancementBuilder builder = this.advancement(namespace, identifier).parent(new ResourceLocation("minecraft", "recipes/root")).criterion("has_the_recipe", new FakeRecipeUnlockedTrigger(recipe.identifier)).icon(((RecipeBuilder)recipe).output, ((RecipeBuilder)recipe).outputTag).dontShowToast().dontAnnounceToChat().rewardRecipe(recipe.identifier);
            String[] triggers = new String[((RecipeBuilder)recipe).unlockedBy.size() + 1];
            triggers[0] = "has_the_recipe";
            if (((RecipeBuilder)recipe).unlockedBy.size() == 1) {
                builder.criterion("recipe_condition", (ICriterionInstance)((RecipeBuilder)recipe).unlockedBy.get(0));
                triggers[1] = "recipe_condition";
            } else {
                for (int i = 0; i < ((RecipeBuilder)recipe).unlockedBy.size(); ++i) {
                    builder.criterion("recipe_condition" + (i + 1), (ICriterionInstance)((RecipeBuilder)recipe).unlockedBy.get(i));
                    triggers[i + 1] = "recipe_condition" + (i + 1);
                }
            }
            builder.requirementGroup(triggers);
            ((RecipeBuilder)recipe).conditions.forEach(builder::condition);
        }

        private class FakeRecipeUnlockedTrigger
        implements ICriterionInstance,
        ICriterionInstanceExtension {
            private final ResourceLocation recipeLocation;

            private FakeRecipeUnlockedTrigger(ResourceLocation recipeLocation) {
                this.recipeLocation = recipeLocation;
            }

            public ResourceLocation func_192244_a() {
                return new ResourceLocation("recipe_unlocked");
            }

            @Override
            public void coreLibSerialize(JsonObject json) {
                json.addProperty("recipe", this.recipeLocation.toString());
            }
        }
    }

    protected static class StoneCuttingRecipeBuilder
    extends RecipeBuilder<StoneCuttingRecipeBuilder> {
        private Ingredient input;

        private StoneCuttingRecipeBuilder(ResourceLocation identifier, Item output, int outputData, int outputCount) {
            super(identifier, "minecraft:stonecutting", output, outputData, null, outputCount);
        }

        public StoneCuttingRecipeBuilder input(Ingredient ingredient) {
            this.input = ingredient;
            return this;
        }

        public StoneCuttingRecipeBuilder input(Ingredient ... ingredients) {
            return this.input(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public StoneCuttingRecipeBuilder input(Item ... items) {
            return this.input(Ingredient.func_193368_a((Item[])items));
        }

        public StoneCuttingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public StoneCuttingRecipeBuilder input(String oreDict) {
            return this.input((Ingredient)new OreIngredient(oreDict));
        }
    }

    protected static class SmeltingRecipeBuilder
    extends RecipeBuilder<SmeltingRecipeBuilder> {
        private boolean includeSmelting;
        private boolean includeBlasting;
        private boolean includeCampfire;
        private boolean includeSmoking;
        private Ingredient input;
        private int experience;
        private int duration = 200;

        private SmeltingRecipeBuilder(ResourceLocation identifier, Item output, int outputData, NBTTagCompound outputTag, int count) {
            super(identifier, "minecraft:smelting", output, outputData, outputTag, count);
        }

        public SmeltingRecipeBuilder includeSmelting(boolean includeSmelting) {
            this.includeSmelting = includeSmelting;
            return this;
        }

        public SmeltingRecipeBuilder includeSmelting() {
            return this.includeSmelting(true);
        }

        public SmeltingRecipeBuilder includeBlasting(boolean includeBlasting) {
            this.includeBlasting = includeBlasting;
            return this;
        }

        public SmeltingRecipeBuilder includeBlasting() {
            return this.includeBlasting(true);
        }

        public SmeltingRecipeBuilder includeCampfire(boolean includeCampfire) {
            this.includeCampfire = includeCampfire;
            return this;
        }

        public SmeltingRecipeBuilder includeCampfire() {
            return this.includeCampfire(true);
        }

        public SmeltingRecipeBuilder includeSmoking(boolean includeSmoking) {
            this.includeSmoking = includeSmoking;
            return this;
        }

        public SmeltingRecipeBuilder includeSmoking() {
            return this.includeSmoking(true);
        }

        public SmeltingRecipeBuilder input(Ingredient ingredient) {
            this.input = ingredient;
            return this;
        }

        public SmeltingRecipeBuilder input(Ingredient ... ingredients) {
            return this.input(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmeltingRecipeBuilder input(Item ... items) {
            return this.input(Ingredient.func_193368_a((Item[])items));
        }

        public SmeltingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public SmeltingRecipeBuilder input(String oreDict) {
            return this.input((Ingredient)new OreIngredient(oreDict));
        }

        public SmeltingRecipeBuilder experience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Experience for recipe '" + this.identifier + "' cannot be negative!");
            }
            this.experience = experience;
            return this;
        }

        public SmeltingRecipeBuilder duration(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("Duration for recipe '" + this.identifier + "' must be greater than 0!");
            }
            this.duration = ticks;
            return this;
        }

        public SmeltingRecipeBuilder durationSeconds(int seconds) {
            return this.duration(seconds * 20);
        }
    }

    protected static class ShapelessRecipeBuilder
    extends RecipeBuilder<ShapelessRecipeBuilder> {
        private final List<Ingredient> inputs = new ArrayList<Ingredient>();

        private ShapelessRecipeBuilder(ResourceLocation identifier, Item output, int outputData, NBTTagCompound outputTag, int outputCount) {
            super(identifier, "forge:ore_shapeless", output, outputData, outputTag, outputCount);
        }

        public ShapelessRecipeBuilder input(Ingredient ingredient, int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("Cannot add an ingredient '" + count + "' times to recipe '" + this.identifier + "'!");
            }
            if (this.inputs.size() + count > 9) {
                throw new RuntimeException("Recipe '" + this.identifier + "' can have at most 9 inputs!");
            }
            for (int i = 0; i < count; ++i) {
                this.inputs.add(ingredient);
            }
            return this;
        }

        public ShapelessRecipeBuilder input(Ingredient ingredient) {
            return this.input(ingredient, 1);
        }

        public ShapelessRecipeBuilder input(Item item, int count) {
            return this.input(Ingredient.func_193367_a((Item)item), count);
        }

        public ShapelessRecipeBuilder input(Item item) {
            return this.input(item, 1);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack, int count) {
            return this.input(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack}), count);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack) {
            return this.input(itemStack, 1);
        }

        public ShapelessRecipeBuilder input(String oreDict, int count) {
            return this.input((Ingredient)new OreIngredient(oreDict), count);
        }

        public ShapelessRecipeBuilder input(String oreDict) {
            return this.input(oreDict, 1);
        }

        public ShapelessRecipeBuilder inputs(Ingredient ... ingredients) {
            for (Ingredient ingredient : ingredients) {
                this.input(ingredient);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(Item ... items) {
            for (Item item : items) {
                this.input(item);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(ItemStack ... itemStacks) {
            for (ItemStack itemStack : itemStacks) {
                this.input(itemStack);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(String ... oreDicts) {
            for (String oreDict : oreDicts) {
                this.input(oreDict);
            }
            return this;
        }
    }

    protected static class ShapedRecipeBuilder
    extends RecipeBuilder<ShapedRecipeBuilder> {
        private final List<String> pattern = new ArrayList<String>();
        private final Map<Character, Ingredient> inputs = new HashMap<Character, Ingredient>();

        private ShapedRecipeBuilder(ResourceLocation identifier, Item output, int outputData, NBTTagCompound outputTag, int outputCount) {
            super(identifier, "forge:ore_shaped", output, outputData, outputTag, outputCount);
        }

        public ShapedRecipeBuilder pattern(String row) {
            if (row.isEmpty()) {
                throw new IllegalArgumentException("Pattern row for recipe '" + this.identifier + "' cannot be empty!");
            }
            if (row.length() > 3) {
                throw new IllegalArgumentException("Pattern row for recipe '" + this.identifier + "' can have at most 3 characters, not '" + row.length() + "'!");
            }
            for (String otherRow : this.pattern) {
                if (row.length() == otherRow.length()) continue;
                throw new IllegalArgumentException("Pattern rows for recipe '" + this.identifier + "' must have the same length!");
            }
            this.pattern.add(row);
            return this;
        }

        public ShapedRecipeBuilder pattern(String ... rows) {
            for (String row : rows) {
                this.pattern(row);
            }
            return this;
        }

        public ShapedRecipeBuilder input(char key, Ingredient ingredient) {
            if (this.inputs.containsKey(Character.valueOf(key))) {
                throw new RuntimeException("Duplicate key '" + key + "' for recipe '" + this.identifier + "'!");
            }
            this.inputs.put(Character.valueOf(key), ingredient);
            return this;
        }

        public ShapedRecipeBuilder input(char key, Ingredient ... ingredients) {
            return this.input(key, Ingredient.merge(Arrays.asList(ingredients)));
        }

        public ShapedRecipeBuilder input(char key, Item ... items) {
            return this.input(key, Ingredient.func_193368_a((Item[])items));
        }

        public ShapedRecipeBuilder input(char key, ItemStack ... itemStacks) {
            return this.input(key, Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public ShapedRecipeBuilder input(char key, String oreDict) {
            return this.input(key, (Ingredient)new OreIngredient(oreDict));
        }
    }

    public static abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
        protected final ResourceLocation identifier;
        private final List<ResourceCondition> conditions = new ArrayList<ResourceCondition>();
        private final Item output;
        private final int outputData;
        private final NBTTagCompound outputTag;
        private final int outputCount;
        private String serializer;
        private String group;
        private boolean hasAdvancement = true;
        private final List<ICriterionInstance> unlockedBy = new ArrayList<ICriterionInstance>();

        protected RecipeBuilder(ResourceLocation identifier, String serializer, Item output, int outputData, NBTTagCompound outputTag, int outputCount) {
            this.identifier = identifier;
            this.output = output;
            this.outputData = outputData;
            this.outputTag = outputTag;
            this.outputCount = outputCount;
            this.serializer = serializer;
        }

        public T group(String group) {
            this.group = group == null || group.trim().isEmpty() ? null : group;
            return this.self();
        }

        public T condition(ResourceCondition condition) {
            this.conditions.add(condition);
            return this.self();
        }

        public T notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public T advancement(boolean generate) {
            this.hasAdvancement = generate;
            return this.self();
        }

        public T noAdvancement() {
            return this.advancement(false);
        }

        public T unlockedBy(ICriterionInstance criterion) {
            if (this.unlockedBy.contains(criterion)) {
                throw new RuntimeException("Duplicate unlockedBy criterion '" + criterion + "'!");
            }
            this.unlockedBy.add(criterion);
            return this.self();
        }

        public T unlockedBy(Item ... items) {
            return this.unlockedBy((ICriterionInstance)new InventoryChangeTrigger.Instance(MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, (ItemPredicate[])Arrays.stream(items).map(item -> new ItemPredicate(item, Integer.valueOf(0), MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new EnchantmentPredicate[0], null, NBTPredicate.field_193479_a)).toArray(ItemPredicate[]::new)));
        }

        public T unlockedBy(ItemStack ... items) {
            return this.unlockedBy((ICriterionInstance)new InventoryChangeTrigger.Instance(MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, (ItemPredicate[])Arrays.stream(items).map(item -> new ItemPredicate(item.func_77973_b(), Integer.valueOf(item.func_77960_j()), MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new EnchantmentPredicate[0], null, NBTPredicate.field_193479_a)).toArray(ItemPredicate[]::new)));
        }

        public T unlockedByOreDict(String ore) {
            return this.unlockedBy((ICriterionInstance)new InventoryChangeTrigger.Instance(MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new ItemPredicate[]{new OredictItemPredicate(ore)}));
        }

        public T customSerializer(IRecipeFactory serializer) {
            ResourceLocation identifier = RecipeGenerator.getRecipeSerializerRegistration(serializer);
            if (identifier == null) {
                throw new IllegalArgumentException("Cannot use unregistered recipe factory '" + serializer.getClass() + "' for recipe '" + this.identifier + "'!");
            }
            this.serializer = identifier.toString();
            return this.self();
        }

        public T customSerializer(ResourceLocation serializer) {
            if (!((Map)CRAFTING_HELPER_RECIPES.get()).containsKey(serializer)) {
                throw new IllegalArgumentException("Cannot use unknown recipe factory '" + serializer + "' for recipe '" + this.identifier + "'!");
            }
            this.serializer = serializer.toString();
            return this.self();
        }

        private T self() {
            return (T)this;
        }
    }
}

