/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public abstract class BlockStateGenerator
extends ResourceGenerator {
    private final Map<Block, BlockStateBuilder> blockStates = new HashMap<Block, BlockStateBuilder>();

    public BlockStateGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (BlockStateBuilder blockStateBuilder : this.blockStates.values()) {
            ResourceLocation block = Registries.BLOCKS.getIdentifier(blockStateBuilder.block);
            JsonObject json = new JsonObject();
            JsonObject variantsJson = new JsonObject();
            for (Map.Entry variantEntry : blockStateBuilder.variants.entrySet()) {
                if (((VariantBuilder)variantEntry.getValue()).models.isEmpty()) continue;
                String name = BlockStateGenerator.formatVariantName((PartialBlockState)variantEntry.getKey());
                variantsJson.add(name, this.serializeVariant((VariantBuilder)variantEntry.getValue(), block));
            }
            if (variantsJson.size() > 0) {
                json.add("variants", (JsonElement)variantsJson);
            }
            JsonArray multipartsJson = new JsonArray();
            for (Pair multipartEntry : blockStateBuilder.multipartVariants) {
                if (((VariantBuilder)multipartEntry.right()).models.isEmpty()) continue;
                JsonObject multipartJson = new JsonObject();
                multipartJson.add("apply", this.serializeVariant((VariantBuilder)multipartEntry.right(), block));
                ((MultipartConditionBuilder)multipartEntry.left()).flatten();
                JsonArray whenJson = new JsonArray();
                for (MultipartConditionBuilder condition : ((MultipartConditionBuilder)multipartEntry.left()).or) {
                    if (condition.properties.isEmpty()) continue;
                    JsonObject conditionJson = new JsonObject();
                    condition.properties.forEach((property, values) -> conditionJson.addProperty(property.func_177701_a(), Arrays.stream(values).map(arg_0 -> ((IProperty)property).func_177702_a(arg_0)).collect(Collectors.joining("|"))));
                    whenJson.add((JsonElement)conditionJson);
                }
                if (whenJson.size() == 1) {
                    multipartJson.add("when", whenJson.get(0));
                } else if (whenJson.size() != 0) {
                    JsonObject newWhenJson = new JsonObject();
                    newWhenJson.add("OR", (JsonElement)whenJson);
                    multipartJson.add("when", (JsonElement)newWhenJson);
                }
                multipartsJson.add((JsonElement)multipartJson);
            }
            if (multipartsJson.size() != 0) {
                json.add("multipart", (JsonElement)multipartsJson);
            }
            if (variantsJson.size() == 0 && multipartsJson.size() == 0) {
                throw new RuntimeException("Block state for block '" + block + "' is empty!");
            }
            this.cache.saveJsonResource(ResourceType.ASSET, json, block.func_110624_b(), "blockstates", block.func_110623_a());
        }
    }

    private JsonElement serializeVariant(VariantBuilder builder, ResourceLocation block) {
        JsonObject[] models = new JsonObject[builder.models.size()];
        for (int i = 0; i < models.length; ++i) {
            VariantModel model = (VariantModel)builder.models.get(i);
            JsonObject modelJson = new JsonObject();
            String name = model.modelLocation.func_110623_a();
            String extension = ".json";
            if (name.lastIndexOf(46) > name.lastIndexOf(47) && name.lastIndexOf(46) + 1 < name.length()) {
                int index = name.lastIndexOf(46);
                extension = name.substring(index + 1);
                name = name.substring(0, index);
            }
            if (!this.cache.doesResourceExist(ResourceType.ASSET, model.modelLocation.func_110624_b(), "models", name, extension)) {
                throw new RuntimeException("Could not find model '" + model.modelLocation + "' in block state for block '" + block + "'!");
            }
            if (model.modelLocation.func_110623_a().startsWith("block/")) {
                modelJson.addProperty("model", model.modelLocation.func_110624_b() + ":" + model.modelLocation.func_110623_a().substring("block/".length()));
            } else {
                modelJson.addProperty("type", "supermartijn642corelib:any_model_location");
                modelJson.addProperty("model", model.modelLocation.toString());
            }
            if (model.xRotation != 0) {
                modelJson.addProperty("x", (Number)model.xRotation);
            }
            if (model.yRotation != 0) {
                modelJson.addProperty("y", (Number)model.yRotation);
            }
            if (model.uvLock) {
                modelJson.addProperty("uvlock", Boolean.valueOf(true));
            }
            if (model.weight != 1 && models.length > 1) {
                modelJson.addProperty("weight", (Number)model.weight);
            }
            models[i] = modelJson;
        }
        return models.length > 1 ? BlockStateGenerator.createJsonArray((JsonElement[])models) : models[0];
    }

    private static JsonArray createJsonArray(JsonElement ... elements) {
        JsonArray array = new JsonArray();
        for (JsonElement element : elements) {
            array.add(element);
        }
        return array;
    }

    private static String formatVariantName(PartialBlockState state) {
        String name = state.properties.entrySet().stream().sorted(Comparator.comparing(entry -> ((IProperty)entry.getKey()).func_177701_a())).map(entry -> ((IProperty)entry.getKey()).func_177701_a() + "=" + ((IProperty)entry.getKey()).func_177702_a((Comparable)entry.getValue())).collect(Collectors.joining(","));
        return name.isEmpty() ? "normal" : name;
    }

    protected PartialBlockStateBuilder createPartialStateBuilder(Block block) {
        return new PartialBlockStateBuilder(block);
    }

    protected PartialBlockState createEmptyPartialState(Block block) {
        return this.createPartialStateBuilder(block).build();
    }

    protected PartialBlockState createPartialState(IBlockState state) {
        return this.createPartialStateBuilder(state.func_177230_c()).copy(state).build();
    }

    protected BlockStateBuilder blockState(Block block) {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier(block);
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, identifier.func_110624_b(), "blockstates", identifier.func_110623_a(), ".json");
        return this.blockStates.computeIfAbsent(block, o -> new BlockStateBuilder(this.modid, (Block)o));
    }

    @Override
    public String getName() {
        return this.modName + " Block State Generator";
    }

    protected static class PartialBlockStateBuilder {
        private final Block block;
        private final Map<IProperty<?>, Comparable<?>> properties = new HashMap();

        protected PartialBlockStateBuilder(Block block) {
            this.block = block;
        }

        public <T extends Comparable<T>> PartialBlockStateBuilder set(IProperty<T> property, T value) {
            if (!this.block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            if (!property.func_177700_c().contains(value)) {
                throw new IllegalArgumentException("Value '" + value + "' does not belong to property '" + property + "'!");
            }
            this.properties.put(property, value);
            return this;
        }

        public PartialBlockStateBuilder copy(IBlockState state) {
            if (this.block != state.func_177230_c()) {
                throw new IllegalArgumentException("Cannot copy properties of state for block '" + Registries.BLOCKS.getIdentifier(state.func_177230_c()) + "' to block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            this.properties.putAll((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
            return this;
        }

        public boolean has(IProperty<?> property) {
            return this.properties.containsKey(property);
        }

        public <T extends Comparable<T>> T get(IProperty<T> property) {
            if (!this.block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            return (T)this.properties.get(property);
        }

        public PartialBlockState build() {
            return new PartialBlockState(this.block, this.properties);
        }
    }

    protected static class PartialBlockState {
        private final Block block;
        private final Map<IProperty<?>, Comparable<?>> properties;

        protected PartialBlockState(Block block, Map<IProperty<?>, Comparable<?>> properties) {
            this.block = block;
            this.properties = ImmutableMap.copyOf(properties);
        }

        public Block getBlock() {
            return this.block;
        }

        public boolean has(IProperty<?> property) {
            return this.properties.containsKey(property);
        }

        public <T extends Comparable<T>> T get(IProperty<T> property) {
            if (!this.block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            return (T)this.properties.get(property);
        }
    }

    protected static class MultipartConditionBuilder {
        private final Block block;
        private final Map<IProperty<?>, Comparable<?>[]> properties = new HashMap();
        private final List<MultipartConditionBuilder> or = new ArrayList<MultipartConditionBuilder>();

        private MultipartConditionBuilder(Block block) {
            this.block = block;
        }

        public <T extends Comparable<T>> MultipartConditionBuilder requireProperty(IProperty<T> property, T ... acceptedValues) {
            if (acceptedValues.length == 0) {
                throw new RuntimeException("Accepted values cannot be empty for multipart condition property!");
            }
            if (this.properties.containsKey(property)) {
                throw new RuntimeException("Duplicate requirements for property '" + property + "' for multipart condition for block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            if (!this.block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            for (T value : acceptedValues) {
                if (property.func_177700_c().contains(value)) continue;
                throw new IllegalArgumentException("Value '" + value + "' does not belong to property '" + property + "'!");
            }
            this.properties.put(property, (Comparable<?>[])acceptedValues);
            return this;
        }

        public MultipartConditionBuilder or(Consumer<MultipartConditionBuilder> alternativeBuilderConsumer) {
            MultipartConditionBuilder builder = new MultipartConditionBuilder(this.block);
            alternativeBuilderConsumer.accept(builder);
            if (builder.properties.isEmpty()) {
                throw new IllegalArgumentException("Alternative condition cannot be empty!");
            }
            this.or.add(builder);
            return this;
        }

        public MultipartConditionBuilder or() {
            MultipartConditionBuilder builder = new MultipartConditionBuilder(this.block);
            this.or.add(builder);
            return builder;
        }

        private void flatten() {
            this.or.add(0, this);
            for (int i = 1; i < this.or.size(); ++i) {
                this.or.addAll(this.or.get((int)i).or);
            }
        }
    }

    protected static class VariantModel {
        public final ResourceLocation modelLocation;
        public final int xRotation;
        public final int yRotation;
        public final boolean uvLock;
        public final int weight;

        public VariantModel(ResourceLocation modelLocation, int xRotation, int yRotation, boolean uvLock, int weight) {
            this.modelLocation = modelLocation;
            this.xRotation = xRotation;
            this.yRotation = yRotation;
            this.uvLock = uvLock;
            this.weight = weight;
        }
    }

    protected static class VariantBuilder {
        private final String modid;
        private final List<VariantModel> models = new ArrayList<VariantModel>();

        protected VariantBuilder(String modid) {
            this.modid = modid;
        }

        public VariantBuilder model(ResourceLocation modelLocation, int xRotation, int yRotation, boolean uvLock, int weight) {
            this.models.add(new VariantModel(modelLocation, xRotation, yRotation, uvLock, weight));
            return this;
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation, boolean uvLock, int weight) {
            return this.model(new ResourceLocation(namespace, identifier), xRotation, yRotation, uvLock, weight);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation, boolean uvLock, int weight) {
            return this.model(this.modid, identifier, xRotation, yRotation, uvLock, weight);
        }

        public VariantBuilder model(ResourceLocation modelLocation, int xRotation, int yRotation, boolean uvLock) {
            return this.model(modelLocation, xRotation, yRotation, uvLock, 1);
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation, boolean uvLock) {
            return this.model(new ResourceLocation(namespace, identifier), xRotation, yRotation, uvLock);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation, boolean uvLock) {
            return this.model(this.modid, identifier, xRotation, yRotation, uvLock);
        }

        public VariantBuilder model(ResourceLocation modelLocation, int xRotation, int yRotation) {
            return this.model(modelLocation, xRotation, yRotation, false, 1);
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation) {
            return this.model(new ResourceLocation(namespace, identifier), xRotation, yRotation);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation) {
            return this.model(this.modid, identifier, xRotation, yRotation);
        }

        public VariantBuilder model(ResourceLocation modelLocation) {
            return this.model(modelLocation, 0, 0, false, 1);
        }

        public VariantBuilder model(String namespace, String identifier) {
            return this.model(new ResourceLocation(namespace, identifier));
        }

        public VariantBuilder model(String identifier) {
            return this.model(this.modid, identifier);
        }
    }

    protected class BlockStateBuilder {
        private final String modid;
        private final Block block;
        private final Map<PartialBlockState, VariantBuilder> variants = new LinkedHashMap<PartialBlockState, VariantBuilder>();
        private final List<Pair<MultipartConditionBuilder, VariantBuilder>> multipartVariants = new ArrayList<Pair<MultipartConditionBuilder, VariantBuilder>>();

        public BlockStateBuilder(String modid, Block block) {
            this.modid = modid;
            this.block = block;
        }

        public BlockStateBuilder variant(PartialBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            if (state.block != this.block) {
                throw new IllegalArgumentException("Cannot use state from block '" + state.block + "' in block state builder for block '" + this.block + "'!");
            }
            variantBuilderConsumer.accept(this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
            return this;
        }

        public BlockStateBuilder variant(IBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.variant(BlockStateGenerator.this.createPartialState(state), variantBuilderConsumer);
        }

        public BlockStateBuilder emptyVariant(Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.variant(BlockStateGenerator.this.createEmptyPartialState(this.block), variantBuilderConsumer);
        }

        public BlockStateBuilder variantsForProperty(IProperty<?> property, BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            if (!this.block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            PartialBlockStateBuilder builder = BlockStateGenerator.this.createPartialStateBuilder(this.block);
            for (Comparable value : property.func_177700_c()) {
                PartialBlockState state = builder.set(property, value).build();
                variantBuilderConsumer.accept(state, this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
            }
            return this;
        }

        public BlockStateBuilder variantsForAllExcept(BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer, IProperty<?> ... excluded) {
            PartialBlockStateBuilder builder = BlockStateGenerator.this.createPartialStateBuilder(this.block);
            List<IProperty<?>> properties = this.block.func_176194_O().func_177623_d().stream().filter(property -> Arrays.stream(excluded).noneMatch(p -> p == property)).collect(Collectors.toList());
            this.loopThroughAll(builder, properties, 0, variantBuilderConsumer);
            return this;
        }

        private void loopThroughAll(PartialBlockStateBuilder builder, List<IProperty<?>> properties, int index, BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            if (index == properties.size()) {
                PartialBlockState state = builder.build();
                variantBuilderConsumer.accept(state, this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
                return;
            }
            IProperty<?> property = properties.get(index);
            for (Comparable value : property.func_177700_c()) {
                builder.set(property, value);
                this.loopThroughAll(builder, properties, index + 1, variantBuilderConsumer);
            }
        }

        public BlockStateBuilder variantsForAll(BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            return this.variantsForAllExcept(variantBuilderConsumer, new IProperty[0]);
        }

        public BlockStateBuilder multipart(Consumer<MultipartConditionBuilder> conditionBuilderConsumer, Consumer<VariantBuilder> variantBuilderConsumer) {
            MultipartConditionBuilder condition = new MultipartConditionBuilder(this.block);
            conditionBuilderConsumer.accept(condition);
            VariantBuilder variant = new VariantBuilder(this.modid);
            variantBuilderConsumer.accept(variant);
            this.multipartVariants.add(Pair.of(condition, variant));
            return this;
        }

        public BlockStateBuilder multipart(PartialBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            if (state.block != this.block) {
                throw new IllegalArgumentException("Cannot use state from block '" + state.block + "' in block state builder for block '" + this.block + "'!");
            }
            return this.multipart((MultipartConditionBuilder condition) -> state.properties.forEach((property, value) -> condition.requireProperty((IProperty)property, new Comparable[]{value})), variantBuilderConsumer);
        }

        public BlockStateBuilder multipart(IBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.multipart(BlockStateGenerator.this.createPartialState(state), variantBuilderConsumer);
        }

        public BlockStateBuilder unconditionalMultipart(Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.multipart(BlockStateGenerator.this.createEmptyPartialState(this.block), variantBuilderConsumer);
        }
    }
}

