/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.CoFHCore;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketIndexedChat;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.FakePlayer;

public class ChatHelper {
    public static final int cofhTempChatIndexServer = -661464083;
    public static final int cofhTempChatIndexClient = -1245781222;
    public static final boolean indexChat;

    public static ITextComponent getChatComponent(Object object) {
        if (object instanceof ITextComponent) {
            return (ITextComponent)object;
        }
        if (object instanceof String) {
            return new TextComponentString((String)object);
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).func_151000_E();
        }
        if (object instanceof StatBase) {
            return ((StatBase)object).func_150951_e();
        }
        if (object instanceof Entity) {
            return ((Entity)object).func_145748_c_();
        }
        if (object instanceof ICommandSender) {
            return ((ICommandSender)object).func_145748_c_();
        }
        return new TextComponentString(String.valueOf(object));
    }

    public static ITextComponent formChatComponent(Object ... chats) {
        ITextComponent chat = ChatHelper.getChatComponent(chats[0]);
        int chatsLength = chats.length;
        for (int i = 1; i < chatsLength; ++i) {
            chat.func_150257_a(ChatHelper.getChatComponent(chats[i]));
        }
        return chat;
    }

    public static ITextComponent translate(String key) {
        return new TextComponentTranslation(key, new Object[0]);
    }

    public static String toJSON(ITextComponent chatComponent) {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)chatComponent);
    }

    public static ITextComponent fromJSON(String string) {
        return ITextComponent.Serializer.func_186877_b((String)string);
    }

    public static void sendIndexedChatMessageToPlayer(EntityPlayer player, ITextComponent message) {
        if (player.field_70170_p == null || player instanceof FakePlayer) {
            return;
        }
        if (indexChat) {
            if (!player.field_70170_p.field_72995_K) {
                PacketHandler.sendTo((PacketBase)new PacketIndexedChat(message, -661464083), player);
            } else {
                CoFHCore.proxy.addIndexedChatMessage(message, -1245781222);
            }
        } else {
            player.func_145747_a(message);
        }
    }

    public static void sendIndexedChatMessagesToPlayer(EntityPlayer player, List<ITextComponent> messages) {
        if (player.field_70170_p == null || player instanceof FakePlayer) {
            return;
        }
        if (indexChat) {
            for (int i = 0; i < messages.size(); ++i) {
                if (!player.field_70170_p.field_72995_K) {
                    PacketHandler.sendTo((PacketBase)new PacketIndexedChat(messages.get(i), -661464083 + i), player);
                    continue;
                }
                CoFHCore.proxy.addIndexedChatMessage(messages.get(i), -1245781222 + i);
            }
        } else {
            for (ITextComponent message : messages) {
                player.func_145747_a(message);
            }
        }
    }

    static {
        String category = "gui.chat";
        CoFHCore.CONFIG_CLIENT.getCategory(category).setComment("The options in this section change core Minecraft behavior and are not limited to CoFH mods.");
        String comment = "Set to false to disable outdated CoFH info chat messages being removed from chat";
        indexChat = CoFHCore.CONFIG_CLIENT.get(category, "RemoveOutdatedChat", true, comment);
    }
}

