/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import xaero.hud.Hud;
import xaero.hud.module.HudModule;
import xaero.hud.module.ModuleSession;
import xaero.hud.preset.HudPreset;
import xaero.hud.pushbox.PushboxHandler;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public final class HudRenderer {
    private final PushboxHandler pushboxHandler;

    public HudRenderer(PushboxHandler pushboxHandler) {
        this.pushboxHandler = pushboxHandler;
    }

    public void render(Hud hud, float partialTicks) {
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        ModuleRenderContext renderContext = new ModuleRenderContext(new ScaledResolution(mc));
        this.pushboxHandler.updateAll(hud.getPushboxManager());
        if (mc.field_71462_r == null) {
            for (HudPreset hudPreset : hud.getPresetManager().getPresets()) {
                hudPreset.cancel();
            }
        }
        for (HudModule hudModule : hud.getModuleManager().getModules()) {
            this.renderModule(hudModule, hud, renderContext, partialTicks);
        }
        this.pushboxHandler.postUpdateAll(hud.getPushboxManager());
        GlStateManager.func_179126_j();
    }

    private <MS extends ModuleSession<MS>> void renderModule(HudModule<MS> module, Hud hud, ModuleRenderContext c, float partialTicks) {
        MS session = module.getCurrentSession();
        ((ModuleSession)session).prePotentialRender();
        if (!((ModuleSession)session).isActive()) {
            return;
        }
        if (module.getUsedTransform().fromOldSystem) {
            hud.getOldSystemCompatibility().convertTransform(module.getUsedTransform(), (ModuleSession<?>)session, c);
        }
        IModuleRenderer<MS> renderer = module.getRenderer();
        PushboxHandler.State currentPushState = module.getPushState();
        currentPushState.resetForModule((ModuleSession<?>)session, c.screenWidth, c.screenHeight, c.screenScale);
        this.pushboxHandler.applyScreenEdges(currentPushState, c.screenWidth, c.screenHeight, c.screenScale);
        this.pushboxHandler.applyPushboxes(hud.getPushboxManager(), currentPushState, c.screenWidth, c.screenHeight, c.screenScale);
        c.x = currentPushState.x;
        c.y = currentPushState.y;
        c.w = ((ModuleSession)session).getWidth(c.screenScale);
        c.h = ((ModuleSession)session).getHeight(c.screenScale);
        c.flippedVertically = ((ModuleSession)session).shouldFlipVertically(c.screenHeight, c.screenScale);
        c.flippedHorizontally = ((ModuleSession)session).shouldFlipHorizontally(c.screenWidth, c.screenScale);
        renderer.render(session, c, partialTicks);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public PushboxHandler getPushboxHandler() {
        return this.pushboxHandler;
    }
}

