/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModSettings;
import xaero.hud.HudSession;
import xaero.hud.controls.key.KeyMappingTickHandler;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.element.render.world.MinimapElementWorldRendererHandler;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointSession;

public class ClientEvents {
    private ClippingHelper clippingHelper;
    public static final RenderGameOverlayEvent.ElementType[] OVERLAY_LAYERS = new RenderGameOverlayEvent.ElementType[]{RenderGameOverlayEvent.ElementType.ALL, RenderGameOverlayEvent.ElementType.HELMET, RenderGameOverlayEvent.ElementType.HOTBAR, RenderGameOverlayEvent.ElementType.CROSSHAIRS, RenderGameOverlayEvent.ElementType.BOSSHEALTH, RenderGameOverlayEvent.ElementType.TEXT, RenderGameOverlayEvent.ElementType.POTION_ICONS, RenderGameOverlayEvent.ElementType.SUBTITLES, RenderGameOverlayEvent.ElementType.CHAT};
    private IXaeroMinimap modMain;
    private GuiScreen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private boolean crosshairDisabledByThisMod = false;
    public RealmsServer latestRealm;

    public ClientEvents(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(GuiOpenEvent event) {
        if (!this.modMain.isFirstStageLoaded()) {
            return;
        }
        if (event.getGui() instanceof GuiOptions) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setGui((GuiScreen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (event.getGui() instanceof GuiMainMenu || event.getGui() instanceof GuiMultiplayer) {
            this.modMain.getSettings().resetServerSettings();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getGui() instanceof GuiScreenRealmsProxy && ((GuiScreenRealmsProxy)event.getGui()).func_154321_a() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, "task", "field_19919", "Lnet/minecraft/class_4358;", "task");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(RealmsTasks.RealmsGetServerDetailsTask.class, "server", "field_20224", "Lnet/minecraft/class_4877;", "server");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((GuiScreenRealmsProxy)event.getGui()).func_154321_a())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        } else if ((event.getGui() instanceof GuiAddWaypoint || event.getGui() instanceof GuiWaypoints) && (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL))) {
            event.setGui(null);
        }
        this.lastGuiOpen = event.getGui();
    }

    protected void handleRenderModOverlayOverridable(float partialTicks, ScaledResolution resolution) {
        MultiplyAnimationHelper.tick();
        Minecraft.func_71410_x().field_71460_t.func_78478_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            this.modMain.getHudRenderer().render(this.modMain.getHud(), partialTicks);
            this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession, resolution);
            GlStateManager.func_179121_F();
            if (GuiIngameForge.renderCrosshairs && minimapSession.getProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
                GuiIngameForge.renderCrosshairs = false;
                this.crosshairDisabledByThisMod = true;
            }
        }
    }

    public void handleRenderModOverlay(float partialTicks, ScaledResolution resolution) {
        this.handleRenderModOverlayOverridable(partialTicks, resolution);
    }

    public void handleRenderGameOverlayEventPreAll(float partialTicks) {
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
            return;
        }
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null) {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            this.modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, partialTicks, minimapSession.getProcessor());
            if (this.clippingHelper == null) {
                this.clippingHelper = ClippingHelperImpl.func_78558_a();
            }
            Minecraft mc = Minecraft.func_71410_x();
            Vec3d renderPos = ActiveRenderInfo.getCameraPosition();
            renderPos = renderPos.func_178787_e(EntityUtils.getEntityPos(mc.func_175606_aa(), partialTicks));
            MinimapElementWorldRendererHandler worldRendererHandler = HudMod.INSTANCE.getMinimap().getWorldRendererHandler();
            GlStateManager.func_179126_j();
            worldRendererHandler.prepareRender(this.clippingHelper.field_178625_b, this.clippingHelper.field_178626_c);
            worldRendererHandler.render(renderPos, partialTicks, null, new ScaledResolution(mc), Misc.getDimensionTypeScale((World)mc.field_71441_e), mc.field_71441_e.field_73011_w.getDimension());
            GlStateManager.func_179097_i();
            GlStateManager.func_179128_n((int)5889);
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (!this.modMain.isLoadedClient()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            XaeroMinimapCore.onRenderStatusEffectOverlayPost();
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.modMain.getHud().getEventHandler().handleRenderGameOverlayEventPost();
            if (this.crosshairDisabledByThisMod) {
                GuiIngameForge.renderCrosshairs = true;
                this.crosshairDisabledByThisMod = false;
            }
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (e.getMessage().startsWith("xaero_waypoint_add:")) {
            String[] args = e.getMessage().replaceAll("\u00a7.", "").split(":");
            e.setMessage("");
            WaypointSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession().getWaypointSession();
            minimapSession.getSharing().onWaypointAdd(args);
        } else if (e.getMessage().equals("/xaero_tp_anyway")) {
            e.setMessage("");
            WaypointSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession().getWaypointSession();
            minimapSession.getTeleport().teleportAnyway();
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        Object minimapSession;
        if (e.getMessage() == null) {
            return;
        }
        String text = e.getMessage().func_150254_d();
        if (text.contains("xaero_waypoint:") || text.contains("xaero-waypoint:")) {
            minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            ((MinimapSession)minimapSession).getWaypointSession().getSharing().onWaypointReceived(text, e);
        } else {
            if (e.getType() == ChatType.SYSTEM && text.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                ((XaeroMinimapSession)minimapSession).getMinimapProcessor().setNoMinimapMessageReceived(false);
                ((XaeroMinimapSession)minimapSession).getMinimapProcessor().setFairPlayOnlyMessageReceived(false);
            }
            if (e.getType() == ChatType.SYSTEM && text.contains("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                ((XaeroMinimapSession)minimapSession).getMinimapProcessor().setNoMinimapMessageReceived(true);
            }
            if (e.getType() == ChatType.SYSTEM && text.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                ((XaeroMinimapSession)minimapSession).getMinimapProcessor().setFairPlayOnlyMessageReceived(true);
            }
        }
        if (text.contains("\u00a7c \u00a7r\u00a75 \u00a7r\u00a71 \u00a7r\u00a7f")) {
            String code = text.substring(text.indexOf("f") + 1);
            code = code.replace("\u00a7", "").replace("r", "").replace(" ", "");
            this.modMain.getSettings().resetServerSettings();
            this.modMain.getSettings();
            ModSettings.serverSettings &= Integer.parseInt(code);
            MinimapLogs.LOGGER.info("Code: " + code);
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon.needsNotification() && event.getGui() instanceof GuiMainMenu) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        Minimap minimap;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            minimapSession.getMinimapProcessor().getMinimapWriter().setClearBlockColours(true);
            minimapSession.getMinimapProcessor().getMinimapWriter().resetShortBlocks();
        }
        if ((minimap = this.modMain.getMinimap()) != null) {
            minimap.getMinimapFBORenderer().resetEntityIcons();
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        Minimap minimap = this.modMain.getMinimap();
        if (minimap != null) {
            minimap.getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    @SubscribeEvent
    public void handlePlayerSetSpawnEvent(PlayerSetSpawnEvent event) {
        MinimapSession minimapSession;
        if (event.getEntityPlayer().field_70170_p instanceof WorldClient && (minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession()) != null) {
            minimapSession.getWorldStateUpdater().setCurrentWorldSpawn(event.getNewSpawn());
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        XaeroMinimapSession minimapSession;
        if (event.getWorld() instanceof WorldClient && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.getRadarSession().update(null, null, null);
        }
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        XaeroMinimapSession minimapSession;
        if (event.phase == TickEvent.Phase.START && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.onClientTick();
            if (Minecraft.func_71410_x().field_71462_r == null) {
                minimapSession.getKeyMappingTickHandler().tick();
            }
            HudSession hudSession = HudSession.getCurrentSession();
            this.clientTickPostOverridable(hudSession);
        }
    }

    protected void clientTickPostOverridable(HudSession minimapSession) {
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!this.modMain.isLoadedClient()) {
            return;
        }
        if (event.side == Side.CLIENT && event.player == Minecraft.func_71410_x().field_71439_g) {
            try {
                MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
                if (minimapSession != null && event.phase == TickEvent.Phase.START) {
                    MinimapProcessor minimap = minimapSession.getProcessor();
                    minimapSession.getWorldStateUpdater().update();
                    minimap.onPlayerTick();
                    Minecraft mc = Minecraft.func_71410_x();
                    HudSession hudSession = HudSession.getCurrentSession();
                    this.playerTickPostOverridable(hudSession);
                }
            }
            catch (Throwable t) {
                this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(t);
            }
        }
    }

    protected void playerTickPostOverridable(HudSession hudSession) {
    }

    @SubscribeEvent
    public void handleInputEvent(InputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
        }
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
            if (!this.modMain.isLoadedClient()) {
                return;
            }
            this.modMain.getInterfaces().getMinimapInterface().checkCrashes();
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                MinimapProcessor minimap = minimapSession.getMinimapProcessor();
                minimap.getMinimapWriter().onRender();
            }
        }
    }

    protected void handleRenderGameOverlayEventPreOverridable(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == OVERLAY_LAYERS[this.modMain.getSettings().renderLayerIndex]) {
            this.handleRenderModOverlay(event.getPartialTicks(), event.getResolution());
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (!this.modMain.isLoadedClient()) {
            return;
        }
        this.handleRenderGameOverlayEventPreOverridable(event);
    }

    public boolean handleForceToggleKeyMapping(KeyBinding keyMapping) {
        if (KeyMappingTickHandler.DISABLE_KEY_MAPPING_OVERRIDES) {
            return false;
        }
        return this.handleForceToggleKeyMappingOverridable(keyMapping);
    }

    public boolean handleForceToggleKeyMappingOverridable(KeyBinding keyMapping) {
        return false;
    }
}

