/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.config;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import xaero.common.config.CommonConfig;
import xaero.hud.minimap.MinimapLogs;

public class CommonConfigIO {
    private final Path configFilePath;

    public CommonConfigIO(Path configFilePath) {
        this.configFilePath = configFilePath;
    }

    public void save(CommonConfig config) {
        try {
            Path parentFolder = this.configFilePath.getParent();
            if (parentFolder != null) {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            return;
        }
        try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(new FileOutputStream(this.configFilePath.toFile()));
             PrintWriter writer = new PrintWriter(bufferedOutput);){
            this.write(config, writer);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public CommonConfig load() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void write(CommonConfig config, PrintWriter writer) {
        writer.println("allowCaveModeOnServer:" + config.allowCaveModeOnServer);
        writer.println("allowNetherCaveModeOnServer:" + config.allowNetherCaveModeOnServer);
        writer.println("allowRadarOnServer:" + config.allowRadarOnServer);
        writer.println("registerStatusEffects:" + config.registerStatusEffects);
        writer.println("everyoneTracksEveryone:" + config.everyoneTracksEveryone);
    }

    private boolean readLine(CommonConfig.Builder configBuilder, String[] args) {
        if (args[0].equals("allowCaveModeOnServer")) {
            configBuilder.setAllowCaveModeOnServer(args[1].equals("true"));
            return true;
        }
        if (args[0].equals("allowNetherCaveModeOnServer")) {
            configBuilder.setAllowNetherCaveModeOnServer(args[1].equals("true"));
            return true;
        }
        if (args[0].equals("allowRadarOnServer")) {
            configBuilder.setAllowRadarOnServer(args[1].equals("true"));
            return true;
        }
        if (args[0].equals("registerStatusEffects")) {
            configBuilder.setRegisterStatusEffects(args[1].equals("true"));
            return true;
        }
        if (args[0].equals("everyoneTracksEveryone")) {
            configBuilder.setEveryoneTracksEveryone(args[1].equals("true"));
            return true;
        }
        return false;
    }
}

