/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages.waystone;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.Signpost;
import gollorum.signpost.blocks.BaseModelPost;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.WaystoneContainer;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.worldGen.villages.GenerateStructureHelper;
import gollorum.signpost.worldGen.villages.NameLibrary;
import gollorum.signpost.worldGen.villages.VillageLibrary;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageComponentWaystone
extends StructureVillagePieces.Village {
    private boolean built = false;
    private StructureVillagePieces.Start start;
    private EnumFacing facing;

    public VillageComponentWaystone() {
    }

    public VillageComponentWaystone(StructureVillagePieces.Start start, int type, StructureBoundingBox boundingBox, EnumFacing facing) {
        super(start, type);
        this.field_74887_e = boundingBox;
        this.start = start;
        this.facing = facing;
    }

    @Nullable
    public static StructureVillagePieces.Village buildComponent(StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int x, int y, int z, EnumFacing facing, int type) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)1, (int)1, (int)1, (EnumFacing)facing);
        if (VillageComponentWaystone.func_74895_a((StructureBoundingBox)boundingBox) && VillageComponentWaystone.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null) {
            return new VillageComponentWaystone(startPiece, type, boundingBox, facing.func_176734_d());
        }
        return null;
    }

    public boolean func_74875_a(final World world, final Random random, StructureBoundingBox boundingBox) {
        BlockPos finalPos;
        if (this.built || this.start == null || !NameLibrary.getInstance().namesLeft()) {
            return true;
        }
        this.built = true;
        final String name = NameLibrary.getInstance().getName(random);
        if (name == null) {
            return true;
        }
        int x = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
        int z = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
        BlockPos postPos = GenerateStructureHelper.getInstance().getTopSolidOrLiquidBlock(world, new BlockPos(x, 0, z));
        List<BaseModelPost> allowedModelTypes = Signpost.proxy.blockHandler.baseModelsForVillages();
        if (allowedModelTypes.size() == 0) {
            return true;
        }
        if (world.func_180495_p(postPos.func_177982_a(0, -1, 0)).func_185904_a().func_76224_d()) {
            IBlockState block = this.func_175847_a(Blocks.field_150344_f.func_176223_P());
            world.func_175656_a(postPos.func_177982_a(0, -1, 0), block);
        }
        if (world.func_180501_a(finalPos = postPos, allowedModelTypes.get(random.nextInt(allowedModelTypes.size())).getStateForFacing(this.facing), 3)) {
            SPEventHandler.scheduleTask(new BoolRun(){

                @Override
                public boolean run() {
                    TileEntity tile = world.func_175625_s(finalPos);
                    if (tile instanceof WaystoneContainer) {
                        if (PostHandler.getNativeWaystones().nameTaken(name)) {
                            VillageComponentWaystone.this.setupWaystone(NameLibrary.getInstance().getName(random), world, finalPos, (WaystoneContainer)tile);
                        } else {
                            VillageComponentWaystone.this.setupWaystone(name, world, finalPos, (WaystoneContainer)tile);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        return true;
    }

    private void setupWaystone(String name, World world, BlockPos postPos, WaystoneContainer container) {
        this.assureBaseInfo(container, world, new MyBlockPos(world, postPos), this.facing, name);
        StructureBoundingBox villageBox = this.start.func_74874_b();
        MyBlockPos villagePos = new MyBlockPos(world, villageBox.field_78897_a, 0, villageBox.field_78896_c);
        MyBlockPos blockPos = new MyBlockPos(world, postPos);
        VillageLibrary.getInstance().putWaystone(villagePos, blockPos);
    }

    private void assureBaseInfo(WaystoneContainer container, World world, MyBlockPos blockPos, EnumFacing facing, String name) {
        if (container.getBaseInfo() == null) {
            MyBlockPos telePos = GenerateStructureHelper.getInstance().getTopSolidOrLiquidBlock(blockPos.front(facing, 2));
            if (telePos.getWorld().func_180495_p(telePos.toBlockPos().func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_185774_da) {
                ++telePos.y;
            }
            BasePost.generate(world, blockPos, telePos, name);
        } else {
            container.setName(name);
        }
    }
}

