/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.code.MinecraftDependent;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.util.collections.Lurchsauna;
import gollorum.signpost.worldGen.villages.LibrarySignpostHelper;
import gollorum.signpost.worldGen.villages.LibraryWaystoneHelper;
import gollorum.signpost.worldGen.villages.VillagePost;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@MinecraftDependent
public class VillageLibrary {
    private static VillageLibrary INSTANCE = new VillageLibrary();
    private Map<MyBlockPos, MyBlockPos> villageWaystones = new Lurchpaerchensauna<MyBlockPos, MyBlockPos>();
    private Map<MyBlockPos, Set<VillagePost>> villagePosts = new Lurchpaerchensauna<MyBlockPos, Set<VillagePost>>();

    public static VillageLibrary getInstance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new VillageLibrary();
    }

    private VillageLibrary() {
    }

    public void putWaystone(final MyBlockPos villageLocation, final MyBlockPos waystoneLocation) {
        this.villageWaystones.put(villageLocation, waystoneLocation);
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (waystoneLocation.getTile() == null) {
                    return false;
                }
                new LibraryWaystoneHelper(villageLocation, VillageLibrary.this.villagePosts, waystoneLocation).enscribeEmptySign();
                return true;
            }
        });
    }

    public void putSignpost(final MyBlockPos villageLocation, final MyBlockPos signpostLocation, final double optimalRot) {
        Set<VillagePost> villageSignposts = this.villagePosts.get(villageLocation);
        if (villageSignposts == null) {
            villageSignposts = new Lurchsauna<VillagePost>();
            this.villagePosts.put(villageLocation, villageSignposts);
        }
        villageSignposts.add(new VillagePost(signpostLocation, optimalRot));
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (signpostLocation.getTile() == null) {
                    return false;
                }
                new LibrarySignpostHelper(villageLocation, signpostLocation, VillageLibrary.this.villageWaystones).enscribeNewSign(optimalRot);
                return true;
            }
        });
    }

    public void save(NBTTagCompound compound) {
        compound.func_74782_a("Waystones", (NBTBase)this.saveWaystones());
        compound.func_74782_a("Signposts", (NBTBase)this.savePosts());
    }

    private NBTTagCompound saveWaystones() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("WaystoneCount", this.villageWaystones.size());
        int i = 0;
        for (Map.Entry<MyBlockPos, MyBlockPos> now : this.villageWaystones.entrySet()) {
            compound.func_74782_a("Waystone" + i++, this.saveWaystone(now.getKey(), now.getValue()));
        }
        return compound;
    }

    private NBTBase saveWaystone(MyBlockPos villageLocation, MyBlockPos waystoneLocation) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("VillageLocation", (NBTBase)villageLocation.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("WaystoneLocation", (NBTBase)waystoneLocation.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    private NBTTagCompound savePosts() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("PostCount", this.villagePosts.size());
        int i = 0;
        for (Map.Entry<MyBlockPos, Set<VillagePost>> now : this.villagePosts.entrySet()) {
            compound.func_74782_a("Posts" + i++, this.savePostCollection(now.getKey(), now.getValue()));
        }
        return compound;
    }

    private NBTBase savePostCollection(MyBlockPos villageLocation, Set<VillagePost> posts) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("VillageLocation", (NBTBase)villageLocation.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("PostCount", posts.size());
        int i = 0;
        for (VillagePost now : posts) {
            compound.func_74782_a("Post" + i++, (NBTBase)now.save());
        }
        return compound;
    }

    public void load(NBTTagCompound compound) {
        this.loadWaystones(compound.func_74775_l("Waystones"));
        this.loadSignpost(compound.func_74775_l("Signposts"));
    }

    private void loadWaystones(NBTTagCompound compound) {
        this.villageWaystones = new Lurchpaerchensauna<MyBlockPos, MyBlockPos>();
        int count = compound.func_74762_e("WaystoneCount");
        for (int i = 0; i < count; ++i) {
            NBTTagCompound entry = compound.func_74775_l("Waystone" + i);
            MyBlockPos villageLocation = MyBlockPos.readFromNBT(entry.func_74775_l("VillageLocation"));
            MyBlockPos waystoneLocation = MyBlockPos.readFromNBT(entry.func_74775_l("WaystoneLocation"));
            this.villageWaystones.put(villageLocation, waystoneLocation);
        }
    }

    private void loadSignpost(NBTTagCompound compound) {
        this.villagePosts = new Lurchpaerchensauna<MyBlockPos, Set<VillagePost>>();
        int postCount = compound.func_74762_e("PostCount");
        for (int i = 0; i < postCount; ++i) {
            NBTTagCompound entry = compound.func_74775_l("Posts" + i);
            MyBlockPos villageLocation = MyBlockPos.readFromNBT(entry.func_74775_l("VillageLocation"));
            Set<VillagePost> posts = this.loadPostSet(entry);
            this.villagePosts.put(villageLocation, posts);
        }
    }

    private Set<VillagePost> loadPostSet(NBTTagCompound compound) {
        Lurchsauna<VillagePost> ret = new Lurchsauna<VillagePost>();
        int postCount = compound.func_74762_e("PostCount");
        for (int i = 0; i < postCount; ++i) {
            ret.add(VillagePost.load(compound.func_74775_l("Post" + i)));
        }
        return ret;
    }
}

