/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util.math.tracking;

public class DDDVector {
    public double x;
    public double y;
    public double z;

    public DDDVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DDDVector(DDDVector other) {
        this(other.x, other.y, other.z);
    }

    public DDDVector add(DDDVector other) {
        return new DDDVector(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public DDDVector substract(DDDVector other) {
        return new DDDVector(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public DDDVector mult(double fac) {
        return new DDDVector(this.x * fac, this.y * fac, this.z * fac);
    }

    public DDDVector neg() {
        return new DDDVector(-this.x, -this.y, -this.z);
    }

    public double sqrDistance(DDDVector other) {
        double dx = this.x - other.x;
        double dy = this.y - other.y;
        double dz = this.z - other.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(DDDVector other) {
        return Math.sqrt(this.sqrDistance(other));
    }

    public double getlength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public DDDVector setLength(double newLength) {
        double mult = newLength / this.getlength();
        return this.mult(mult);
    }

    public DDDVector xVec() {
        return new DDDVector(this.x, 0.0, 0.0);
    }

    public DDDVector yVec() {
        return new DDDVector(0.0, this.y, 0.0);
    }

    public DDDVector zVec() {
        return new DDDVector(0.0, 0.0, this.z);
    }

    public DDDVector rotX(double angle) {
        double a = angle + DDDVector.genAngle(this.z, this.y);
        double d = Math.sqrt(this.y * this.y + this.z * this.z);
        double y = d * Math.cos(a);
        double z = d * Math.sin(a);
        return new DDDVector(this.x, y, z);
    }

    public DDDVector rotY(double angle) {
        double a = angle + DDDVector.genAngle(this.x, this.z);
        double d = Math.sqrt(this.x * this.x + this.z * this.z);
        double z = d * Math.cos(a);
        double x = d * Math.sin(a);
        return new DDDVector(x, this.y, z);
    }

    public DDDVector rotZ(double angle) {
        double a = angle + DDDVector.genAngle(this.y, this.x);
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        double x = d * Math.cos(a);
        double y = d * Math.sin(a);
        return new DDDVector(x, y, this.z);
    }

    public static double genAngle(double axis1, double axis2) {
        if (axis2 == 0.0) {
            if (axis1 < 0.0) {
                return 4.71238898038469;
            }
            return 1.5707963267948966;
        }
        double ret = Math.atan(axis1 / Math.abs(axis2));
        return axis2 < 0.0 ? Math.PI - ret : (ret < 0.0 ? Math.PI + ret : ret);
    }

    public double rotAroundXToZ0() {
        double rot = -Math.atan(this.z / this.y);
        this.y = Math.sqrt(this.z * this.z + this.y * this.y);
        this.z = 0.0;
        return rot;
    }

    public double rotAroundZToX0() {
        double rot = 1.5707963267948966 - Math.atan(this.y / this.x);
        this.y = Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = 0.0;
        return rot;
    }

    public double rotAroundYToZ0() {
        double rot = 1.5707963267948966 - Math.atan(this.x / this.z);
        this.x = Math.sqrt(this.x * this.x + this.z * this.z);
        this.z = 0.0;
        return rot;
    }

    public DDDVector unrot(DDDVector rot) {
        return this.rotate(rot.mult(-1.0));
    }

    public DDDVector rotate(DDDVector rot) {
        DDDVector ret = new DDDVector(this);
        ret = ret.rotX(rot.x);
        ret = ret.rotY(rot.y);
        ret = ret.rotZ(rot.z);
        return ret;
    }

    public String toString() {
        return this.x + "|" + this.y + "|" + this.z;
    }

    public double[] toArray() {
        double[] ret = new double[]{this.x, this.y, this.z};
        return ret;
    }

    public DDDVector copy() {
        return new DDDVector(this.x, this.y, this.z);
    }
}

