/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util;

import gollorum.signpost.blocks.BigPostPost;
import gollorum.signpost.blocks.PostPost;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class TextureHelper {
    private static TextureHelper INSTANCE;

    private TextureHelper() {
    }

    public static TextureHelper instance() {
        return INSTANCE == null ? (INSTANCE = new TextureHelper()) : INSTANCE;
    }

    public ResourceLocation getHeldBlockTexture(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        try {
            ResourceLocation ret;
            ItemStack stack = player.field_71071_by.func_70448_g();
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block instanceof PostPost) {
                ret = ((PostPost)block).type.texture;
            } else if (block instanceof BigPostPost) {
                ret = ((BigPostPost)block).type.texture;
            } else {
                IBlockState blockState = this.blockStateFromPlayer(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
                IBakedModel model = FMLClientHandler.instance().getClient().func_175599_af().func_175037_a().func_178089_a(stack);
                Vec3d look = player.func_70040_Z();
                EnumFacing side = EnumFacing.func_176737_a((float)((float)(-look.field_72450_a)), (float)((float)(-look.field_72448_b)), (float)((float)(-look.field_72449_c)));
                BakedQuad quad = (BakedQuad)model.func_188616_a(blockState, side, 0L).get(0);
                String textureName = quad.func_187508_a().func_94215_i();
                String resourceName = this.textureNameToResourceName(textureName);
                ret = new ResourceLocation(resourceName);
            }
            FMLClientHandler.instance().getClient().func_110442_L().func_110536_a(ret);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private IBlockState blockStateFromPlayer(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        try {
            ItemStack itemStack = player.field_71071_by.func_70448_g();
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            return block.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, itemStack.func_77960_j(), (EntityLivingBase)player, hand);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String textureNameToResourceName(String textureName) {
        if (textureName.equals("missingno") || !textureName.contains(":")) {
            return null;
        }
        String[] split = textureName.split(":");
        if (split.length != 2) {
            return null;
        }
        if (!split[1].startsWith("textures/blocks/")) {
            if (!split[1].startsWith("blocks/")) {
                split[1] = "blocks/" + split[1];
            }
            split[1] = "textures/" + split[1];
        }
        if (!TextureHelper.endsWithIgnoreCase(split[1], ".png")) {
            split[1] = split[1] + ".png";
        }
        return split[0] + ":" + split[1];
    }

    public boolean setTexture(BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        ResourceLocation texture = this.getHeldBlockTexture((EntityPlayer)player, (World)world, pos, hand, facing, hitX, hitY, hitZ);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (texture == null || !(tileEntity instanceof SuperPostPostTile)) {
            return false;
        }
        SuperPostPostTile superTile = (SuperPostPostTile)tileEntity;
        superTile.getPaintObject().setTexture(texture);
        superTile.setPaintObject(null);
        superTile.setAwaitingPaint(false);
        ((SuperPostPost)superTile.func_145838_q()).sendPostBasesToServer(superTile);
        return true;
    }

    private static boolean endsWithIgnoreCase(String str1, String str2) {
        return str1.length() < str2.length() || str1.substring(str1.length() - str2.length()).equalsIgnoreCase(str2);
    }
}

