/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.network.messages;

import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.StonedHashSet;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InitPlayerResponseMessage
implements IMessage {
    public StonedHashSet allWaystones = new StonedHashSet();
    public static boolean deactivateTeleportation;
    public static boolean interdimensional;
    public static int maxDist;
    public static String paymentItem;
    public static int costMult;
    public static int costBase;
    public static ConfigHandler.RecipeCost signRec;
    public static ConfigHandler.RecipeCost waysRec;
    public static ConfigHandler.SecurityLevel securityLevelWaystone;
    public static ConfigHandler.SecurityLevel securityLevelSignpost;
    public boolean disableVillageGeneration;
    public int villageWaystonesWeight;
    public int villageMaxSignposts;
    public int villageSignpostsWeight;
    public boolean onlyVillageTargets;
    public String[] allowedCraftingModels;
    public String[] allowedVillageModels;

    public InitPlayerResponseMessage() {
        if (!ConfigHandler.isDeactivateTeleportation()) {
            this.allWaystones = PostHandler.getNativeWaystones();
        }
        deactivateTeleportation = ConfigHandler.isDeactivateTeleportation();
        interdimensional = ConfigHandler.isInterdimensional();
        maxDist = ConfigHandler.getMaxDist();
        paymentItem = ConfigHandler.getPaymentItem();
        costMult = ConfigHandler.getCostMult();
        costBase = ConfigHandler.getCostBase();
        signRec = ConfigHandler.getSignRec();
        waysRec = ConfigHandler.getWaysRec();
        securityLevelWaystone = ConfigHandler.getSecurityLevelWaystone();
        securityLevelSignpost = ConfigHandler.getSecurityLevelSignpost();
        this.disableVillageGeneration = ConfigHandler.isDisableVillageGeneration();
        this.villageMaxSignposts = ConfigHandler.getVillageMaxSignposts();
        this.villageSignpostsWeight = ConfigHandler.getVillageSignpostsWeight();
        this.villageWaystonesWeight = ConfigHandler.getVillageWaystonesWeight();
        this.onlyVillageTargets = ConfigHandler.isOnlyVillageTargets();
        this.allowedCraftingModels = ConfigHandler.getAllowedCraftingModels();
        this.allowedVillageModels = ConfigHandler.getAllowedVillageModels();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(deactivateTeleportation);
        if (!ConfigHandler.isDeactivateTeleportation()) {
            buf.writeInt(this.allWaystones.size());
            for (BaseInfo now : this.allWaystones) {
                now.toBytes(buf);
            }
        }
        buf.writeBoolean(interdimensional);
        buf.writeInt(maxDist);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)paymentItem);
        buf.writeInt(costMult);
        buf.writeInt(costBase);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)signRec.name());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)waysRec.name());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)securityLevelWaystone.name());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)securityLevelSignpost.name());
        buf.writeBoolean(this.disableVillageGeneration);
        buf.writeInt(this.villageMaxSignposts);
        buf.writeInt(this.villageSignpostsWeight);
        buf.writeInt(this.villageWaystonesWeight);
        buf.writeBoolean(this.onlyVillageTargets);
        buf.writeInt(this.allowedCraftingModels.length);
        for (String ws : this.allowedCraftingModels) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ws);
        }
        buf.writeInt(this.allowedVillageModels.length);
        for (String ws : this.allowedVillageModels) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ws);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        deactivateTeleportation = buf.readBoolean();
        if (!deactivateTeleportation) {
            this.allWaystones = new StonedHashSet();
            int c = buf.readInt();
            for (int i2 = 0; i2 < c; ++i2) {
                this.allWaystones.add(BaseInfo.fromBytes(buf));
            }
        }
        interdimensional = buf.readBoolean();
        maxDist = buf.readInt();
        paymentItem = ByteBufUtils.readUTF8String((ByteBuf)buf);
        costMult = buf.readInt();
        costBase = buf.readInt();
        signRec = ConfigHandler.RecipeCost.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        waysRec = ConfigHandler.RecipeCost.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        securityLevelWaystone = ConfigHandler.SecurityLevel.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        securityLevelSignpost = ConfigHandler.SecurityLevel.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.disableVillageGeneration = buf.readBoolean();
        this.villageMaxSignposts = buf.readInt();
        this.villageSignpostsWeight = buf.readInt();
        this.villageWaystonesWeight = buf.readInt();
        this.onlyVillageTargets = buf.readBoolean();
        this.allowedCraftingModels = new String[buf.readInt()];
        for (i = 0; i < this.allowedCraftingModels.length; ++i) {
            this.allowedCraftingModels[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.allowedVillageModels = new String[buf.readInt()];
        for (i = 0; i < this.allowedVillageModels.length; ++i) {
            this.allowedVillageModels[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }
}

