/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.BlockHandler;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.event.UseSignpostEvent;
import gollorum.signpost.items.CalibratedPostWrench;
import gollorum.signpost.items.PostBrush;
import gollorum.signpost.items.PostWrench;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.network.messages.RequestTextureMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Paintable;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class SuperPostPost
extends BlockContainer {
    protected SuperPostPost(Material materialIn) {
        super(materialIn);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        SuperPostPostTile superTile = SuperPostPost.getSuperTile(world, pos);
        if (world.field_72995_K || !this.canUse((EntityPlayerMP)player, superTile)) {
            return;
        }
        Object hit = this.getHitTarget(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
        if (this.isHitWaystone(hit) && player.func_70093_af()) {
            superTile.destroyWaystone();
        } else if (!PostHandler.isHandEmpty(player)) {
            Item item = player.func_184614_ca().func_77973_b();
            if (item instanceof PostWrench) {
                if (player.func_70093_af()) {
                    if (this.preShiftClick(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
                        this.shiftClickWrench(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                } else {
                    this.clickWrench(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else if (item instanceof CalibratedPostWrench) {
                if (player.func_70093_af()) {
                    if (this.preShiftClick(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
                        this.shiftClickCalibratedWrench(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                } else {
                    this.clickCalibratedWrench(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else if (item instanceof PostBrush) {
                this.clickBrush(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (player.func_70093_af()) {
                if (this.preShiftClick(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
                    this.shiftClick(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else {
                this.click(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else if (player.func_70093_af()) {
            if (this.preShiftClick(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
                this.shiftClickBare(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else {
            this.clickBare(hit, superTile, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        this.sendPostBasesToAll(superTile);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (MinecraftForge.EVENT_BUS.post((Event)new UseSignpostEvent(playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) || worldIn.field_72995_K) {
            return true;
        }
        Object hit = this.getHitTarget(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn);
        SuperPostPostTile superTile = SuperPostPost.getSuperTile(worldIn, pos);
        EntityPlayerMP player = (EntityPlayerMP)playerIn;
        if (this.isHitWaystone(hit)) {
            this.rightClickWaystone(superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (!PostHandler.isHandEmpty(playerIn)) {
            if (playerIn.func_184614_ca().func_77973_b() instanceof PostWrench) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                this.rightClickWrench(hit, superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.sendPostBasesToAll(superTile);
            } else if (playerIn.func_184614_ca().func_77973_b() instanceof CalibratedPostWrench) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                this.rightClickCalibratedWrench(hit, superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (playerIn.func_184614_ca().func_77973_b() instanceof PostBrush) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                this.rightClickBrush(hit, superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.sendPostBasesToAll(superTile);
            } else if (superTile.isAwaitingPaint()) {
                if (!this.canUse(player, superTile)) {
                    return true;
                }
                if (superTile.getPaintObject() == null) {
                    superTile.setAwaitingPaint(false);
                } else {
                    NetworkHandler.netWrap.sendTo((IMessage)new RequestTextureMessage(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), hand, facing, hitX, hitY, hitZ), (EntityPlayerMP)playerIn);
                }
            } else if (Block.func_149634_a((Item)playerIn.func_184614_ca().func_77973_b()) instanceof BasePost) {
                if (this.rightClickBase(superTile, (EntityPlayerMP)playerIn, pos)) {
                    this.preRightClick(hit, superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else {
                this.preRightClick(hit, superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else {
            this.preRightClick(hit, superTile, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    protected boolean canUse(EntityPlayerMP player, SuperPostPostTile tile) {
        return ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canUse(player, "" + tile.owner);
    }

    private void rightClickWaystone(SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BaseInfo ws = superTile.getBaseInfo();
        if (!player.func_70093_af()) {
            if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)player, ws)) {
                if (!ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)player);
                }
                PostHandler.addDiscovered(player.func_110124_au(), ws);
            }
        } else if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse((EntityPlayerMP)player, "" + ws.owner)) {
            NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, x, y, z), (EntityPlayerMP)player);
        }
    }

    private boolean rightClickBase(SuperPostPostTile superTile, EntityPlayerMP player, BlockPos pos) {
        if (superTile.isWaystone()) {
            return true;
        }
        if (!ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canUse(player, "" + superTile.owner) || !SPEventHandler.INSTANCE.checkWaystoneCount(player)) {
            return true;
        }
        MyBlockPos blockPos = superTile.toPos();
        MyBlockPos telePos = new MyBlockPos((Entity)player);
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = new BaseInfo(name, blockPos, telePos, owner);
        PostHandler.addWaystone(ws);
        PostHandler.addDiscovered(owner, ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, superTile.func_145831_w(), telePos.x, telePos.y, telePos.z, name));
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), player);
        superTile.isWaystone = true;
        if (!ConfigHandler.isCreative((EntityPlayer)player)) {
            player.field_71071_by.func_174925_a(Item.func_150898_a((Block)BlockHandler.base), -1, 1, null);
        }
        return false;
    }

    private void preRightClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        if (this.isHitWaystone(hitObj)) {
            BaseInfo ws = superTile.getBaseInfo();
            if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)player, ws)) {
                if (!ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)player);
                }
                PostHandler.addDiscovered(player.func_110124_au(), ws);
            }
        } else {
            this.rightClick(hitObj, superTile, player, x, y, z);
        }
    }

    private boolean preShiftClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        if (this.isHitWaystone(hitObj)) {
            superTile.destroyWaystone();
            return false;
        }
        return true;
    }

    protected abstract boolean isHitWaystone(Object var1);

    public abstract void clickWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClickWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClickWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void clickCalibratedWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClickCalibratedWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClickCalibratedWrench(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void clickBrush(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClickBrush(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void click(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void rightClick(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClick(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void clickBare(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void shiftClickBare(Object var1, SuperPostPostTile var2, EntityPlayer var3, int var4, int var5, int var6);

    public abstract void sendPostBasesToAll(SuperPostPostTile var1);

    public abstract void sendPostBasesToServer(SuperPostPostTile var1);

    public static SuperPostPostTile getSuperTile(World world, BlockPos pos) {
        return (SuperPostPostTile)world.func_175625_s(pos);
    }

    public static SuperPostPostTile getSuperTile(MyBlockPos pos) {
        TileEntity tile = pos.getTile();
        if (tile == null) {
            pos.getWorld().func_180495_p(pos.toBlockPos());
            tile = pos.getTile();
        }
        if (tile instanceof SuperPostPostTile) {
            return (SuperPostPostTile)tile;
        }
        return null;
    }

    public static void updateServer(MyBlockPos pos) {
        SuperPostPostTile tile = SuperPostPost.getSuperTile(pos);
        if (tile == null) {
            return;
        }
        tile.getSuperBlock().sendPostBasesToAll(tile);
    }

    public static void updateClient(MyBlockPos pos) {
        SuperPostPostTile tile = SuperPostPost.getSuperTile(pos);
        if (tile == null) {
            return;
        }
        tile.getSuperBlock().sendPostBasesToServer(tile);
    }

    public abstract Object getHitTarget(World var1, int var2, int var3, int var4, EntityPlayer var5);

    public abstract Paintable getPaintableByHit(SuperPostPostTile var1, Object var2);

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public static void placeClient(World world, MyBlockPos blockPos, EntityPlayer player) {
        SuperPostPost.getSuperTile((World)world, (BlockPos)blockPos.toBlockPos()).owner = player.func_110124_au();
    }

    public static void placeServer(World world, MyBlockPos blockPos, EntityPlayerMP player) {
        SuperPostPost.getSuperTile((World)world, (BlockPos)blockPos.toBlockPos()).owner = player.func_110124_au();
    }
}

