/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.tiles.PostPostTile;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.network.messages.SendAllWaystoneNamesMessage;
import gollorum.signpost.network.messages.SendPostBasesMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.Paintable;
import gollorum.signpost.util.Sign;
import gollorum.signpost.util.math.tracking.Cuboid;
import gollorum.signpost.util.math.tracking.DDDVector;
import gollorum.signpost.util.math.tracking.Intersect;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PostPost
extends SuperPostPost {
    public PostType type;

    @Deprecated
    public PostPost() {
        super(Material.field_151575_d);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149713_g(0);
        this.func_149663_c("SignpostPostOAK");
        this.setRegistryName("signpost:blockpostoak");
    }

    public PostPost(PostType type) {
        super(type.material);
        this.type = type;
        this.func_149647_a(CreativeTabs.field_78029_e);
        switch (type) {
            case STONE: {
                this.setHarvestLevel("pickaxe", 0);
                break;
            }
            case IRON: {
                this.setHarvestLevel("pickaxe", 1);
                break;
            }
            default: {
                this.setHarvestLevel("axe", 0);
            }
        }
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149713_g(0);
        this.func_149663_c("SignpostPost" + type.name());
        this.setRegistryName("signpost:blockpost" + type.name().toLowerCase());
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        PostPostTile tile = new PostPostTile(this.type);
        return tile;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        PostPostTile tile = new PostPostTile(this.type);
        tile.isItem = false;
        return tile;
    }

    public static PostPostTile getWaystonePostTile(World world, BlockPos pos) {
        TileEntity ret = world.func_175625_s(pos);
        if (ret instanceof PostPostTile) {
            return (PostPostTile)ret;
        }
        return null;
    }

    @Override
    public void clickWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        DoubleBaseInfo tilebases = ((PostPostTile)superTile).getBases();
        if (hit.target == HitTarget.BASE1) {
            tilebases.sign1.rot(-15, x, z);
        } else if (hit.target == HitTarget.BASE2) {
            tilebases.sign2.rot(-15, x, z);
        }
    }

    @Override
    public void rightClickWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        DoubleBaseInfo tilebases = ((PostPostTile)superTile).getBases();
        if (hit.target == HitTarget.BASE1) {
            tilebases.sign1.rot(15, x, z);
        } else if (hit.target == HitTarget.BASE2) {
            tilebases.sign2.rot(15, x, z);
        }
    }

    @Override
    public void shiftClickWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        DoubleBaseInfo tilebases = ((PostPostTile)superTile).getBases();
        if (hit.target == HitTarget.BASE1) {
            tilebases.sign1.flip = !tilebases.sign1.flip;
        } else if (hit.target == HitTarget.BASE2) {
            tilebases.sign2.flip = !tilebases.sign2.flip;
        }
    }

    @Override
    public void clickBrush(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(3, x, y, z), (EntityPlayerMP)player);
    }

    @Override
    public void rightClickBrush(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        DoubleBaseInfo tilebases = ((PostPostTile)superTile).getBases();
        if (tilebases.awaitingPaint && tilebases.paintObject != null) {
            tilebases.paintObject = null;
            tilebases.awaitingPaint = false;
        } else {
            Hit hit = (Hit)hitObj;
            tilebases.awaitingPaint = true;
            if (hit.target == HitTarget.POST) {
                tilebases.paintObject = tilebases;
            } else if (hit.target == HitTarget.BASE1) {
                tilebases.paintObject = tilebases.sign1;
            } else if (hit.target == HitTarget.BASE2) {
                tilebases.paintObject = tilebases.sign2;
            } else {
                tilebases.paintObject = null;
                tilebases.awaitingPaint = false;
            }
        }
    }

    @Override
    public void clickCalibratedWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Sign sign = this.getSignByHit((Hit)hitObj, (PostPostTile)superTile);
        if (sign != null) {
            sign.rotation = (sign.flip ? 90 : 270) - (int)player.field_70759_as;
        }
    }

    @Override
    public void rightClickCalibratedWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        if (hit.target.equals((Object)HitTarget.BASE1) || hit.target.equals((Object)HitTarget.BASE2)) {
            NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(4, x, y, z), (EntityPlayerMP)player);
        }
    }

    @Override
    public void shiftClickCalibratedWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Sign sign = this.getSignByHit((Hit)hitObj, (PostPostTile)superTile);
        if (sign != null) {
            sign.rotation = (sign.flip ? 270 : 90) - (int)player.field_70759_as;
        }
    }

    @Override
    public void click(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        PostPostTile tile = (PostPostTile)superTile;
        DoubleBaseInfo tilebases = tile.getBases();
        if (hit.target == HitTarget.BASE1) {
            if (tilebases.sign1.overlay != null) {
                player.field_71071_by.func_70441_a(new ItemStack(tilebases.sign1.overlay.item, 1));
            }
        } else if (hit.target == HitTarget.BASE2 && tilebases.sign2.overlay != null) {
            player.field_71071_by.func_70441_a(new ItemStack(tilebases.sign2.overlay.item, 1));
        }
        for (Sign.OverlayType now : Sign.OverlayType.values()) {
            if (player.func_184614_ca().func_77973_b().getClass() != now.item.getClass()) continue;
            if (hit.target == HitTarget.BASE1) {
                tilebases.sign1.overlay = now;
            } else if (hit.target == HitTarget.BASE2) {
                tilebases.sign2.overlay = now;
            }
            player.field_71071_by.func_174925_a(now.item, 0, 1, null);
            NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(tile, tilebases));
            return;
        }
        if (hit.target == HitTarget.BASE1) {
            tilebases.sign1.overlay = null;
        } else if (hit.target == HitTarget.BASE2) {
            tilebases.sign2.overlay = null;
        }
        NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(tile, tilebases));
    }

    @Override
    public void rightClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        PostPostTile tile = (PostPostTile)superTile;
        if (hit.target != HitTarget.POST) {
            BaseInfo destination;
            if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                return;
            }
            BaseInfo baseInfo = destination = hit.target == HitTarget.BASE1 ? tile.getBases().sign1.base : tile.getBases().sign2.base;
            if (destination != null) {
                if (destination.pos == null) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.noTeleport"), (EntityPlayerMP)player);
                } else {
                    int stackSize = PostHandler.getStackSize(destination.pos, tile.toPos());
                    if (PostHandler.canPay(player, destination.pos.x, destination.pos.y, destination.pos.z, x, y, z)) {
                        PostHandler.teleportMe(destination, (EntityPlayerMP)player, stackSize);
                    } else {
                        String[] keyword = new String[]{"<itemName>", "<amount>"};
                        String[] replacement = new String[]{ClientConfigStorage.INSTANCE.getCost().func_77658_a() + ".name", "" + stackSize};
                        NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.payment", keyword, replacement), (EntityPlayerMP)player);
                    }
                }
            }
        } else {
            if (!this.canUse((EntityPlayerMP)player, superTile)) {
                return;
            }
            NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(1, x, y, z), (EntityPlayerMP)player);
            NetworkHandler.netWrap.sendTo((IMessage)new SendAllWaystoneNamesMessage(PostHandler.getAllWaystones().select(b -> b.getName())), (EntityPlayerMP)player);
        }
    }

    @Override
    public void shiftClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        DoubleBaseInfo tilebases = ((PostPostTile)superTile).getBases();
        if (hit.target == HitTarget.BASE1) {
            tilebases.sign1.point = !tilebases.sign1.point;
        } else if (hit.target == HitTarget.BASE2) {
            tilebases.sign2.point = !tilebases.sign2.point;
        }
    }

    @Override
    public void clickBare(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Hit hit = (Hit)hitObj;
        PostPostTile tile = (PostPostTile)superTile;
        DoubleBaseInfo tilebases = tile.getBases();
        if (hit.target == HitTarget.BASE1) {
            tilebases.sign1.point = !tilebases.sign1.point;
            NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(tile, tilebases));
        } else if (hit.target == HitTarget.BASE2) {
            tilebases.sign2.point = !tilebases.sign2.point;
            NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(tile, tilebases));
        }
    }

    @Override
    public void shiftClickBare(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        this.shiftClick(hitObj, superTile, player, x, y, z);
    }

    @Override
    public void sendPostBasesToAll(SuperPostPostTile superTile) {
        PostPostTile tile = (PostPostTile)superTile;
        DoubleBaseInfo tilebases = tile.getBases();
        NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(tile, tilebases));
    }

    @Override
    public void sendPostBasesToServer(SuperPostPostTile superTile) {
        PostPostTile tile = (PostPostTile)superTile;
        DoubleBaseInfo tilebases = tile.getBases();
        NetworkHandler.netWrap.sendToServer((IMessage)new SendPostBasesMessage(tile, tilebases));
    }

    @Override
    public Object getHitTarget(World world, int x, int y, int z, EntityPlayer player) {
        HitTarget target;
        DDDVector pos;
        double dist;
        double waystoneDist;
        DDDVector head = new DDDVector(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        head.y += (double)player.func_70047_e();
        if (player.func_70093_af()) {
            head.y -= 0.08;
        }
        Vec3d look = player.func_70040_Z();
        PostPostTile tile = PostPost.getWaystonePostTile(world, new BlockPos(x, y, z));
        DoubleBaseInfo bases = tile.getBases();
        DDDVector rotPos = new DDDVector((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        DDDVector edges = new DDDVector(1.4375, 0.375, 0.0625);
        DDDVector signPos = bases.sign1.flip ? new DDDVector((double)x - 0.375, (double)y + 0.5625, (double)z + 0.625) : new DDDVector((double)x - 0.0625, (double)y + 0.5625, (double)z + 0.625);
        Cuboid sign1 = new Cuboid(signPos, edges, bases.sign1.calcRot(x, z), rotPos);
        signPos = bases.sign2.flip ? new DDDVector((double)x - 0.375, (double)y + 0.0625, (double)z + 0.625) : new DDDVector((double)x - 0.0625, (double)y + 0.0625, (double)z + 0.625);
        Cuboid sign2 = new Cuboid(signPos, edges, bases.sign2.calcRot(x, z), rotPos);
        Cuboid post = new Cuboid(new DDDVector((double)x + 0.375, y, (double)z + 0.375), new DDDVector(0.25, 1.0, 0.25), 0.0);
        Cuboid waystone = new Cuboid(new DDDVector((double)x + 0.25, y, (double)z + 0.25), new DDDVector(0.5, 0.5, 0.5), 0.0);
        DDDVector start = new DDDVector(head);
        DDDVector end = start.add(new DDDVector(look.field_72450_a, look.field_72448_b, look.field_72449_c));
        Intersect sign1Hit = sign1.traceLine(start, end, true);
        Intersect sign2Hit = sign2.traceLine(start, end, true);
        Intersect postHit = post.traceLine(start, end, true);
        Intersect waystoneHit = waystone.traceLine(start, end, true);
        double sign1Dist = sign1Hit.exists && bases.sign1.base != null && bases.sign1.base.hasName() ? sign1Hit.pos.distance(start) : Double.MAX_VALUE;
        double sign2Dist = sign2Hit.exists && bases.sign2.base != null && bases.sign2.base.hasName() ? sign2Hit.pos.distance(start) : Double.MAX_VALUE;
        double postDist = postHit.exists ? postHit.pos.distance(start) : Double.MAX_VALUE;
        double d = waystoneDist = waystoneHit.exists && tile.isWaystone() ? waystoneHit.pos.distance(start) : Double.MAX_VALUE;
        if (sign1Dist < sign2Dist) {
            dist = sign1Dist;
            pos = sign1Hit.pos;
            target = HitTarget.BASE1;
        } else {
            dist = sign2Dist;
            pos = sign2Hit.pos;
            target = HitTarget.BASE2;
        }
        if (waystoneDist <= dist) {
            dist = waystoneDist;
            pos = waystoneHit.pos;
            target = HitTarget.STONE;
        }
        if (postDist <= dist) {
            dist = postDist;
            pos = postHit.pos;
            target = HitTarget.POST;
        }
        return new Hit(target, pos);
    }

    public static PostPostTile getTile(World world, BlockPos pos) {
        return PostPost.getWaystonePostTile(world, pos);
    }

    public Sign getSignByHit(Hit hit, PostPostTile tile) {
        if (hit.target.equals((Object)HitTarget.BASE1)) {
            return tile.getBases().sign1;
        }
        if (hit.target.equals((Object)HitTarget.BASE2)) {
            return tile.getBases().sign2;
        }
        return null;
    }

    @Override
    public Paintable getPaintableByHit(SuperPostPostTile tile, Object hit) {
        switch ((HitTarget)((Object)hit)) {
            case BASE1: {
                return ((PostPostTile)tile).getBases().sign1;
            }
            case BASE2: {
                return ((PostPostTile)tile).getBases().sign2;
            }
            case POST: {
                return ((PostPostTile)tile).getBases();
            }
        }
        return null;
    }

    @Override
    protected boolean isHitWaystone(Object hitObj) {
        return ((Hit)hitObj).target.equals((Object)HitTarget.STONE);
    }

    public static class Hit {
        public HitTarget target;
        public DDDVector pos;

        public Hit(HitTarget target, DDDVector pos) {
            this.target = target;
            this.pos = pos;
        }
    }

    public static enum HitTarget {
        BASE1,
        BASE2,
        POST,
        STONE;

    }

    public static enum PostType {
        OAK(Material.field_151575_d, "sign_oak", "log_oak", Item.func_150898_a((Block)Blocks.field_150364_r), 0),
        SPRUCE(Material.field_151575_d, "sign_spruce", "log_spruce", Item.func_150898_a((Block)Blocks.field_150364_r), 1),
        BIRCH(Material.field_151575_d, "sign_birch", "log_birch", Item.func_150898_a((Block)Blocks.field_150364_r), 2),
        JUNGLE(Material.field_151575_d, "sign_jungle", "log_jungle", Item.func_150898_a((Block)Blocks.field_150364_r), 3),
        ACACIA(Material.field_151575_d, "sign_acacia", "log_acacia", Item.func_150898_a((Block)Blocks.field_150363_s), 0),
        BIGOAK(Material.field_151575_d, "sign_big_oak", "log_big_oak", Item.func_150898_a((Block)Blocks.field_150363_s), 1),
        IRON(Material.field_151573_f, "sign_iron", "iron_block", Items.field_151042_j, 0),
        STONE(Material.field_151576_e, "sign_stone", "stone", Item.func_150898_a((Block)Blocks.field_150348_b), 0);

        public Material material;
        public ResourceLocation texture;
        public String textureMain;
        public ResourceLocation resLocMain;
        public Item baseItem;
        public int metadata;

        private PostType(Material material, String texture, String textureMain, Item baseItem, int metadata) {
            this.material = material;
            this.texture = new ResourceLocation("signpost:textures/blocks/" + texture + ".png");
            this.textureMain = textureMain;
            this.resLocMain = new ResourceLocation("minecraft:textures/blocks/" + textureMain + ".png");
            this.baseItem = baseItem;
            this.metadata = metadata;
        }
    }
}

