/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.MyBlockPos;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BaseModelPost
extends BlockContainer {
    public static final String[] allTypeNames = new String[]{"simple0", "simple1", "simple2", "detailed0", "detailed1", "aer", "dwarf", "ygnar"};
    public static final String[] allDefaultVillageTypeNames = new String[]{"simple0", "simple1", "simple2", "detailed0", "detailed1"};
    public static final int[] allTypeIds = new int[]{5, 6, 7, 0, 1, 2, 3, 4};
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public final ModelType type;

    public BaseModelPost(int typ) {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149663_c("SignpostBase");
        this.setRegistryName("signpost:blockbasemodel" + typ);
        this.type = ModelType.values()[typ];
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState getStateForFacing(EnumFacing facing) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            BaseInfo ws = BaseModelPost.getWaystoneRootTile(worldIn, pos).getBaseInfo();
            if (ws == null) {
                ws = new BaseInfo(BasePost.generateName(), new MyBlockPos(worldIn, pos, playerIn.field_71093_bK), playerIn.func_110124_au());
                PostHandler.addWaystone(ws);
            }
            if (!playerIn.func_70093_af()) {
                if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)playerIn, ws)) {
                    if (!ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                        NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)playerIn);
                    }
                    PostHandler.addDiscovered(playerIn.func_110124_au(), ws);
                }
            } else if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse((EntityPlayerMP)playerIn, "" + ws.owner)) {
                NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (EntityPlayerMP)playerIn);
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BasePostTile().setup();
    }

    public static BasePostTile getWaystoneRootTile(World world, BlockPos pos) {
        TileEntity ret = world.func_175625_s(pos);
        if (ret instanceof BasePostTile) {
            return (BasePostTile)ret;
        }
        return null;
    }

    public static void placeServer(World world, MyBlockPos blockPos, EntityPlayerMP player) {
        MyBlockPos telePos = new MyBlockPos((Entity)player);
        BasePostTile tile = BaseModelPost.getWaystoneRootTile(world, blockPos.toBlockPos());
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = tile.getBaseInfo();
        if (ws == null) {
            ws = new BaseInfo(name, blockPos, telePos, owner);
            PostHandler.addWaystone(ws);
        } else {
            ws.setAll(new BaseInfo(name, blockPos, telePos, owner));
        }
        PostHandler.addDiscovered(player.func_110124_au(), ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, world, blockPos.x, blockPos.y, blockPos.z, name));
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, blockPos.x, blockPos.y, blockPos.z), player);
    }

    public static void placeClient(World world, MyBlockPos pos, EntityPlayer player) {
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        BasePostTile ret = new BasePostTile();
        return ret;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public static BaseModelPost[] createAll() {
        BaseModelPost[] ret = new BaseModelPost[ModelType.values().length];
        for (int i = 0; i < ModelType.values().length; ++i) {
            ret[i] = new BaseModelPost(i);
        }
        return ret;
    }

    public static enum ModelType {
        MODEL0(0),
        MODEL1(1),
        MODEL2(2),
        MODEL3(3),
        MODEL4(4),
        MODEL5(5),
        MODEL6(6),
        MODEL7(7);

        private int ID;
        public final String name;

        private ModelType(int i) {
            this(allTypeIds[i], allTypeNames[i]);
        }

        private ModelType(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public static ModelType getByID(int ID) {
            for (ModelType now : ModelType.values()) {
                if (ID != now.ID) continue;
                return now;
            }
            return MODEL1;
        }

        public static ModelType getByName(String name) {
            for (ModelType now : ModelType.values()) {
                if (!name.equals(now.name)) continue;
                return now;
            }
            return MODEL1;
        }
    }
}

