/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.blocks.BaseModelPost;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.BigPostPost;
import gollorum.signpost.blocks.PostPost;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.util.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockHandler {
    public static BasePost base = new BasePost();
    public static BaseModelPost[] basemodels = BaseModelPost.createAll();
    public static final PostPost post_oak = new PostPost(PostPost.PostType.OAK);
    public static final PostPost post_spruce = new PostPost(PostPost.PostType.SPRUCE);
    public static final PostPost post_birch = new PostPost(PostPost.PostType.BIRCH);
    public static final PostPost post_jungle = new PostPost(PostPost.PostType.JUNGLE);
    public static final PostPost post_acacia = new PostPost(PostPost.PostType.ACACIA);
    public static final PostPost post_big_oak = new PostPost(PostPost.PostType.BIGOAK);
    public static final PostPost post_iron = new PostPost(PostPost.PostType.IRON);
    public static final PostPost post_stone = new PostPost(PostPost.PostType.STONE);
    public static final PostPost[] posts = new PostPost[]{post_oak, post_spruce, post_birch, post_jungle, post_acacia, post_big_oak, post_iron, post_stone};
    public static final BigPostPost bigpost_oak = new BigPostPost(BigPostPost.BigPostType.OAK);
    public static final BigPostPost bigpost_spruce = new BigPostPost(BigPostPost.BigPostType.SPRUCE);
    public static final BigPostPost bigpost_birch = new BigPostPost(BigPostPost.BigPostType.BIRCH);
    public static final BigPostPost bigpost_jungle = new BigPostPost(BigPostPost.BigPostType.JUNGLE);
    public static final BigPostPost bigpost_acacia = new BigPostPost(BigPostPost.BigPostType.ACACIA);
    public static final BigPostPost bigpost_big_oak = new BigPostPost(BigPostPost.BigPostType.BIGOAK);
    public static final BigPostPost bigpost_iron = new BigPostPost(BigPostPost.BigPostType.IRON);
    public static final BigPostPost bigpost_stone = new BigPostPost(BigPostPost.BigPostType.STONE);
    public static final BigPostPost[] bigposts = new BigPostPost[]{bigpost_oak, bigpost_spruce, bigpost_birch, bigpost_jungle, bigpost_acacia, bigpost_big_oak, bigpost_iron, bigpost_stone};
    public static final BlockHandler INSTANCE = new BlockHandler();

    protected BlockHandler() {
    }

    public static void init() {
    }

    public List<BaseModelPost> baseModelsForCrafting() {
        List<BaseModelPost> allModels = Arrays.asList(basemodels);
        ArrayList<BaseModelPost> allowedModels = new ArrayList<BaseModelPost>();
        for (String model : ClientConfigStorage.INSTANCE.getAllowedCraftingModels()) {
            BaseModelPost block = CollectionUtils.find(allModels, m -> m.type.name.equals(model));
            if (block == null) continue;
            allowedModels.add(block);
        }
        return allowedModels;
    }

    public List<BaseModelPost> baseModelsForVillages() {
        List<BaseModelPost> allModels = Arrays.asList(basemodels);
        ArrayList<BaseModelPost> allowedModels = new ArrayList<BaseModelPost>();
        for (String model : ClientConfigStorage.INSTANCE.getAllowedVillageModels()) {
            BaseModelPost block = CollectionUtils.find(allModels, m -> m.type.name.equals(model));
            if (block == null) continue;
            allowedModels.add(block);
        }
        return allowedModels;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        this.registerBlock((Block)base, (IForgeRegistry<Block>)registry);
        for (PostPost postPost : posts) {
            this.registerBlock((Block)postPost, (IForgeRegistry<Block>)registry);
        }
        for (SuperPostPost superPostPost : bigposts) {
            this.registerBlock((Block)superPostPost, (IForgeRegistry<Block>)registry);
        }
        for (BlockContainer blockContainer : basemodels) {
            this.registerBlock((Block)blockContainer, (IForgeRegistry<Block>)registry);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        this.registerItem((Block)base, (IForgeRegistry<Item>)registry);
        for (PostPost postPost : posts) {
            this.registerItem((Block)postPost, (IForgeRegistry<Item>)registry);
        }
        for (SuperPostPost superPostPost : bigposts) {
            this.registerItem((Block)superPostPost, (IForgeRegistry<Item>)registry);
        }
        for (BlockContainer blockContainer : basemodels) {
            this.registerItem((Block)blockContainer, (IForgeRegistry<Item>)registry);
        }
        this.registerRecipes();
    }

    private void registerBlock(Block block, IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)block);
    }

    private void registerItem(Block block, IForgeRegistry<Item> registry) {
        ItemBlock item = new ItemBlock(block);
        item.setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
    }

    private void registerRecipes() {
        this.waystoneRecipe();
        for (PostPost postPost : posts) {
            this.postRecipe(postPost);
        }
        for (SuperPostPost superPostPost : bigposts) {
            this.bigPostRecipe((BigPostPost)superPostPost);
        }
    }

    private void waystoneRecipe() {
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.RECIPES;
        registry.remove(new ResourceLocation("signpost:blockbaserecipe"));
        Function<Integer, ResourceLocation> makeKey = i -> new ResourceLocation("signpost:basemodel" + i + "recipe");
        int i2 = 0;
        while (registry.containsKey(makeKey.apply(i2))) {
            registry.remove(makeKey.apply(i2));
            ++i2;
        }
        if (ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canCraft && !ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            switch (ClientConfigStorage.INSTANCE.getWaysRec()) {
                case EXPENSIVE: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockbaserecipe"), null, (ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{"SSS", "PPP", "SSS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('P'), Items.field_151079_bi});
                    break;
                }
                case VERY_EXPENSIVE: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockbaserecipe"), null, (ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{"SSS", " P ", "SSS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('P'), Items.field_151156_bN});
                    break;
                }
                case DEACTIVATED: {
                    break;
                }
                default: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockbaserecipe"), null, (ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{"SSS", " P ", "SSS", Character.valueOf('S'), Blocks.field_150347_e, Character.valueOf('P'), Items.field_151079_bi});
                }
            }
            List<BaseModelPost> allowedModels = this.baseModelsForCrafting();
            if (allowedModels.size() > 0) {
                GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("signpost:basemodel0recipe"), null, (ItemStack)new ItemStack((Block)allowedModels.get(0), 1), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)base, 1)})});
                for (int i3 = 1; i3 < allowedModels.size(); ++i3) {
                    GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("signpost:basemodel" + i3 + "recipe"), null, (ItemStack)new ItemStack((Block)allowedModels.get(i3), 1), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)allowedModels.get(i3 - 1), 1)})});
                }
                GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("signpost:basemodel" + allowedModels.size() + "recipe"), null, (ItemStack)new ItemStack((Block)base, 1), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)allowedModels.get(allowedModels.size() - 1))})});
            }
        }
    }

    private void postRecipe(PostPost post) {
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.RECIPES;
        registry.remove(new ResourceLocation("signpost:blockpostpostrecipe" + (Object)((Object)post.type)));
        if (ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canCraft) {
            switch (ClientConfigStorage.INSTANCE.getSignRec()) {
                case EXPENSIVE: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockpostpostrecipe" + (Object)((Object)post.type)), null, (ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"A", "P", "B", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151079_bi});
                    break;
                }
                case VERY_EXPENSIVE: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockpostpostrecipe" + (Object)((Object)post.type)), null, (ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"A", "P", "B", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151156_bN});
                    break;
                }
                case DEACTIVATED: {
                    break;
                }
                default: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockpostpostrecipe" + (Object)((Object)post.type)), null, (ItemStack)new ItemStack((Block)post, 4), (Object[])new Object[]{"A", "A", "B", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata)});
                }
            }
        }
    }

    private void bigPostRecipe(BigPostPost post) {
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.RECIPES;
        registry.remove(new ResourceLocation("signpost:blockbigpostrecipe" + (Object)((Object)post.type)));
        if (ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canCraft) {
            switch (ClientConfigStorage.INSTANCE.getSignRec()) {
                case EXPENSIVE: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockbigpostrecipe" + (Object)((Object)post.type)), null, (ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"AAA", "APA", " B ", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151079_bi});
                    break;
                }
                case VERY_EXPENSIVE: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockbigpostrecipe" + (Object)((Object)post.type)), null, (ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"AAA", "APA", " B ", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151156_bN});
                    break;
                }
                case DEACTIVATED: {
                    break;
                }
                default: {
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("signpost:blockbigpostrecipe" + (Object)((Object)post.type)), null, (ItemStack)new ItemStack((Block)post, 4), (Object[])new Object[]{"AAA", "AAA", " B ", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata)});
                }
            }
        }
    }

    public void register() {
    }
}

