/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.zlib.gui.controls;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTextArea
extends Gui {
    private static final int maxStringLength = 128;
    private static final int maxGuiLength = 39;
    private final int lineCount;
    private int cursorCounter;
    private int cursorPosition;
    private int cursorLine;
    private int lineScrollOffset;
    private int selectionEnd;
    private boolean isFocused;
    private String[] text;
    private final FontRenderer fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;

    public GuiTextArea(FontRenderer fontRenderer, int xPos, int yPos, int width, int height, int lineCount) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
        this.fontRenderer = fontRenderer;
        this.lineCount = lineCount;
        this.text = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            this.text[i] = "";
        }
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public String[] getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text[this.cursorLine].substring(i, j);
    }

    public void writeText(String textToWrite) {
        int l;
        String newLine = "";
        String filteredText = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int freeCharCount = 128 - this.text[this.cursorLine].length() - (i - j);
        if (this.text[this.cursorLine].length() > 0) {
            newLine = newLine + this.text[this.cursorLine].substring(0, i);
        }
        if (freeCharCount < filteredText.length()) {
            newLine = newLine + filteredText.substring(0, freeCharCount);
            l = freeCharCount;
        } else {
            newLine = newLine + filteredText;
            l = filteredText.length();
        }
        if (this.text[this.cursorLine].length() > 0 && j < this.text[this.cursorLine].length()) {
            newLine = newLine + this.text[this.cursorLine].substring(j);
        }
        this.text[this.cursorLine] = newLine;
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteWords(int num) {
        if (this.text[this.cursorLine].isEmpty()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
        }
    }

    public void deleteFromCursor(int count) {
        if (this.text[this.cursorLine].isEmpty()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
            return;
        }
        boolean back = count < 0;
        int left = back ? this.cursorPosition + count : this.cursorPosition;
        int right = back ? this.cursorPosition : this.cursorPosition + count;
        String newLine = "";
        if (left >= 0) {
            newLine = this.text[this.cursorLine].substring(0, left);
        }
        if (right < this.text[this.cursorLine].length()) {
            newLine = newLine + this.text[this.cursorLine].substring(right);
        }
        this.text[this.cursorLine] = newLine;
        if (back) {
            this.moveCursorBy(count);
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text[this.cursorLine].length();
                if ((i = this.text[this.cursorLine].indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text[this.cursorLine].charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text[this.cursorLine].charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text[this.cursorLine].charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    private void setCursorLine(int delta) {
        int newCursorLine = this.cursorLine + delta;
        if (newCursorLine < 0) {
            newCursorLine = 0;
        }
        if (newCursorLine >= this.lineCount) {
            newCursorLine = this.lineCount - 1;
        }
        this.cursorPosition = Math.min(this.selectionEnd, this.text[newCursorLine].length());
        this.setSelectionPos(this.cursorPosition);
        this.cursorLine = newCursorLine;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num, this.cursorLine);
    }

    public void setCursorPosition(int x, int y) {
        if (y >= this.text.length) {
            y = this.text.length - 1;
        }
        this.cursorPosition = x;
        this.cursorLine = y;
        int lineLength = this.text[y].length();
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)lineLength);
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0, this.cursorLine);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text[this.cursorLine].length(), this.cursorLine);
    }

    public boolean textAreaKeyTyped(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            this.writeText(GuiScreen.func_146277_j());
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (typedChar) {
            case '\u0001': {
                this.setCursorPosition(this.text[this.cursorLine].length(), this.cursorLine);
                return true;
            }
            case '\r': {
                this.setCursorLine(1);
                return true;
            }
        }
        switch (keyCode) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    this.deleteWords(-1);
                } else {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1), this.cursorLine);
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1), this.cursorLine);
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 200: {
                this.setCursorLine(-1);
                return true;
            }
            case 208: {
                this.setCursorLine(1);
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text[this.cursorLine].length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    this.deleteWords(1);
                } else {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            this.writeText(Character.toString(typedChar));
            return true;
        }
        return false;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean bl = this.isFocused = mouseX >= this.xPos && mouseX < this.xPos + this.width && mouseY >= this.yPos && mouseY < this.yPos + this.height;
        if (this.isFocused && mouseButton == 0) {
            int xi = MathHelper.func_76141_d((float)mouseX) - this.xPos;
            int yi = MathHelper.func_76141_d((float)mouseY) - this.yPos;
            this.setCursorPosition(xi / 6, (yi - 4) / 10);
        }
    }

    public void drawTextBox() {
        boolean drawCursor;
        GuiTextArea.func_73734_a((int)(this.xPos - 1), (int)(this.yPos - 1), (int)(this.xPos + this.width + 1), (int)(this.yPos + this.height + 1), (int)-6250336);
        GuiTextArea.func_73734_a((int)this.xPos, (int)this.yPos, (int)(this.xPos + this.width), (int)(this.yPos + this.height), (int)-16777216);
        int textColor = 0xE0E0E0;
        int textLeft = this.xPos + 4;
        int textTop = this.yPos + (this.height - this.lineCount * (this.fontRenderer.field_78288_b + 1)) / 2;
        for (int i = 0; i < this.lineCount; ++i) {
            if (this.text[i].length() <= this.lineScrollOffset) continue;
            for (int j = 0; j < Math.min(this.text[i].length() - this.lineScrollOffset, 39); ++j) {
                String line = this.text[i].substring(j + this.lineScrollOffset, j + this.lineScrollOffset + 1);
                this.fontRenderer.func_175063_a(line, (float)(textLeft + j * 6 + (6 - this.fontRenderer.func_78256_a(line)) / 2), (float)(textTop + (this.fontRenderer.field_78288_b + 1) * i), textColor);
            }
        }
        textTop += (this.fontRenderer.field_78288_b + 1) * this.cursorLine;
        int cursorPositionX = textLeft + this.selectionEnd * 6 - 1 - this.lineScrollOffset * 6;
        boolean bl = drawCursor = this.isFocused && this.cursorCounter / 6 % 2 == 0;
        if (drawCursor) {
            this.drawCursorVertical(cursorPositionX, textTop - 1, cursorPositionX + 1, textTop + 1 + this.fontRenderer.field_78288_b);
        }
        int selectionPositionX = textLeft + this.cursorPosition * 6 - 1 - this.lineScrollOffset * 6;
        this.drawSelectionBox(cursorPositionX, textTop - 1, Math.max(selectionPositionX, this.xPos), textTop + 1 + this.fontRenderer.field_78288_b);
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.xPos + this.width) {
            endX = this.xPos + this.width;
        }
        if (startX > this.xPos + this.width) {
            startX = this.xPos + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    private void drawCursorVertical(int left, int top, int right, int bottom) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public void setFocused(boolean focused) {
        this.isFocused = focused;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setSelectionPos(int position) {
        int i = this.text[this.cursorLine].length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (position - this.lineScrollOffset > 39) {
            this.lineScrollOffset += position - this.lineScrollOffset - 39;
        }
        if (position - this.lineScrollOffset < 0 && this.lineScrollOffset > 0) {
            this.lineScrollOffset += position - this.lineScrollOffset;
        }
    }
}

