/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.hooklib.asm;

import com.zuxelus.hooklib.asm.AsmHook;
import com.zuxelus.hooklib.asm.HookInjectorClassVisitor;
import com.zuxelus.hooklib.asm.InjectionPoint;
import com.zuxelus.hooklib.minecraft.HookLibPlugin;
import com.zuxelus.hooklib.minecraft.MinecraftClassTransformer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public abstract class HookInjectorMethodVisitor
extends AdviceAdapter {
    protected final AsmHook hook;
    protected final HookInjectorClassVisitor cv;
    public final String methodName;
    public final Type methodType;
    public final boolean isStatic;

    protected HookInjectorMethodVisitor(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
        super(327680, mv, access, name, desc);
        this.hook = hook;
        this.cv = cv;
        this.isStatic = (access & 8) != 0;
        this.methodName = name;
        this.methodType = Type.getMethodType((String)desc);
    }

    protected final void visitHook() {
        if (!this.cv.visitingHook) {
            this.cv.visitingHook = true;
            this.hook.inject(this);
            this.cv.visitingHook = false;
        }
    }

    MethodVisitor getBasicVisitor() {
        return this.mv;
    }

    public static class LineNumber
    extends HookInjectorMethodVisitor {
        private int lineNumber;

        public LineNumber(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv, int lineNumber) {
            super(mv, access, name, desc, hook, cv);
            this.lineNumber = lineNumber;
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            if (this.lineNumber == line) {
                this.visitHook();
            }
        }
    }

    public static class MethodExit
    extends HookInjectorMethodVisitor {
        public MethodExit(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
            super(mv, access, name, desc, hook, cv);
        }

        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.visitHook();
            }
        }
    }

    public static class MethodEnter
    extends HookInjectorMethodVisitor {
        public MethodEnter(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
            super(mv, access, name, desc, hook, cv);
        }

        protected void onMethodEnter() {
            this.visitHook();
        }
    }

    public static class ByAnchor
    extends HookInjectorMethodVisitor {
        private Integer ordinal;

        public ByAnchor(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
            super(mv, access, name, desc, hook, cv);
            this.ordinal = hook.getAnchorOrdinal();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            String targetName;
            String string = targetName = HookLibPlugin.getObfuscated() ? MinecraftClassTransformer.instance.getMethodNames().getOrDefault(MinecraftClassTransformer.getMethodId(name), name) : name;
            if (this.hook.getAnchorPoint() == InjectionPoint.METHOD_CALL && this.hook.getAnchorTarget().equals(targetName)) {
                switch (this.hook.getShift()) {
                    case BEFORE: {
                        this.visitOrderedHook();
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        return;
                    }
                    case AFTER: {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        this.visitOrderedHook();
                        return;
                    }
                    case INSTEAD: {
                        if (this.visitOrderedHook()) {
                            for (int i = 0; i < Type.getArgumentTypes((String)desc).length + 1; ++i) {
                                this.visitInsn(87);
                            }
                            return;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                }
                return;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        protected void onMethodEnter() {
            if (this.hook.getAnchorPoint() == InjectionPoint.HEAD) {
                this.visitHook();
            }
        }

        protected void onMethodExit(int opcode) {
            if (this.hook.getAnchorPoint() == InjectionPoint.RETURN && opcode != 191) {
                this.visitOrderedHook();
            }
        }

        private boolean visitOrderedHook() {
            if (this.ordinal == 0) {
                this.visitHook();
                this.ordinal = -2;
                return true;
            }
            if (this.ordinal == -1) {
                this.visitHook();
                return true;
            }
            if (this.ordinal > 0) {
                this.ordinal = this.ordinal - 1;
            }
            return false;
        }
    }
}

