/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.utils;

import com.zuxelus.energycontrol.api.ICardReader;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class FluidInfo {
    String name;
    String texture;
    long amount;
    long capacity;
    int color;

    public FluidInfo(String name, String texture, long amount, long capacity) {
        this.name = name;
        this.texture = texture;
        this.amount = amount;
        this.capacity = capacity;
    }

    public FluidInfo(IFluidTank tank) {
        if (tank.getFluid() != null) {
            this.amount = tank.getFluidAmount();
            if (this.amount > 0L) {
                this.name = tank.getFluid().getLocalizedName();
                this.texture = tank.getFluid().getFluid().getStill().toString();
                this.color = tank.getFluid().getFluid().getColor();
            }
        }
        this.capacity = tank.getCapacity();
    }

    public FluidInfo(FluidStack stack, long capacity) {
        if (stack != null) {
            this.amount = stack.amount;
            if (this.amount > 0L) {
                this.name = stack.getLocalizedName();
                this.texture = stack.getFluid().getStill().toString();
                this.color = stack.getFluid().getColor();
            }
        }
        this.capacity = capacity;
    }

    public FluidInfo(Fluid fluid, String name, long amount, long capacity) {
        if (fluid != null) {
            this.name = name;
            this.texture = fluid.getStill().toString();
            this.color = fluid.getColor();
        }
        this.amount = amount;
        this.capacity = capacity;
    }

    public void write(ICardReader reader) {
        if (this.name != null) {
            reader.setString("name", this.name);
        } else {
            reader.setString("name", "");
        }
        if (this.texture != null) {
            reader.setString("texture", this.texture);
        } else {
            reader.setString("texture", "");
        }
        reader.setLong("amount", this.amount);
        reader.setLong("capacity", this.capacity);
        reader.setInt("color", this.color);
    }

    public void write(ICardReader reader, int i) {
        if (this.name != null) {
            reader.setString(String.format("_%dname", i), this.name);
        } else {
            reader.setString(String.format("_%dname", i), "");
        }
        reader.setLong(String.format("_%damount", i), this.amount);
        reader.setLong(String.format("_%dcapacity", i), this.capacity);
    }

    public static void addTank(String name, NBTTagCompound tag, FluidTank tank) {
        FluidStack stack = tank.getFluid();
        if (stack == null) {
            tag.func_74778_a(name, "N/A");
        } else {
            tag.func_74778_a(name, String.format("%s: %s mB", stack.getLocalizedName(), tank.getFluidAmount()));
        }
    }

    public static void addTank(String name, NBTTagCompound tag, FluidStack stack) {
        if (stack == null) {
            tag.func_74778_a(name, "N/A");
        } else {
            tag.func_74778_a(name, String.format("%s: %s mB", stack.getLocalizedName(), stack.amount));
        }
    }
}

