/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.blocks.HoloPanelExtender;
import com.zuxelus.energycontrol.blocks.InfoPanelExtender;
import com.zuxelus.energycontrol.tileentities.IScreenPart;
import com.zuxelus.energycontrol.tileentities.Screen;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanel;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanelExtender;
import com.zuxelus.energycontrol.tileentities.TileEntityHoloPanel;
import com.zuxelus.energycontrol.tileentities.TileEntityHoloPanelExtender;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanelExtender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ScreenManager {
    private final Map<Integer, List<Screen>> screens = new HashMap<Integer, List<Screen>>();
    private final Map<Integer, List<TileEntityInfoPanel>> unusedPanels = new HashMap<Integer, List<TileEntityInfoPanel>>();

    private int getWorldKey(World world) {
        if (world == null) {
            return -10;
        }
        if (world.field_73011_w == null) {
            return -10;
        }
        return world.field_73011_w.getDimension();
    }

    private void checkWorldLists(Integer key) {
        if (!this.screens.containsKey(key)) {
            this.screens.put(key, new ArrayList());
        }
        if (!this.unusedPanels.containsKey(key)) {
            this.unusedPanels.put(key, new ArrayList());
        }
    }

    public void clearWorld(World world) {
        Integer key = this.getWorldKey(world);
        if (this.screens.containsKey(key)) {
            this.screens.get(key).clear();
        }
        if (this.unusedPanels.containsKey(key)) {
            this.unusedPanels.get(key).clear();
        }
    }

    public void registerInfoPanel(TileEntityInfoPanel panel) {
        World world = panel.func_145831_w();
        if (world.field_72995_K) {
            return;
        }
        this.checkWorldLists(this.getWorldKey(world));
        for (Screen screen : this.screens.get(this.getWorldKey(world))) {
            if (!screen.isBlockPartOf(panel)) continue;
            this.destroyScreen(screen, world);
            break;
        }
        Screen screen = this.buildFromPanel(panel);
        this.screens.get(this.getWorldKey(world)).add(screen);
    }

    private void destroyScreen(Screen screen, World world) {
        this.screens.get(this.getWorldKey(world)).remove(screen);
        screen.destroy(true, world);
    }

    private Screen buildFromPanel(TileEntityInfoPanel panel) {
        Screen screen = new Screen(panel);
        EnumFacing facing = panel.getFacing();
        int dx = facing == EnumFacing.WEST || facing == EnumFacing.EAST ? 0 : -1;
        int dy = facing == EnumFacing.DOWN || facing == EnumFacing.UP ? 0 : -1;
        int dz = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? 0 : -1;
        boolean advanced = panel instanceof TileEntityAdvancedInfoPanel;
        boolean holo = panel instanceof TileEntityHoloPanel;
        this.updateScreenBound(screen, dx, 0, 0, panel.func_145831_w(), advanced, holo);
        this.updateScreenBound(screen, -dx, 0, 0, panel.func_145831_w(), advanced, holo);
        this.updateScreenBound(screen, 0, dy, 0, panel.func_145831_w(), advanced, holo);
        this.updateScreenBound(screen, 0, -dy, 0, panel.func_145831_w(), advanced, holo);
        this.updateScreenBound(screen, 0, 0, dz, panel.func_145831_w(), advanced, holo);
        this.updateScreenBound(screen, 0, 0, -dz, panel.func_145831_w(), advanced, holo);
        screen.init(false, panel.func_145831_w());
        panel.updateData();
        return screen;
    }

    private void updateScreenBound(Screen screen, int dx, int dy, int dz, World world, boolean advanced, boolean holo) {
        if (dx == 0 && dy == 0 && dz == 0) {
            return;
        }
        boolean isMin = dx + dy + dz < 0;
        int dir = isMin ? 1 : -1;
        for (int steps = 0; steps < 20; ++steps) {
            int z;
            int y;
            int x;
            if (isMin) {
                x = screen.minX + dx;
                y = screen.minY + dy;
                z = screen.minZ + dz;
            } else {
                x = screen.maxX + dx;
                y = screen.maxY + dy;
                z = screen.maxZ + dz;
            }
            int rx = dx != 0 ? 0 : screen.maxX - screen.minX;
            int ry = dy != 0 ? 0 : screen.maxY - screen.minY;
            int rz = dz != 0 ? 0 : screen.maxZ - screen.minZ;
            boolean allOk = true;
            for (int interX = 0; interX <= rx && allOk; ++interX) {
                for (int interY = 0; interY <= ry && allOk; ++interY) {
                    for (int interZ = 0; interZ <= rz && allOk; ++interZ) {
                        TileEntityInfoPanel core = screen.getCore((IBlockAccess)world);
                        allOk = core != null && this.isValidExtender(world, new BlockPos(x + dir * interX, y + dir * interY, z + dir * interZ), core.getFacing(), advanced, holo);
                    }
                }
            }
            if (!allOk) break;
            if (isMin) {
                screen.minX += dx;
                screen.minY += dy;
                screen.minZ += dz;
                continue;
            }
            screen.maxX += dx;
            screen.maxY += dy;
            screen.maxZ += dz;
        }
    }

    private boolean isValidExtender(World world, BlockPos pos, EnumFacing facing, boolean advanced, boolean holo) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof InfoPanelExtender) && !(block instanceof HoloPanelExtender)) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te.func_145837_r()) {
            return false;
        }
        if (!(te instanceof TileEntityInfoPanelExtender)) {
            return false;
        }
        if (advanced ^ te instanceof TileEntityAdvancedInfoPanelExtender) {
            return false;
        }
        if (holo ^ te instanceof TileEntityHoloPanelExtender) {
            return false;
        }
        if (((TileEntityInfoPanelExtender)te).getFacing() != facing) {
            return false;
        }
        return ((IScreenPart)te).getScreen() == null;
    }

    public Screen loadScreen(TileEntityInfoPanel panel) {
        if (panel.screenData == null) {
            return null;
        }
        Screen screen = new Screen(panel, panel.screenData);
        if (!panel.func_145831_w().field_72995_K) {
            Integer key = this.getWorldKey(panel.func_145831_w());
            this.checkWorldLists(key);
            if (!this.screens.get(key).contains(screen)) {
                this.screens.get(key).add(screen);
            }
        }
        return screen;
    }

    public void registerInfoPanelExtender(TileEntityInfoPanelExtender extender) {
        if (extender.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.screens.containsKey(this.getWorldKey(extender.func_145831_w()))) {
            this.screens.put(this.getWorldKey(extender.func_145831_w()), new ArrayList());
        }
        if (!this.unusedPanels.containsKey(this.getWorldKey(extender.func_145831_w()))) {
            this.unusedPanels.put(this.getWorldKey(extender.func_145831_w()), new ArrayList());
        }
        ArrayList<TileEntityInfoPanel> rebuildPanels = new ArrayList<TileEntityInfoPanel>();
        ArrayList<Screen> screensToDestroy = new ArrayList<Screen>();
        for (Screen screen : this.screens.get(this.getWorldKey(extender.func_145831_w()))) {
            TileEntityInfoPanel core = screen.getCore((IBlockAccess)extender.func_145831_w());
            if (screen.isBlockNearby(extender) && core != null && extender.getFacing() == core.getFacing()) {
                rebuildPanels.add(core);
                screensToDestroy.add(screen);
                continue;
            }
            if (!screen.isBlockPartOf(extender)) continue;
            return;
        }
        for (Screen screen : screensToDestroy) {
            this.destroyScreen(screen, extender.func_145831_w());
        }
        BlockPos pos = extender.func_174877_v();
        for (TileEntityInfoPanel panel : this.unusedPanels.get(this.getWorldKey(extender.func_145831_w()))) {
            BlockPos posPanel = panel.func_174877_v();
            if ((posPanel.func_177958_n() != pos.func_177958_n() || posPanel.func_177956_o() != pos.func_177956_o() || posPanel.func_177952_p() != pos.func_177952_p() + 1 && posPanel.func_177952_p() != pos.func_177952_p() - 1) && (posPanel.func_177958_n() != pos.func_177958_n() || posPanel.func_177956_o() != pos.func_177956_o() + 1 && posPanel.func_177956_o() != pos.func_177956_o() - 1 || posPanel.func_177952_p() != pos.func_177952_p()) && (posPanel.func_177958_n() != pos.func_177958_n() + 1 && posPanel.func_177958_n() != pos.func_177958_n() - 1 || posPanel.func_177956_o() != pos.func_177956_o() || posPanel.func_177952_p() != pos.func_177952_p()) || extender.getFacing() != panel.getFacing()) continue;
            rebuildPanels.add(panel);
        }
        for (TileEntityInfoPanel panel : rebuildPanels) {
            Screen screen = this.buildFromPanel(panel);
            this.screens.get(this.getWorldKey(extender.func_145831_w())).add(screen);
            this.unusedPanels.get(this.getWorldKey(extender.func_145831_w())).remove(panel);
        }
    }

    public void unregisterScreenPart(TileEntity part) {
        if (part.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.screens.containsKey(this.getWorldKey(part.func_145831_w()))) {
            return;
        }
        if (!this.unusedPanels.containsKey(this.getWorldKey(part.func_145831_w()))) {
            return;
        }
        if (!(part instanceof IScreenPart)) {
            return;
        }
        IScreenPart screenPart = (IScreenPart)part;
        Screen screen = screenPart.getScreen();
        if (screen == null) {
            if (part instanceof TileEntityInfoPanel) {
                this.unusedPanels.get(this.getWorldKey(part.func_145831_w())).remove(part);
            }
            return;
        }
        TileEntityInfoPanel core = screen.getCore((IBlockAccess)part.func_145831_w());
        this.destroyScreen(screen, part.func_145831_w());
        boolean isCoreDestroyed = part instanceof TileEntityInfoPanel;
        if (!isCoreDestroyed && core != null && !core.func_145837_r()) {
            Screen newScreen = this.buildFromPanel(core);
            this.screens.get(this.getWorldKey(core.func_145831_w())).add(newScreen);
        }
    }
}

