/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CubeSmallRenderer {
    public static final CubeSmallRenderer MODEL = new CubeSmallRenderer(2.0f, 0.0f, 2.0f, 28, 14, 28, 128.0f, 128.0f);
    public static final CubeSmallRenderer DESTROY = new CubeSmallRenderer(2.0f, 0.0f, 2.0f, 28, 14, 28, 32.0f, 32.0f);
    private boolean compiled;
    private int displayList;
    private CubeSmallBox cube;

    public CubeSmallRenderer(float x, float y, float z, int dx, int dy, int dz, float textureWidth, float textureHeight) {
        this.cube = new CubeSmallBox(x, y, z, dx, dy, dz, textureWidth, textureHeight);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale) {
        if (!this.compiled) {
            this.compileDisplayList(scale);
        }
        GlStateManager.func_179148_o((int)this.displayList);
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        this.cube.render(bufferbuilder, scale);
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    public static void rotateBlock(EnumFacing facing, EnumFacing rotation) {
        if (rotation == null) {
            rotation = EnumFacing.NORTH;
        }
        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        switch (facing) {
            case UP: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                switch (rotation) {
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                }
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                switch (rotation) {
                    case NORTH: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)-1.0f);
                    }
                }
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
            }
        }
    }

    private static class CubeSmallBox {
        private final TexturedQuad[] quadList = new TexturedQuad[6];

        public CubeSmallBox(float x, float y, float z, int dx, int dy, int dz, float textureWidth, float textureHeight) {
            float f = x + (float)dx;
            float f1 = y + (float)dy;
            float f2 = z + (float)dz;
            PositionTextureVertex v7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex v = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
            PositionTextureVertex v1 = new PositionTextureVertex(f, f1, z, 8.0f, 8.0f);
            PositionTextureVertex v2 = new PositionTextureVertex(x, f1, z, 8.0f, 0.0f);
            PositionTextureVertex v3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex v4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex v5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
            PositionTextureVertex v6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
            this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{v5, v4, v, v1}, 0, dy, dy, dy + dx, textureWidth, textureHeight);
            this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{v3, v6, v2, v7}, dy + dx, dy, dy + dx + dy, dy + dx, textureWidth, textureHeight);
            this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{v4, v3, v7, v}, dy + dx + dy, dy, dy + dx + dy + dx, dy + dz, textureWidth, textureHeight);
            this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{v1, v2, v6, v5}, dy, dy, dy + dx, dy + dz, textureWidth, textureHeight);
            this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{v2, v1, v, v7}, dy, dy + dx, dy + dx, dy + dx + dy, textureWidth, textureHeight);
            this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{v3, v4, v5, v6}, dy, 0, dy + dx, dy, textureWidth, textureHeight);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(BufferBuilder renderer, float scale) {
            for (TexturedQuad quad : this.quadList) {
                quad.func_178765_a(renderer, scale);
            }
        }
    }
}

