/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.network;

import com.zuxelus.zlib.network.PacketTileEntity;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHelper {
    public static SimpleNetworkWrapper network;

    public static void createChannel(String name) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(name);
    }

    public static <REQ extends IMessage, REPLY extends IMessage> void registerClientToServer(Class<? extends IMessageHandler<REQ, REPLY>> handler, Class<REQ> request, int id) {
        network.registerMessage(handler, request, id, Side.SERVER);
    }

    public static <REQ extends IMessage, REPLY extends IMessage> void registerServerToClient(Class<? extends IMessageHandler<REQ, REPLY>> handler, Class<REQ> request, int id) {
        network.registerMessage(handler, request, id, Side.CLIENT);
    }

    public static void sendPacketToAllAround(World world, BlockPos pos, int dist, IMessage packet) {
        List players = world.field_73010_i;
        for (EntityPlayer player : players) {
            double dz;
            double dy;
            double dx;
            if (!(player instanceof EntityPlayerMP) || !((dx = (double)pos.func_177958_n() - player.field_70165_t) * dx + (dy = (double)pos.func_177956_o() - player.field_70163_u) * dy + (dz = (double)pos.func_177952_p() - player.field_70161_v) * dz < (double)(dist * dist))) continue;
            network.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    public static void updateClientTileEntity(IContainerListener crafter, BlockPos pos, int type, int value) {
        if (!(crafter instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74768_a("value", value);
        network.sendTo((IMessage)new PacketTileEntity(pos, tag), (EntityPlayerMP)crafter);
    }

    public static void updateClientTileEntity(IContainerListener crafter, BlockPos pos, int type, double value) {
        if (!(crafter instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74780_a("value", value);
        network.sendTo((IMessage)new PacketTileEntity(pos, tag), (EntityPlayerMP)crafter);
    }

    public static void updateClientTileEntity(IContainerListener crafter, BlockPos pos, NBTTagCompound tag) {
        if (!(crafter instanceof EntityPlayerMP)) {
            return;
        }
        network.sendTo((IMessage)new PacketTileEntity(pos, tag), (EntityPlayerMP)crafter);
    }

    public static void updateClientTileEntity(World world, BlockPos pos, NBTTagCompound tag) {
        NetworkHelper.sendPacketToAllAround(world, pos, 64, new PacketTileEntity(pos, tag));
    }

    public static void updateSeverTileEntity(BlockPos pos, int type, String string) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74778_a("string", string);
        network.sendToServer((IMessage)new PacketTileEntity(pos, tag));
    }

    public static void updateSeverTileEntity(BlockPos pos, int type, int value) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74768_a("value", value);
        network.sendToServer((IMessage)new PacketTileEntity(pos, tag));
    }

    public static void updateSeverTileEntity(BlockPos pos, NBTTagCompound tag) {
        network.sendToServer((IMessage)new PacketTileEntity(pos, tag));
    }
}

