/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardInventory
extends ItemCardBase {
    public ItemCardInventory() {
        super(15, "card_inventory");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.getInventoryData(te);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (isServer) {
            if ((settings & 2) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
            }
            if ((settings & 4) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelSlotsUsed", String.format("%s/%s", reader.getInt("used"), reader.getInt("size")), showLabels));
            }
        } else {
            if ((settings & 1) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelName", I18n.func_135052_a((String)reader.getString("name"), (Object[])new Object[0]), showLabels));
            }
            if ((settings & 2) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
            }
            if ((settings & 4) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelSlotsUsed", String.format("%s/%s", reader.getInt("used"), reader.getInt("size")), showLabels));
            }
            if ((settings & 8) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelSidedInventory", reader.getBoolean("sided").toString(), showLabels));
            }
            if ((settings & 0x10) > 0) {
                for (int i = 0; i < 6; ++i) {
                    if (!reader.hasField("slot" + Integer.toString(i))) continue;
                    ItemStack stack = new ItemStack(reader.getTag("slot" + Integer.toString(i)));
                    result.add(new PanelString(String.format("msg.ec.InfoPanelSlot%d", i + 1), StringUtils.getItemName(stack) + " x" + Integer.toString(stack.func_190916_E()), showLabels));
                }
            }
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(2);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelName", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTotalItems", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelSlotsUsed", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOther", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelItems", (Object[])new Object[0]), 16));
        return result;
    }
}

