/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardGregTech
extends ItemCardBase {
    private static DecimalFormat df = new DecimalFormat("0.0");

    public ItemCardGregTech() {
        super(25, "card_gregtech");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("gregtech").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (reader.hasField("stored")) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getLong("stored").longValue(), "HE", showLabels));
        }
        if (reader.hasField("capacity")) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getLong("capacity").longValue(), "HE", showLabels));
        }
        if (reader.hasField("consumption")) {
            result.add(new PanelString("msg.ec.InfoPanelConsumption", reader.getDouble("consumption"), "mB/s", showLabels));
        }
        if (reader.hasField("output")) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "HE/t", showLabels));
        }
        if (reader.hasField("outputmb")) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("outputmb"), "mB/s", showLabels));
        }
        if (reader.hasField("heat")) {
            result.add(new PanelString("msg.ec.InfoPanelHeat", reader.getLong("heat").longValue(), "\u00c2\u00b0C", showLabels));
        }
        if (reader.hasField("burnTime")) {
            result.add(new PanelString("msg.ec.InfoPanelBurnTime", reader.getDouble("burnTime"), "s", showLabels));
        }
        if (reader.hasField("tank")) {
            result.add(new PanelString("msg.ec.InfoPanelTank", reader.getString("tank"), showLabels));
        }
        if (reader.hasField("tank2")) {
            result.add(new PanelString("msg.ec.InfoPanelTank", reader.getString("tank2"), showLabels));
        }
        if (reader.hasField("tank3")) {
            result.add(new PanelString("msg.ec.InfoPanelTank", reader.getString("tank3"), showLabels));
        }
        if (reader.hasField("tank4")) {
            result.add(new PanelString("msg.ec.InfoPanelTank", reader.getString("tank4"), showLabels));
        }
        if (reader.hasField("active")) {
            this.addOnOff(result, isServer, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(2);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStatus", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        return result;
    }
}

