/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardEnergy
extends ItemCardBase {
    public ItemCardEnergy() {
        super(0, "card_energy");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.getEnergyData(te);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        double energy = reader.getDouble("energy");
        double storage = reader.getDouble("capacity");
        String euType = reader.getString("euType");
        if ((settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", energy, euType, showLabels));
        }
        if ((settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", storage, euType, showLabels));
        }
        if ((settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFree", storage - energy, euType, showLabels));
        }
        if ((settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", storage == 0.0 ? 100.0 : energy / storage * 100.0, showLabels));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(4);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelFree", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelPercentage", (Object[])new Object[0]), 8));
        return result;
    }
}

