/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.gui.GuiCardText;
import com.zuxelus.energycontrol.gui.GuiHorizontalSlider;
import com.zuxelus.energycontrol.gui.GuiScreenColor;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.zlib.containers.ContainerBase;
import com.zuxelus.zlib.gui.GuiContainerBase;
import com.zuxelus.zlib.gui.controls.GuiButtonGeneral;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiPanelBase
extends GuiContainerBase
implements IContainerListener {
    protected static final int ID_LABELS = 1;
    protected static final int ID_SLOPE = 2;
    protected static final int ID_COLORS = 3;
    protected static final int ID_POWER = 4;
    protected static final int ID_TEXT = 5;
    protected static final int ID_TICKRATE = 6;
    protected String name;
    protected TileEntityInfoPanel panel;
    protected GuiTextField textboxTitle;
    protected byte activeTab = 0;
    protected boolean modified = false;
    protected ItemStack oldStack = ItemStack.field_190927_a;

    public GuiPanelBase(ContainerBase<?> container, String name, ResourceLocation texture) {
        super(container, name, texture);
    }

    protected abstract void initButtons();

    protected abstract void initControls();

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
        this.initControls();
        this.field_147002_h.func_82847_b((IContainerListener)this);
        this.field_147002_h.func_75132_a((IContainerListener)this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText(this.name, this.field_146999_f, 6);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.textboxTitle != null) {
            boolean focused = this.textboxTitle.func_146206_l();
            this.textboxTitle.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            if (this.textboxTitle.func_146206_l() != focused) {
                this.updateTitle();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146178_a();
        }
    }

    protected void updateTitle() {
        if (this.textboxTitle == null) {
            return;
        }
        if (this.panel.func_145831_w().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 4);
            tag.func_74768_a("slot", (int)this.activeTab);
            tag.func_74778_a("title", this.textboxTitle.func_146179_b());
            NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), tag);
            ItemStack card = this.panel.func_70301_a(this.activeTab);
            if (ItemCardMain.isCard(card)) {
                new ItemCardReader(card).setTitle(this.textboxTitle.func_146179_b());
            }
        }
    }

    public void func_146281_b() {
        this.updateTitle();
        super.func_146281_b();
        this.field_147002_h.func_82847_b((IContainerListener)this);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                boolean checked = !this.panel.getShowLabels();
                ((GuiButtonGeneral)button).setTextureTop(checked ? 15 : 31);
                NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 3, checked ? 1 : 0);
                this.panel.setShowLabels(checked);
                break;
            }
            case 3: {
                GuiScreenColor colorGui = new GuiScreenColor(this, this.panel);
                this.field_146297_k.func_147108_a((GuiScreen)colorGui);
                break;
            }
            case 5: {
                this.oldStack = ItemStack.field_190927_a;
                this.openTextGui();
                break;
            }
            case 6: {
                GuiHorizontalSlider slider = new GuiHorizontalSlider(this, this.panel);
                this.field_146297_k.func_147108_a((GuiScreen)slider);
            }
        }
    }

    protected void openTextGui() {
        ItemStack card = (ItemStack)this.panel.getCards().get((int)this.activeTab);
        if (ItemCardMain.isCard(card) && card.func_77952_i() == 18) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCardText(card, this.panel, this, this.activeTab));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textboxTitle != null && this.textboxTitle.func_146206_l()) {
            if (keyCode == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (typedChar == '\r') {
                this.updateTitle();
            } else {
                this.modified = true;
                this.textboxTitle.func_146201_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> itemsList) {
        this.func_71111_a(container, 0, container.func_75139_a(0).func_75211_c());
    }

    public void func_71111_a(Container container, int slotInd, ItemStack stack) {
        this.initControls();
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }
}

