/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.Loader;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import techreborn.api.TechRebornAPI;
import techreborn.tiles.generator.fluid.TileFluidGenerator;

public class CrossTechReborn
extends CrossModBase {
    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "glassfiber": {
                return new ItemStack(TechRebornAPI.getBlock((String)"CABLE"), 1, 4);
            }
            case "carbon_plate": {
                return new ItemStack(TechRebornAPI.getItem((String)"PLATES"), 1, 2);
            }
            case "energy_crystal": {
                return new ItemStack(TechRebornAPI.getItem((String)"ENERGY_CRYSTAL"));
            }
            case "circuit": {
                return new ItemStack(TechRebornAPI.getItem((String)"PARTS"), 1, 29);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        return stack;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack) {
        if (Loader.isModLoaded((String)"ic2")) {
            return null;
        }
        return new PoweredItemContainerProvider(stack);
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IEnergyInterfaceTile) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyInterfaceTile storage = (IEnergyInterfaceTile)te;
            tag.func_74768_a("type", 12);
            tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
            if (PowerSystem.getDisplayPower() == PowerSystem.EnergySystem.EU) {
                tag.func_74780_a("storage", storage.getEnergy());
                tag.func_74780_a("maxStorage", storage.getMaxPower());
            } else {
                tag.func_74780_a("storage", storage.getEnergy() * (double)RebornCoreConfig.euPerFU);
                tag.func_74780_a("maxStorage", storage.getMaxPower() * (double)RebornCoreConfig.euPerFU);
            }
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof TileFluidGenerator) {
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            result.add(new FluidInfo((IFluidTank)((TileFluidGenerator)te).tank));
            return result;
        }
        return null;
    }
}

