/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardNuclearCraft;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.items.kits.ItemKitNuclearCraft;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.tile.energy.battery.TileBattery;
import nc.tile.energyFluid.TileEnergyFluid;
import nc.tile.generator.TileDecayGenerator;
import nc.tile.generator.TileFissionController;
import nc.tile.generator.TileSolarPanel;
import nc.tile.internal.fluid.Tank;
import nc.tile.processor.TileFluidProcessor;
import nc.tile.processor.TileItemProcessor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.IFluidTank;

public class CrossNuclearCraft
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TileBattery) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "RF");
            tag.func_74780_a("energy", (double)((TileBattery)te).getEnergyStored());
            tag.func_74780_a("capacity", (double)((TileBattery)te).getMaxEnergyStored());
            return tag;
        }
        return null;
    }

    @Override
    public int getHeat(World world, BlockPos pos) {
        for (int xoffset = -1; xoffset < 2; ++xoffset) {
            for (int yoffset = -1; yoffset < 2; ++yoffset) {
                for (int zoffset = -1; zoffset < 2; ++zoffset) {
                    TileEntity te = world.func_175625_s(pos.func_177965_g(xoffset).func_177981_b(yoffset).func_177970_e(zoffset));
                    if (!(te instanceof TileFissionController)) continue;
                    return (int)Math.round(((TileFissionController)te).heat);
                }
            }
        }
        return -1;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof TileEnergyFluid) {
            List tanks = ((TileEnergyFluid)te).getTanks();
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            for (Tank tank : tanks) {
                result.add(new FluidInfo((IFluidTank)tank));
            }
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileDecayGenerator) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 1);
            tag.func_74768_a("energy", ((TileDecayGenerator)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileDecayGenerator)te).getMaxEnergyStored());
            tag.func_74768_a("output", ((TileDecayGenerator)te).getGenerated());
            tag.func_74780_a("radiation", ((TileDecayGenerator)te).getRadiation());
            return tag;
        }
        if (te instanceof TileItemProcessor) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 2);
            tag.func_74768_a("energy", ((TileItemProcessor)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileItemProcessor)te).getMaxEnergyStored());
            tag.func_74768_a("power", ((TileItemProcessor)te).getProcessPower());
            tag.func_74780_a("speedM", ((TileItemProcessor)te).getSpeedMultiplier());
            tag.func_74780_a("powerM", ((TileItemProcessor)te).getPowerMultiplier());
            tag.func_74768_a("time", ((TileItemProcessor)te).getProcessTime());
            return tag;
        }
        if (te instanceof TileFluidProcessor) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 2);
            tag.func_74768_a("energy", ((TileFluidProcessor)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileFluidProcessor)te).getMaxEnergyStored());
            tag.func_74768_a("power", ((TileFluidProcessor)te).getProcessPower());
            tag.func_74780_a("speedM", ((TileFluidProcessor)te).getSpeedMultiplier());
            tag.func_74780_a("powerM", ((TileFluidProcessor)te).getPowerMultiplier());
            tag.func_74768_a("time", ((TileFluidProcessor)te).getProcessTime());
            return tag;
        }
        if (te instanceof TileSolarPanel) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 4);
            tag.func_74768_a("energy", ((TileSolarPanel)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileSolarPanel)te).getMaxEnergyStored());
            tag.func_74768_a("output", ((TileSolarPanel)te).getGenerated());
            return tag;
        }
        if (te instanceof TileFissionController) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 6);
            TileFissionController reactor = (TileFissionController)te;
            tag.func_74757_a("active", reactor.isProcessing);
            tag.func_74778_a("size", reactor.getLengthX() + "*" + reactor.getLengthY() + "*" + reactor.getLengthZ());
            tag.func_74778_a("fuel", reactor.getFuelName());
            tag.func_74768_a("energy", reactor.getEnergyStored());
            tag.func_74768_a("capacity", reactor.getMaxEnergyStored());
            tag.func_74780_a("efficiency", reactor.efficiency);
            tag.func_74780_a("heat", reactor.heat);
            tag.func_74768_a("maxHeat", reactor.getMaxHeat());
            tag.func_74780_a("heatChange", reactor.heatChange);
            tag.func_74780_a("cooling", reactor.cooling);
            tag.func_74780_a("heatMult", reactor.heatMult);
            tag.func_74780_a("power", reactor.processPower);
            tag.func_74768_a("cells", reactor.cells);
            return tag;
        }
        return null;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitNuclearCraft::new);
        ItemCardMain.register(ItemCardNuclearCraft::new);
    }

    @Override
    public void loadOreInfo() {
        for (int i = 0; i < 8; ++i) {
            if (!NCConfig.ore_gen[i]) continue;
            EnergyControl.oreHelper.put(OreHelper.getId(NCBlocks.ore, i), new OreHelper(NCConfig.ore_min_height[i], NCConfig.ore_max_height[i], NCConfig.ore_size[i] + 2, NCConfig.ore_rate[i]));
        }
    }
}

