/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IItemFluidHandler;
import com.hbm.inventory.FusionRecipes;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemBattery;
import com.hbm.items.machine.ItemCatalyst;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.items.special.ItemAMSCore;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityAMSBase;
import com.hbm.tileentity.machine.TileEntityAMSEmitter;
import com.hbm.tileentity.machine.TileEntityAMSLimiter;
import com.hbm.tileentity.machine.TileEntityBarrel;
import com.hbm.tileentity.machine.TileEntityChungus;
import com.hbm.tileentity.machine.TileEntityCoreTitanium;
import com.hbm.tileentity.machine.TileEntityDummy;
import com.hbm.tileentity.machine.TileEntityGeiger;
import com.hbm.tileentity.machine.TileEntityITER;
import com.hbm.tileentity.machine.TileEntityMachineAmgen;
import com.hbm.tileentity.machine.TileEntityMachineArcFurnace;
import com.hbm.tileentity.machine.TileEntityMachineAssembler;
import com.hbm.tileentity.machine.TileEntityMachineBattery;
import com.hbm.tileentity.machine.TileEntityMachineBoiler;
import com.hbm.tileentity.machine.TileEntityMachineBoilerElectric;
import com.hbm.tileentity.machine.TileEntityMachineCentrifuge;
import com.hbm.tileentity.machine.TileEntityMachineChemplant;
import com.hbm.tileentity.machine.TileEntityMachineCoal;
import com.hbm.tileentity.machine.TileEntityMachineCrystallizer;
import com.hbm.tileentity.machine.TileEntityMachineDiesel;
import com.hbm.tileentity.machine.TileEntityMachineFluidTank;
import com.hbm.tileentity.machine.TileEntityMachineGasCent;
import com.hbm.tileentity.machine.TileEntityMachineIGenerator;
import com.hbm.tileentity.machine.TileEntityMachineLargeTurbine;
import com.hbm.tileentity.machine.TileEntityMachineMiniRTG;
import com.hbm.tileentity.machine.TileEntityMachineOrbus;
import com.hbm.tileentity.machine.TileEntityMachinePlasmaHeater;
import com.hbm.tileentity.machine.TileEntityMachineRTG;
import com.hbm.tileentity.machine.TileEntityMachineRadGen;
import com.hbm.tileentity.machine.TileEntityMachineReactorLarge;
import com.hbm.tileentity.machine.TileEntityMachineReactorSmall;
import com.hbm.tileentity.machine.TileEntityMachineSPP;
import com.hbm.tileentity.machine.TileEntityMachineSeleniumEngine;
import com.hbm.tileentity.machine.TileEntityMachineShredder;
import com.hbm.tileentity.machine.TileEntityMachineTurbine;
import com.hbm.tileentity.machine.TileEntityMachineTurbofan;
import com.hbm.tileentity.machine.TileEntityReactorHatch;
import com.hbm.tileentity.machine.TileEntitySolarBoiler;
import com.hbm.tileentity.machine.TileEntityTowerLarge;
import com.hbm.tileentity.machine.TileEntityTowerSmall;
import com.hbm.tileentity.machine.TileEntityWatzCore;
import com.hbm.tileentity.machine.TileEntityWatzHatch;
import com.hbm.tileentity.machine.oil.TileEntityMachineFractionTower;
import com.hbm.tileentity.machine.oil.TileEntityMachineGasFlare;
import com.hbm.tileentity.machine.oil.TileEntityMachineOilWell;
import com.hbm.tileentity.machine.oil.TileEntityMachinePumpjack;
import com.hbm.tileentity.machine.oil.TileEntityMachineRefinery;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBoiler;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.ContaminationUtil;
import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.hooks.HBMHooks;
import com.zuxelus.energycontrol.items.cards.ItemCardHBM;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.kits.ItemKitHBM;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CrossHBM
extends CrossModBase {
    @Override
    public boolean isElectricItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBattery;
    }

    @Override
    public double dischargeItem(ItemStack stack, double needed, int tier) {
        ItemBattery item = (ItemBattery)stack.func_77973_b();
        long amount = Math.min(Math.min((long)needed, item.getDischargeRate()), item.getCharge(stack));
        item.dischargeBattery(stack, amount);
        return amount;
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        TileEntity base;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", "HE");
        if (te instanceof TileEntityMachineBattery) {
            tag.func_74780_a("energy", (double)((TileEntityMachineBattery)te).getPower());
            tag.func_74780_a("capacity", (double)((TileEntityMachineBattery)te).getMaxPower());
            return tag;
        }
        if (te instanceof TileEntityMachineCoal) {
            tag.func_74780_a("energy", (double)((TileEntityMachineCoal)te).getPower());
            TileEntityMachineCoal cfr_ignored_0 = (TileEntityMachineCoal)te;
            tag.func_74780_a("capacity", 100000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineDiesel) {
            tag.func_74780_a("energy", (double)((TileEntityMachineDiesel)te).getPower());
            TileEntityMachineDiesel cfr_ignored_1 = (TileEntityMachineDiesel)te;
            tag.func_74780_a("capacity", 50000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineSeleniumEngine) {
            tag.func_74780_a("energy", (double)((TileEntityMachineSeleniumEngine)te).getPower());
            TileEntityMachineSeleniumEngine cfr_ignored_2 = (TileEntityMachineSeleniumEngine)te;
            tag.func_74780_a("capacity", 250000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineRTG) {
            tag.func_74780_a("energy", (double)((TileEntityMachineRTG)te).getPower());
            ((TileEntityMachineRTG)te).getClass();
            tag.func_74780_a("capacity", 1000000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineMiniRTG) {
            tag.func_74780_a("energy", (double)((TileEntityMachineMiniRTG)te).getPower());
            tag.func_74780_a("capacity", ((TileEntityMachineMiniRTG)te).func_145838_q() == ModBlocks.machine_powerrtg ? 50000.0 : 1400.0);
            return tag;
        }
        if (te instanceof TileEntityMachineAmgen) {
            tag.func_74780_a("energy", (double)((TileEntityMachineAmgen)te).getPower());
            tag.func_74780_a("capacity", (double)((TileEntityMachineAmgen)te).maxPower);
            return tag;
        }
        if (te instanceof TileEntityMachineSPP) {
            tag.func_74780_a("energy", (double)((TileEntityMachineSPP)te).getPower());
            TileEntityMachineSPP cfr_ignored_3 = (TileEntityMachineSPP)te;
            tag.func_74780_a("capacity", 100000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineTurbine) {
            tag.func_74780_a("energy", (double)((TileEntityMachineTurbine)te).getPower());
            TileEntityMachineTurbine cfr_ignored_4 = (TileEntityMachineTurbine)te;
            tag.func_74780_a("capacity", 1000000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineShredder) {
            tag.func_74780_a("energy", (double)((TileEntityMachineShredder)te).getPower());
            TileEntityMachineShredder cfr_ignored_5 = (TileEntityMachineShredder)te;
            tag.func_74780_a("capacity", 10000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineBoilerElectric) {
            tag.func_74780_a("energy", (double)((TileEntityMachineBoilerElectric)te).getPower());
            TileEntityMachineBoilerElectric cfr_ignored_6 = (TileEntityMachineBoilerElectric)te;
            tag.func_74780_a("capacity", 10000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineArcFurnace) {
            tag.func_74780_a("energy", (double)((TileEntityMachineArcFurnace)te).getPower());
            TileEntityMachineArcFurnace cfr_ignored_7 = (TileEntityMachineArcFurnace)te;
            tag.func_74780_a("capacity", 50000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineCentrifuge) {
            tag.func_74780_a("energy", (double)((TileEntityMachineCentrifuge)te).getPower());
            TileEntityMachineCentrifuge cfr_ignored_8 = (TileEntityMachineCentrifuge)te;
            tag.func_74780_a("capacity", 1000000.0);
            return tag;
        }
        if (te instanceof TileEntityMachineGasCent) {
            tag.func_74780_a("energy", (double)((TileEntityMachineGasCent)te).getPower());
            TileEntityMachineGasCent cfr_ignored_9 = (TileEntityMachineGasCent)te;
            tag.func_74780_a("capacity", 100000.0);
            return tag;
        }
        if (te instanceof TileEntityProxyCombo) {
            base = ((TileEntityProxyCombo)te).getTile();
            if (base instanceof TileEntityMachineLargeTurbine) {
                tag.func_74780_a("energy", (double)((TileEntityMachineLargeTurbine)base).getPower());
                TileEntityMachineLargeTurbine cfr_ignored_10 = (TileEntityMachineLargeTurbine)base;
                tag.func_74780_a("capacity", 1.0E8);
                return tag;
            }
            if (base instanceof TileEntityMachineIGenerator) {
                tag.func_74780_a("energy", (double)((TileEntityMachineIGenerator)base).getPower());
                TileEntityMachineIGenerator cfr_ignored_11 = (TileEntityMachineIGenerator)base;
                tag.func_74780_a("capacity", 1000000.0);
                return tag;
            }
            if (base instanceof TileEntityITER) {
                tag.func_74780_a("energy", (double)((TileEntityITER)base).getPower());
                TileEntityITER cfr_ignored_12 = (TileEntityITER)base;
                tag.func_74780_a("capacity", 1.0E9);
                return tag;
            }
            if (base instanceof TileEntityMachinePlasmaHeater) {
                tag.func_74780_a("energy", (double)((TileEntityMachinePlasmaHeater)base).getPower());
                TileEntityMachinePlasmaHeater cfr_ignored_13 = (TileEntityMachinePlasmaHeater)base;
                tag.func_74780_a("capacity", 1.0E10);
                return tag;
            }
            if (base instanceof TileEntityMachineCrystallizer) {
                tag.func_74780_a("energy", (double)((TileEntityMachineCrystallizer)base).getPower());
                TileEntityMachineCrystallizer cfr_ignored_14 = (TileEntityMachineCrystallizer)base;
                tag.func_74780_a("capacity", 1000000.0);
                return tag;
            }
            if (base instanceof TileEntityChungus) {
                tag.func_74780_a("energy", (double)((TileEntityChungus)base).getPower());
                TileEntityChungus cfr_ignored_15 = (TileEntityChungus)base;
                tag.func_74780_a("capacity", 1.0E11);
                return tag;
            }
        }
        if (te instanceof TileEntityDummy) {
            base = te.func_145831_w().func_175625_s(((TileEntityDummy)te).target);
            if (base instanceof TileEntityMachineChemplant) {
                tag.func_74772_a("energy", ((TileEntityMachineChemplant)base).getPower());
                TileEntityMachineChemplant cfr_ignored_16 = (TileEntityMachineChemplant)base;
                tag.func_74772_a("capacity", 2000000L);
                return tag;
            }
            if (base instanceof TileEntityMachineTurbofan) {
                tag.func_74780_a("energy", (double)((TileEntityMachineTurbofan)base).getPower());
                TileEntityMachineTurbofan cfr_ignored_17 = (TileEntityMachineTurbofan)base;
                tag.func_74780_a("capacity", 1000000.0);
                return tag;
            }
            if (base instanceof TileEntityMachineRadGen) {
                tag.func_74780_a("energy", (double)((TileEntityMachineRadGen)base).getPower());
                TileEntityMachineRadGen cfr_ignored_18 = (TileEntityMachineRadGen)base;
                tag.func_74780_a("capacity", 1000000.0);
                return tag;
            }
            if (base instanceof TileEntityMachineOilWell) {
                tag.func_74780_a("energy", (double)((TileEntityMachineOilWell)base).getPower());
                tag.func_74780_a("capacity", (double)((TileEntityMachineOilWell)base).getMaxPower());
                return tag;
            }
            if (base instanceof TileEntityMachineAssembler) {
                tag.func_74780_a("energy", (double)((TileEntityMachineAssembler)base).getPower());
                TileEntityMachineAssembler cfr_ignored_19 = (TileEntityMachineAssembler)base;
                tag.func_74780_a("capacity", 2000000.0);
                return tag;
            }
            if (base instanceof TileEntityMachinePumpjack) {
                tag.func_74780_a("energy", (double)((TileEntityMachinePumpjack)base).getPower());
                tag.func_74780_a("capacity", (double)((TileEntityMachinePumpjack)base).getMaxPower());
                return tag;
            }
            if (base instanceof TileEntityMachineRefinery) {
                tag.func_74780_a("energy", (double)((TileEntityMachineRefinery)base).getPower());
                TileEntityMachineRefinery cfr_ignored_20 = (TileEntityMachineRefinery)base;
                tag.func_74780_a("capacity", 1000.0);
                return tag;
            }
        }
        if (te instanceof TileEntityWatzHatch) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                TileEntity core = te.func_145831_w().func_175625_s(te.func_174877_v().func_177967_a(side, 3));
                if (!(core instanceof TileEntityWatzCore)) continue;
                tag.func_74780_a("energy", (double)((TileEntityWatzCore)core).getPower());
                TileEntityWatzCore cfr_ignored_21 = (TileEntityWatzCore)core;
                tag.func_74780_a("capacity", 1.0E9);
                return tag;
            }
        }
        return null;
    }

    @Override
    public int getHeat(World world, BlockPos pos) {
        if (world == null) {
            return -1;
        }
        int t = -1;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            t = this.getHeat(te);
            if (t <= 0) continue;
            return t;
        }
        for (int xoffset = -3; xoffset < 4; ++xoffset) {
            for (int yoffset = -1; yoffset < 2; ++yoffset) {
                for (int zoffset = -3; zoffset < 4; ++zoffset) {
                    TileEntity te = world.func_175625_s(pos.func_177965_g(xoffset).func_177981_b(yoffset).func_177970_e(zoffset));
                    t = this.getHeat(te);
                    if (t <= 0) continue;
                    return t;
                }
            }
        }
        return t;
    }

    private int getHeat(TileEntity te) {
        if (te instanceof TileEntityRBMKBase) {
            return (int)((TileEntityRBMKBase)te).heat;
        }
        if (te instanceof TileEntityMachineReactorSmall) {
            return (int)Math.round((double)((TileEntityMachineReactorSmall)te).hullHeat * 1.0E-5 * 980.0 + 20.0);
        }
        if (te instanceof TileEntityMachineReactorLarge) {
            return (int)Math.round((double)((TileEntityMachineReactorLarge)te).hullHeat * 1.0E-5 * 980.0 + 20.0);
        }
        return -1;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        TileEntity core;
        TileEntity base;
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileEntityMachineCoal) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineCoal)te).tank));
            return result;
        }
        if (te instanceof TileEntityMachineDiesel) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineDiesel)te).tank));
            return result;
        }
        if (te instanceof TileEntityMachineSeleniumEngine) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineSeleniumEngine)te).tank));
            return result;
        }
        if (te instanceof TileEntityMachineTurbine) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineTurbine)te).tanks[0]));
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineTurbine)te).tanks[1]));
            return result;
        }
        if (te instanceof TileEntityMachineBoiler) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineBoiler)te).tanks[0]));
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineBoiler)te).tanks[1]));
            return result;
        }
        if (te instanceof TileEntityMachineBoilerElectric) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineBoilerElectric)te).tanks[0]));
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineBoilerElectric)te).tanks[1]));
            return result;
        }
        if (te instanceof TileEntityMachineGasCent) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineGasCent)te).tank));
            return result;
        }
        if (te instanceof TileEntityBarrel) {
            result.add(new FluidInfo((IFluidTank)((TileEntityBarrel)te).tank));
            return result;
        }
        if (te instanceof TileEntityProxyCombo) {
            base = ((TileEntityProxyCombo)te).getTile();
            if (base instanceof TileEntityMachineLargeTurbine) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineLargeTurbine)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineLargeTurbine)base).tanks[1]));
                return result;
            }
            if (base instanceof TileEntitySolarBoiler) {
                IFluidTankProperties[] tanks = ((TileEntitySolarBoiler)base).getTankProperties();
                result.add(new FluidInfo(tanks[0].getContents(), tanks[0].getCapacity()));
                result.add(new FluidInfo(tanks[1].getContents(), tanks[1].getCapacity()));
                return result;
            }
            if (base instanceof TileEntityMachineIGenerator) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineIGenerator)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineIGenerator)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineIGenerator)base).tanks[2]));
                return result;
            }
            if (base instanceof TileEntityITER) {
                result.add(new FluidInfo((IFluidTank)((TileEntityITER)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityITER)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityITER)base).plasma));
                return result;
            }
            if (base instanceof TileEntityMachinePlasmaHeater) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachinePlasmaHeater)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachinePlasmaHeater)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachinePlasmaHeater)base).plasma));
                return result;
            }
            if (base instanceof TileEntityMachineOrbus) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineOrbus)base).tank));
                return result;
            }
            if (base instanceof TileEntityMachineFractionTower) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineFractionTower)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineFractionTower)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineFractionTower)base).tanks[2]));
                return result;
            }
            if (base instanceof TileEntityMachineCrystallizer) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineCrystallizer)base).tank));
                return result;
            }
        }
        if (te instanceof TileEntityDummy) {
            base = te.func_145831_w().func_175625_s(((TileEntityDummy)te).target);
            if (base instanceof TileEntityMachineChemplant) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineChemplant)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineChemplant)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineChemplant)base).tanks[2]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineChemplant)base).tanks[3]));
                return result;
            }
            if (base instanceof TileEntityMachineFluidTank) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineFluidTank)base).tank));
                return result;
            }
            if (base instanceof TileEntityMachineGasFlare) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineGasFlare)base).tank));
                return result;
            }
            if (base instanceof TileEntityMachineTurbofan) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineTurbofan)base).tank));
                return result;
            }
            if (base instanceof TileEntityAMSLimiter) {
                result.add(new FluidInfo((IFluidTank)((TileEntityAMSLimiter)base).tank));
                return result;
            }
            if (base instanceof TileEntityAMSBase) {
                result.add(new FluidInfo((IFluidTank)((TileEntityAMSBase)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityAMSBase)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityAMSBase)base).tanks[2]));
                result.add(new FluidInfo((IFluidTank)((TileEntityAMSBase)base).tanks[3]));
                return result;
            }
            if (base instanceof TileEntityAMSEmitter) {
                result.add(new FluidInfo((IFluidTank)((TileEntityAMSEmitter)base).tank));
                return result;
            }
            if (base instanceof TileEntityMachineOilWell) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineOilWell)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineOilWell)base).tanks[1]));
                return result;
            }
            if (base instanceof TileEntityMachinePumpjack) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachinePumpjack)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachinePumpjack)base).tanks[1]));
                return result;
            }
            if (base instanceof TileEntityMachineRefinery) {
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineRefinery)base).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineRefinery)base).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineRefinery)base).tanks[2]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineRefinery)base).tanks[3]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineRefinery)base).tanks[4]));
                return result;
            }
        }
        if (te instanceof TileEntityMachineReactorSmall) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineReactorSmall)te).tanks[0]));
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineReactorSmall)te).tanks[1]));
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineReactorSmall)te).tanks[2]));
            return result;
        }
        if (te instanceof TileEntityReactorHatch) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                core = te.func_145831_w().func_175625_s(te.func_174877_v().func_177967_a(side, 2));
                if (!(core instanceof TileEntityMachineReactorLarge)) continue;
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineReactorLarge)core).tanks[0]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineReactorLarge)core).tanks[1]));
                result.add(new FluidInfo((IFluidTank)((TileEntityMachineReactorLarge)core).tanks[2]));
                return result;
            }
        }
        if (te instanceof TileEntityWatzHatch) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                core = te.func_145831_w().func_175625_s(te.func_174877_v().func_177967_a(side, 3));
                if (!(core instanceof TileEntityWatzCore)) continue;
                result.add(new FluidInfo((IFluidTank)((TileEntityWatzCore)core).tank));
                return result;
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity core;
        NBTTagCompound tag;
        TileEntityMachineDiesel diesel;
        ArrayList values;
        NBTTagCompound tag2;
        IBlockState state;
        TileEntity te = world.func_175625_s(pos);
        if (te == null && (state = world.func_180495_p(pos)).func_177230_c() != null && state.func_177230_c().getClass().getName().equals("com.hbm.blocks.machine.FactoryHatch")) {
            EnumFacing dir;
            EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
            int n = enumFacingArray.length;
            for (int i = 0; i < n && (te = world.func_175625_s(pos.func_177972_a(dir = enumFacingArray[i]))) == null; ++i) {
            }
        }
        if (te instanceof TileEntityMachineBattery) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityMachineBattery)te).getPower());
            tag2.func_74772_a("capacity", ((TileEntityMachineBattery)te).getMaxPower());
            values = this.getHookValues(te);
            if (values != null) {
                tag2.func_74772_a("diff", ((Long)values.get(0) - (Long)values.get(20)) / 20L);
            }
            return tag2;
        }
        if (te instanceof TileEntityMachineCoal) {
            tag2 = new NBTTagCompound();
            tag2.func_74757_a("active", ((TileEntityMachineCoal)te).burnTime > 0);
            tag2.func_74772_a("energy", ((TileEntityMachineCoal)te).getPower());
            TileEntityMachineCoal cfr_ignored_0 = (TileEntityMachineCoal)te;
            tag2.func_74772_a("capacity", 100000L);
            if (((TileEntityMachineCoal)te).burnTime > 0) {
                tag2.func_74780_a("output", 25.0);
            } else {
                tag2.func_74780_a("output", 0.0);
            }
            FluidInfo.addTank("tank", tag2, ((TileEntityMachineCoal)te).tank);
            return tag2;
        }
        if (te instanceof TileEntityMachineDiesel) {
            tag2 = new NBTTagCompound();
            diesel = (TileEntityMachineDiesel)te;
            if (diesel.hasAcceptableFuel() && diesel.tank.getFluidAmount() > 0) {
                tag2.func_74757_a("active", true);
                tag2.func_74780_a("output", (double)diesel.getHEFromFuel());
            } else {
                tag2.func_74757_a("active", false);
                tag2.func_74780_a("output", 0.0);
            }
            tag2.func_74772_a("energy", ((TileEntityMachineDiesel)te).getPower());
            TileEntityMachineDiesel cfr_ignored_1 = (TileEntityMachineDiesel)te;
            tag2.func_74772_a("capacity", 50000L);
            FluidInfo.addTank("tank", tag2, ((TileEntityMachineDiesel)te).tank);
            return tag2;
        }
        if (te instanceof TileEntityMachineSeleniumEngine) {
            tag2 = new NBTTagCompound();
            diesel = (TileEntityMachineSeleniumEngine)te;
            if (diesel.hasAcceptableFuel() && diesel.tank.getFluidAmount() > 0 && diesel.pistonCount > 2) {
                tag2.func_74757_a("active", true);
                tag2.func_74780_a("output", (double)diesel.getHEFromFuel() * Math.pow(diesel.pistonCount, 1.15));
            } else {
                tag2.func_74757_a("active", false);
                tag2.func_74780_a("output", 0.0);
            }
            tag2.func_74772_a("energy", ((TileEntityMachineSeleniumEngine)te).getPower());
            TileEntityMachineSeleniumEngine cfr_ignored_2 = (TileEntityMachineSeleniumEngine)te;
            tag2.func_74772_a("capacity", 250000L);
            FluidInfo.addTank("tank", tag2, ((TileEntityMachineSeleniumEngine)te).tank);
            return tag2;
        }
        if (te instanceof TileEntityMachineRTG) {
            tag2 = new NBTTagCompound();
            if (((TileEntityMachineRTG)te).heat > 0) {
                tag2.func_74757_a("active", true);
                tag2.func_74780_a("output", (double)((TileEntityMachineRTG)te).heat);
            } else {
                tag2.func_74757_a("active", false);
                tag2.func_74780_a("output", 0.0);
            }
            tag2.func_74772_a("energy", ((TileEntityMachineRTG)te).getPower());
            tag2.func_74772_a("capacity", ((TileEntityMachineRTG)te).getMaxPower());
            return tag2;
        }
        if (te instanceof TileEntityMachineMiniRTG) {
            tag2 = new NBTTagCompound();
            tag2.func_74757_a("active", true);
            tag2.func_74780_a("output", ((TileEntityMachineMiniRTG)te).func_145838_q() == ModBlocks.machine_powerrtg ? 2500.0 : 70.0);
            tag2.func_74772_a("energy", ((TileEntityMachineMiniRTG)te).getPower());
            tag2.func_74772_a("capacity", ((TileEntityMachineMiniRTG)te).func_145838_q() == ModBlocks.machine_powerrtg ? 50000L : 1400L);
            return tag2;
        }
        if (te instanceof TileEntityMachineAmgen) {
            tag2 = new NBTTagCompound();
            double output = this.calcAmgenOutput(te.func_145831_w(), te.func_145838_q(), te.func_174877_v());
            tag2.func_74757_a("active", output > 0.0);
            tag2.func_74780_a("output", output);
            tag2.func_74772_a("energy", ((TileEntityMachineAmgen)te).getPower());
            tag2.func_74772_a("capacity", ((TileEntityMachineAmgen)te).maxPower);
            return tag2;
        }
        if (te instanceof TileEntityMachineSPP) {
            tag2 = new NBTTagCompound();
            double output = Math.max(((TileEntityMachineSPP)te).checkStructure() * 15, 0);
            tag2.func_74757_a("active", output > 0.0);
            tag2.func_74780_a("output", output);
            tag2.func_74772_a("energy", ((TileEntityMachineSPP)te).getPower());
            TileEntityMachineSPP cfr_ignored_3 = (TileEntityMachineSPP)te;
            tag2.func_74772_a("capacity", 100000L);
            return tag2;
        }
        if (te instanceof TileEntityMachineTurbine) {
            TileEntityMachineTurbine turbine = (TileEntityMachineTurbine)te;
            tag = new NBTTagCompound();
            ArrayList values2 = this.getHookValues((TileEntity)turbine);
            if (values2 != null) {
                Object[] outs = MachineRecipes.getTurbineOutput(turbine.tanks[0].getFluid() == null ? null : turbine.tanks[0].getFluid().getFluid());
                if (outs != null) {
                    double cycles = 0.0;
                    for (int i = 0; i < 20; ++i) {
                        cycles += (double)((Integer)values2.get(i)).intValue();
                    }
                    tag.func_74757_a("active", (cycles /= 20.0) > 0.0);
                    tag.func_74780_a("consumption", (double)((Integer)outs[2]).intValue() * cycles);
                    tag.func_74780_a("output", (double)((Integer)outs[3]).intValue() * cycles);
                    tag.func_74780_a("outputmb", (double)((Integer)outs[1]).intValue() * cycles);
                } else {
                    tag.func_74757_a("active", false);
                    tag.func_74780_a("consumption", 0.0);
                    tag.func_74780_a("output", 0.0);
                    tag.func_74780_a("outputmb", 0.0);
                }
            }
            tag.func_74772_a("energy", ((TileEntityMachineTurbine)te).getPower());
            TileEntityMachineTurbine cfr_ignored_4 = (TileEntityMachineTurbine)te;
            tag.func_74772_a("capacity", 1000000L);
            FluidInfo.addTank("tank", tag, ((TileEntityMachineTurbine)te).tanks[0]);
            FluidInfo.addTank("tank2", tag, ((TileEntityMachineTurbine)te).tanks[1]);
            return tag;
        }
        if (te instanceof TileEntityMachineShredder) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityMachineShredder)te).getPower());
            TileEntityMachineShredder cfr_ignored_5 = (TileEntityMachineShredder)te;
            tag2.func_74772_a("capacity", 10000L);
            return tag2;
        }
        if (te instanceof TileEntityMachineBoiler) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("hull", (long)(((TileEntityMachineBoiler)te).heat / 100));
            FluidInfo.addTank("tank", tag2, ((TileEntityMachineBoiler)te).tanks[0]);
            FluidInfo.addTank("tank2", tag2, ((TileEntityMachineBoiler)te).tanks[1]);
            return tag2;
        }
        if (te instanceof TileEntityMachineBoilerElectric) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityMachineBoilerElectric)te).getPower());
            TileEntityMachineBoilerElectric cfr_ignored_6 = (TileEntityMachineBoilerElectric)te;
            tag2.func_74772_a("capacity", 10000L);
            tag2.func_74772_a("hull", (long)(((TileEntityMachineBoilerElectric)te).heat / 100));
            values = this.getHookValues(te);
            if (values != null) {
                tag2.func_74780_a("consumption", (double)((Integer)values.get(0)).intValue());
                tag2.func_74780_a("outputmb", (double)((Integer)values.get(1)).intValue());
            }
            FluidInfo.addTank("tank", tag2, ((TileEntityMachineBoilerElectric)te).tanks[0]);
            FluidInfo.addTank("tank2", tag2, ((TileEntityMachineBoilerElectric)te).tanks[1]);
            return tag2;
        }
        if (te instanceof TileEntityMachineArcFurnace) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityMachineArcFurnace)te).getPower());
            TileEntityMachineArcFurnace cfr_ignored_7 = (TileEntityMachineArcFurnace)te;
            tag2.func_74772_a("capacity", 50000L);
            return tag2;
        }
        if (te instanceof TileEntityMachineCentrifuge) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityMachineCentrifuge)te).getPower());
            TileEntityMachineCentrifuge cfr_ignored_8 = (TileEntityMachineCentrifuge)te;
            tag2.func_74772_a("capacity", 1000000L);
            return tag2;
        }
        if (te instanceof TileEntityMachineGasCent) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityMachineGasCent)te).getPower());
            TileEntityMachineGasCent cfr_ignored_9 = (TileEntityMachineGasCent)te;
            tag2.func_74772_a("capacity", 100000L);
            FluidInfo.addTank("tank", tag2, ((TileEntityMachineGasCent)te).tank);
            return tag2;
        }
        if (te instanceof TileEntityBarrel) {
            tag2 = new NBTTagCompound();
            FluidInfo.addTank("tank", tag2, ((TileEntityBarrel)te).tank);
            return tag2;
        }
        if (te instanceof TileEntityProxyCombo) {
            tag2 = new NBTTagCompound();
            TileEntity base = ((TileEntityProxyCombo)te).getTile();
            if (base instanceof TileEntityMachineLargeTurbine) {
                ArrayList values3 = this.getHookValues(base);
                if (values3 != null) {
                    tag2.func_74757_a("active", (Integer)values3.get(1) > 0);
                    tag2.func_74780_a("consumption", (double)((Integer)values3.get(0)).intValue());
                    tag2.func_74780_a("output", (double)((Integer)values3.get(2)).intValue());
                    tag2.func_74780_a("outputmb", (double)((Integer)values3.get(1)).intValue());
                }
                tag2.func_74772_a("energy", ((TileEntityMachineLargeTurbine)base).getPower());
                TileEntityMachineLargeTurbine cfr_ignored_10 = (TileEntityMachineLargeTurbine)base;
                tag2.func_74772_a("capacity", 100000000L);
                FluidInfo.addTank("tank", tag2, ((TileEntityMachineLargeTurbine)base).tanks[0]);
                FluidInfo.addTank("tank2", tag2, ((TileEntityMachineLargeTurbine)base).tanks[1]);
                return tag2;
            }
            if (base instanceof TileEntitySolarBoiler) {
                IFluidTankProperties[] tanks = ((TileEntitySolarBoiler)base).getTankProperties();
                ArrayList values4 = this.getHookValues(base);
                if (values4 != null) {
                    tag2.func_74780_a("heat", (double)((Integer)values4.get(0)).intValue());
                    tag2.func_74780_a("consumption", (double)((Integer)values4.get(1)).intValue());
                    tag2.func_74780_a("outputmb", (double)((Integer)values4.get(1) * 100));
                }
                FluidInfo.addTank("tank", tag2, tanks[0].getContents());
                FluidInfo.addTank("tank2", tag2, tanks[1].getContents());
                return tag2;
            }
            if (base instanceof TileEntityMachineIGenerator) {
                TileEntityMachineIGenerator generator = (TileEntityMachineIGenerator)base;
                double output = this.calcIGeneratorOutput(generator);
                tag2.func_74757_a("active", output > 0.0);
                tag2.func_74780_a("output", output);
                tag2.func_74772_a("energy", generator.getPower());
                tag2.func_74772_a("capacity", 1000000L);
                tag2.func_74768_a("temp", generator.temperature + 300);
                tag2.func_74768_a("speed", generator.torque);
                FluidInfo.addTank("tank", tag2, generator.tanks[0]);
                FluidInfo.addTank("tank2", tag2, generator.tanks[1]);
                FluidInfo.addTank("tank3", tag2, generator.tanks[2]);
                return tag2;
            }
            if (base instanceof TileEntityITER) {
                TileEntityITER reactor = (TileEntityITER)base;
                tag2.func_74772_a("energy", reactor.getPower());
                tag2.func_74772_a("capacity", 1000000000L);
                int output = FusionRecipes.getSteamProduction((Fluid)reactor.plasmaType) * 20;
                tag2.func_74780_a("consumption", reactor.isOn ? (double)(output * 10) : 0.0);
                tag2.func_74780_a("outputmb", reactor.isOn ? (double)output : 0.0);
                FluidInfo.addTank("tank", tag2, reactor.tanks[0]);
                FluidInfo.addTank("tank2", tag2, reactor.tanks[1]);
                FluidInfo.addTank("tank3", tag2, reactor.plasma);
                return tag2;
            }
            if (base instanceof TileEntityMachinePlasmaHeater) {
                TileEntityMachinePlasmaHeater heater = (TileEntityMachinePlasmaHeater)base;
                tag2.func_74772_a("energy", heater.getPower());
                tag2.func_74772_a("capacity", 10000000000L);
                FluidInfo.addTank("tank", tag2, heater.tanks[0]);
                FluidInfo.addTank("tank2", tag2, heater.tanks[1]);
                FluidInfo.addTank("tank3", tag2, heater.plasma);
                return tag2;
            }
            if (base instanceof TileEntityMachineOrbus) {
                FluidInfo.addTank("tank", tag2, ((TileEntityMachineOrbus)base).tank);
                return tag2;
            }
            if (base instanceof TileEntityMachineFractionTower) {
                FluidInfo.addTank("tank", tag2, ((TileEntityMachineFractionTower)base).tanks[0]);
                FluidInfo.addTank("tank2", tag2, ((TileEntityMachineFractionTower)base).tanks[1]);
                FluidInfo.addTank("tank3", tag2, ((TileEntityMachineFractionTower)base).tanks[2]);
                return tag2;
            }
            if (base instanceof TileEntityMachineCrystallizer) {
                tag2.func_74780_a("consumption", (double)((TileEntityMachineCrystallizer)base).getPowerRequired());
                tag2.func_74772_a("energy", ((TileEntityMachineCrystallizer)base).getPower());
                TileEntityMachineCrystallizer cfr_ignored_11 = (TileEntityMachineCrystallizer)base;
                tag2.func_74772_a("capacity", 1000000L);
                FluidInfo.addTank("tank", tag2, ((TileEntityMachineCrystallizer)base).tank);
                return tag2;
            }
            if (base instanceof TileEntityTowerLarge) {
                ArrayList values5 = this.getHookValues(base);
                if (values5 != null) {
                    tag2.func_74780_a("consumption", (double)((Integer)values5.get(0)).intValue());
                    tag2.func_74780_a("outputmb", (double)((Integer)values5.get(0)).intValue());
                }
                FluidInfo.addTank("tank", tag2, ((TileEntityTowerLarge)base).tanks[0]);
                FluidInfo.addTank("tank2", tag2, ((TileEntityTowerLarge)base).tanks[1]);
                return tag2;
            }
            if (base instanceof TileEntityTowerSmall) {
                ArrayList values6 = this.getHookValues(base);
                if (values6 != null) {
                    tag2.func_74780_a("consumption", (double)((Integer)values6.get(0)).intValue());
                    tag2.func_74780_a("outputmb", (double)((Integer)values6.get(0)).intValue());
                }
                FluidInfo.addTank("tank", tag2, ((TileEntityTowerSmall)base).tanks[0]);
                FluidInfo.addTank("tank2", tag2, ((TileEntityTowerSmall)base).tanks[1]);
                return tag2;
            }
            if (base instanceof TileEntityChungus) {
                TileEntityChungus engine = (TileEntityChungus)base;
                ArrayList values7 = this.getHookValues((TileEntity)engine);
                if (values7 != null) {
                    tag2.func_74757_a("active", (Integer)values7.get(1) > 0);
                    tag2.func_74780_a("consumption", (double)((Integer)values7.get(0)).intValue());
                    tag2.func_74780_a("output", (double)((Integer)values7.get(1)).intValue());
                    tag2.func_74780_a("outputmb", (double)((Integer)values7.get(2)).intValue());
                }
                tag2.func_74772_a("energy", engine.getPower());
                tag2.func_74772_a("capacity", 100000000000L);
                FluidInfo.addTank("tank", tag2, engine.tanks[0]);
                FluidInfo.addTank("tank2", tag2, engine.tanks[1]);
                return tag2;
            }
        }
        if (te instanceof TileEntityDummy) {
            TileEntity base = te.func_145831_w().func_175625_s(((TileEntityDummy)te).target);
            if (base instanceof TileEntityMachineChemplant) {
                tag = new NBTTagCompound();
                tag.func_74772_a("energy", ((TileEntityMachineChemplant)base).getPower());
                TileEntityMachineChemplant cfr_ignored_12 = (TileEntityMachineChemplant)base;
                tag.func_74772_a("capacity", 2000000L);
                FluidInfo.addTank("tank", tag, ((TileEntityMachineChemplant)base).tanks[0]);
                FluidInfo.addTank("tank2", tag, ((TileEntityMachineChemplant)base).tanks[1]);
                FluidInfo.addTank("tank3", tag, ((TileEntityMachineChemplant)base).tanks[2]);
                FluidInfo.addTank("tank4", tag, ((TileEntityMachineChemplant)base).tanks[3]);
                return tag;
            }
            if (base instanceof TileEntityMachineGasFlare) {
                tag = new NBTTagCompound();
                if (((TileEntityMachineGasFlare)te).tank.getFluidAmount() >= 10) {
                    tag.func_74757_a("active", true);
                    tag.func_74780_a("consumption", 10.0);
                    tag.func_74780_a("output", 50.0);
                } else {
                    tag.func_74757_a("active", false);
                    tag.func_74780_a("consumption", 0.0);
                    tag.func_74780_a("output", 0.0);
                }
                tag.func_74772_a("energy", ((TileEntityMachineGasFlare)te).getPower());
                TileEntityMachineGasFlare cfr_ignored_13 = (TileEntityMachineGasFlare)te;
                tag.func_74772_a("capacity", 1000000L);
                FluidInfo.addTank("tank", tag, ((TileEntityMachineGasFlare)te).tank);
                return tag;
            }
            if (base instanceof TileEntityMachineTurbofan) {
                tag = new NBTTagCompound();
                int nrg = 1250;
                int cnsp = 1;
                if (!((TileEntityMachineTurbofan)base).inventory.getStackInSlot(2).func_190926_b()) {
                    if (((TileEntityMachineTurbofan)base).inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_afterburn_1) {
                        nrg *= 2;
                        cnsp = (int)((double)cnsp * 2.5);
                    }
                    if (((TileEntityMachineTurbofan)base).inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_afterburn_2) {
                        nrg *= 3;
                        cnsp *= 5;
                    }
                    if (((TileEntityMachineTurbofan)base).inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_afterburn_3) {
                        nrg *= 4;
                        cnsp = (int)((double)cnsp * 7.5);
                    }
                }
                if (((TileEntityMachineTurbofan)base).tank.getFluidAmount() >= cnsp) {
                    tag.func_74757_a("active", true);
                    tag.func_74780_a("consumption", (double)cnsp);
                    tag.func_74780_a("output", (double)nrg);
                } else {
                    tag.func_74757_a("active", false);
                    tag.func_74780_a("consumption", 0.0);
                    tag.func_74780_a("output", 0.0);
                }
                tag.func_74772_a("energy", ((TileEntityMachineTurbofan)base).getPower());
                TileEntityMachineTurbofan cfr_ignored_14 = (TileEntityMachineTurbofan)base;
                tag.func_74772_a("capacity", 1000000L);
                FluidInfo.addTank("tank", tag, ((TileEntityMachineTurbofan)base).tank);
                return tag;
            }
            if (base instanceof TileEntityMachineRadGen) {
                tag = new NBTTagCompound();
                tag.func_74757_a("active", ((TileEntityMachineRadGen)base).strength > 0);
                tag.func_74780_a("output", (double)((TileEntityMachineRadGen)base).strength);
                tag.func_74772_a("energy", ((TileEntityMachineRadGen)base).getPower());
                TileEntityMachineRadGen cfr_ignored_15 = (TileEntityMachineRadGen)base;
                tag.func_74772_a("capacity", 1000000L);
                tag.func_74768_a("fuel", ((TileEntityMachineRadGen)base).fuel);
                return tag;
            }
            if (base instanceof TileEntityAMSLimiter) {
                tag = new NBTTagCompound();
                tag.func_74772_a("heat", (long)((TileEntityAMSLimiter)base).heat);
                FluidInfo.addTank("tank", tag, ((TileEntityAMSLimiter)base).tank);
                return tag;
            }
            if (base instanceof TileEntityAMSBase) {
                tag = new NBTTagCompound();
                TileEntityAMSBase reactor = (TileEntityAMSBase)base;
                double output = this.calcASMBaseOutput(reactor);
                tag.func_74757_a("active", output > 0.0);
                tag.func_74780_a("output", output);
                tag.func_74772_a("heat", (long)reactor.heat);
                FluidInfo.addTank("tank", tag, reactor.tanks[0]);
                FluidInfo.addTank("tank2", tag, reactor.tanks[1]);
                FluidInfo.addTank("tank3", tag, reactor.tanks[2]);
                FluidInfo.addTank("tank4", tag, reactor.tanks[3]);
                return tag;
            }
            if (base instanceof TileEntityAMSEmitter) {
                tag = new NBTTagCompound();
                tag.func_74772_a("heat", (long)((TileEntityAMSEmitter)base).heat);
                FluidInfo.addTank("tank", tag, ((TileEntityAMSEmitter)base).tank);
                return tag;
            }
            if (base instanceof TileEntityMachineOilWell) {
                tag = new NBTTagCompound();
                tag.func_74772_a("energy", ((TileEntityMachineOilWell)base).getPower());
                tag.func_74772_a("capacity", ((TileEntityMachineOilWell)base).getMaxPower());
                FluidInfo.addTank("tank", tag, ((TileEntityMachineOilWell)base).tanks[0]);
                FluidInfo.addTank("tank2", tag, ((TileEntityMachineOilWell)base).tanks[1]);
                return tag;
            }
            if (base instanceof TileEntityMachineAssembler) {
                tag = new NBTTagCompound();
                tag.func_74772_a("energy", ((TileEntityMachineAssembler)base).getPower());
                TileEntityMachineAssembler cfr_ignored_16 = (TileEntityMachineAssembler)base;
                tag.func_74772_a("capacity", 2000000L);
                return tag;
            }
            if (base instanceof TileEntityMachinePumpjack) {
                tag = new NBTTagCompound();
                tag.func_74772_a("energy", ((TileEntityMachinePumpjack)base).getPower());
                tag.func_74772_a("capacity", ((TileEntityMachinePumpjack)base).getMaxPower());
                FluidInfo.addTank("tank", tag, ((TileEntityMachinePumpjack)base).tanks[0]);
                FluidInfo.addTank("tank2", tag, ((TileEntityMachinePumpjack)base).tanks[1]);
                return tag;
            }
            if (base instanceof TileEntityMachineRefinery) {
                tag = new NBTTagCompound();
                tag.func_74772_a("energy", ((TileEntityMachineRefinery)base).getPower());
                TileEntityMachineRefinery cfr_ignored_17 = (TileEntityMachineRefinery)base;
                tag.func_74772_a("capacity", 1000L);
                FluidInfo.addTank("tank", tag, ((TileEntityMachineRefinery)base).tanks[0]);
                FluidInfo.addTank("tank2", tag, ((TileEntityMachineRefinery)base).tanks[1]);
                FluidInfo.addTank("tank3", tag, ((TileEntityMachineRefinery)base).tanks[2]);
                FluidInfo.addTank("tank4", tag, ((TileEntityMachineRefinery)base).tanks[3]);
                FluidInfo.addTank("tank5", tag, ((TileEntityMachineRefinery)base).tanks[4]);
                return tag;
            }
            if (base instanceof TileEntityMachineFluidTank) {
                tag = new NBTTagCompound();
                FluidInfo.addTank("tank", tag, ((TileEntityMachineFluidTank)base).tank);
                return tag;
            }
        }
        if (te instanceof TileEntityMachineReactorSmall) {
            double steam;
            EnumFacing[] reactor = (EnumFacing[])te;
            tag = new NBTTagCompound();
            tag.func_74757_a("active", reactor.hasCoreHeat());
            double water = steam = (double)reactor.hullHeat * 1.085 / 100000.0 * (double)reactor.tanks[2].getCapacity() / 50.0 * this.getSmallReactorConversion((TileEntityMachineReactorSmall)reactor);
            if (reactor.tankTypes[2] == ModForgeFluids.steam) {
                water /= 100.0;
            } else if (reactor.tankTypes[2] == ModForgeFluids.hotsteam) {
                water /= 10.0;
            }
            tag.func_74780_a("consumption", (double)((int)Math.ceil(water)));
            tag.func_74780_a("outputmb", (double)((int)Math.floor(steam)));
            tag.func_74772_a("core", Math.round((double)reactor.coreHeat * 2.0E-5 * 980.0 + 20.0));
            tag.func_74772_a("hull", Math.round((double)reactor.hullHeat * 1.0E-5 * 980.0 + 20.0));
            FluidInfo.addTank("tank", tag, reactor.tanks[0]);
            FluidInfo.addTank("tank2", tag, reactor.tanks[1]);
            FluidInfo.addTank("tank3", tag, reactor.tanks[2]);
            return tag;
        }
        if (te instanceof TileEntityReactorHatch) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                double steam;
                core = te.func_145831_w().func_175625_s(te.func_174877_v().func_177967_a(side, 2));
                if (!(core instanceof TileEntityMachineReactorLarge)) continue;
                NBTTagCompound tag3 = new NBTTagCompound();
                TileEntityMachineReactorLarge reactor = (TileEntityMachineReactorLarge)core;
                tag3.func_74757_a("active", reactor.rods > 0 && reactor.fuel > 0);
                tag3.func_74772_a("core", Math.round((double)reactor.coreHeat * 2.0E-5 * 980.0 + 20.0));
                tag3.func_74772_a("hull", Math.round((double)reactor.hullHeat * 1.0E-5 * 980.0 + 20.0));
                String fuel = "";
                switch (reactor.type) {
                    case URANIUM: {
                        fuel = "Uranium";
                        break;
                    }
                    case MOX: {
                        fuel = "MOX";
                        break;
                    }
                    case PLUTONIUM: {
                        fuel = "Plutonium";
                        break;
                    }
                    case SCHRABIDIUM: {
                        fuel = "Schrabidium";
                        break;
                    }
                    case THORIUM: {
                        fuel = "Thorium";
                        break;
                    }
                    default: {
                        fuel = "ERROR";
                    }
                }
                tag3.func_74778_a("level", reactor.rods + "%");
                tag3.func_74778_a("fuelText", fuel + ": " + reactor.fuel / TileEntityMachineReactorLarge.fuelMult + "ng");
                tag3.func_74778_a("depleted", fuel + ": " + reactor.waste / TileEntityMachineReactorLarge.fuelMult + "ng");
                double water = steam = (double)reactor.hullHeat * 1.085 / 100000.0 * 8000.0 / 50.0 * (double)reactor.size;
                if (reactor.tankTypes[2] == ModForgeFluids.steam) {
                    water /= 100.0;
                } else if (reactor.tankTypes[2] == ModForgeFluids.hotsteam) {
                    water /= 10.0;
                }
                tag3.func_74780_a("consumption", (double)((int)Math.ceil(water)));
                tag3.func_74780_a("outputmb", (double)((int)Math.floor(steam)));
                FluidInfo.addTank("tank", tag3, reactor.tanks[0]);
                FluidInfo.addTank("tank2", tag3, reactor.tanks[1]);
                FluidInfo.addTank("tank3", tag3, reactor.tanks[2]);
                return tag3;
            }
        }
        if (te instanceof TileEntityWatzHatch) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                core = te.func_145831_w().func_175625_s(te.func_174877_v().func_177967_a(side, 3));
                if (!(core instanceof TileEntityWatzCore)) continue;
                NBTTagCompound tag4 = new NBTTagCompound();
                TileEntityWatzCore reactor = (TileEntityWatzCore)core;
                tag4.func_74757_a("active", reactor.powerList > 0);
                tag4.func_74772_a("energy", reactor.getPower());
                tag4.func_74772_a("capacity", 1000000000L);
                tag4.func_74780_a("output", (double)reactor.powerList);
                tag4.func_74772_a("heat", (long)reactor.heatList);
                FluidInfo.addTank("tank", tag4, reactor.tank);
                return tag4;
            }
        }
        if (te instanceof TileEntityRBMKBase) {
            tag2 = new NBTTagCompound();
            tag2.func_74780_a("heatD", ((TileEntityRBMKBase)te).heat);
            if (te instanceof TileEntityRBMKBoiler) {
                ArrayList values8 = this.getHookValues(te);
                if (values8 != null) {
                    tag2.func_74780_a("consumption", (double)((Integer)values8.get(0)).intValue());
                    tag2.func_74780_a("outputmb", (double)((Integer)values8.get(1)).intValue());
                }
                FluidInfo.addTank("tank", tag2, ((TileEntityRBMKBoiler)te).feed);
                FluidInfo.addTank("tank2", tag2, ((TileEntityRBMKBoiler)te).steam);
            }
            if (te instanceof TileEntityRBMKRod) {
                TileEntityRBMKRod rod = (TileEntityRBMKRod)te;
                ItemStack stack = rod.inventory.getStackInSlot(0);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemRBMKRod) {
                    tag2.func_74780_a("fluxFast", rod.fluxFast);
                    tag2.func_74780_a("fluxSlow", rod.fluxSlow);
                    tag2.func_74780_a("depletion", (1.0 - ItemRBMKRod.getEnrichment((ItemStack)stack)) * 100000.0 / 1000.0);
                    tag2.func_74780_a("xenon", ItemRBMKRod.getPoison((ItemStack)stack));
                    tag2.func_74780_a("skin", ItemRBMKRod.getHullHeat((ItemStack)stack));
                    tag2.func_74780_a("c_heat", ItemRBMKRod.getCoreHeat((ItemStack)stack));
                    tag2.func_74780_a("melt", ((ItemRBMKRod)stack.func_77973_b()).meltingPoint);
                }
            }
            return tag2;
        }
        if (te instanceof TileEntityCoreTitanium) {
            tag2 = new NBTTagCompound();
            tag2.func_74772_a("energy", ((TileEntityCoreTitanium)te).getPower());
            TileEntityCoreTitanium cfr_ignored_18 = (TileEntityCoreTitanium)te;
            tag2.func_74772_a("capacity", 1000000L);
            return tag2;
        }
        if (te instanceof TileEntityGeiger) {
            tag2 = new NBTTagCompound();
            RadiationSavedData data = RadiationSavedData.getData((World)te.func_145831_w());
            double rads = (double)((int)(data.getRadNumFromCoord(te.func_174877_v()) * 10.0f)) / 10.0;
            String chunkPrefix = ContaminationUtil.getPreffixFromRad((double)rads);
            tag2.func_74778_a("chunkRad", chunkPrefix + rads + " RAD/s");
            return tag2;
        }
        return null;
    }

    private double calcAmgenOutput(World world, Block block, BlockPos pos) {
        long power = 0L;
        if (block == ModBlocks.machine_amgen) {
            RadiationSavedData data = RadiationSavedData.getData((World)world);
            float rad = data.getRadNumFromCoord(pos);
            power = (long)((float)power + rad);
            RadiationSavedData.decrementRad((World)world, (BlockPos)pos, (float)5.0f);
        } else if (block == ModBlocks.machine_geo) {
            Block b = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (b == ModBlocks.geysir_water) {
                power += 75L;
            } else if (b == ModBlocks.geysir_chlorine) {
                power += 100L;
            } else if (b == ModBlocks.geysir_vapor) {
                power += 50L;
            } else if (b == ModBlocks.geysir_nether) {
                power += 500L;
            } else if (b == Blocks.field_150353_l) {
                power += 100L;
                if (world.field_73012_v.nextInt(1200) == 0) {
                    world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                }
            } else if (b == Blocks.field_150356_k) {
                power += 25L;
                if (world.field_73012_v.nextInt(600) == 0) {
                    world.func_175656_a(pos.func_177977_b(), Blocks.field_150347_e.func_176223_P());
                }
            }
            b = world.func_180495_p(pos.func_177984_a()).func_177230_c();
            if (b == Blocks.field_150353_l) {
                power += 100L;
                if (world.field_73012_v.nextInt(1200) == 0) {
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150343_Z.func_176223_P());
                }
            } else if (b == Blocks.field_150356_k) {
                power += 25L;
                if (world.field_73012_v.nextInt(600) == 0) {
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150347_e.func_176223_P());
                }
            }
        }
        return power;
    }

    private double calcIGeneratorOutput(TileEntityMachineIGenerator te) {
        int i;
        double output = 0.0;
        int rtg = 0;
        int temp = 0;
        for (i = 3; i <= 5; ++i) {
            if (te.inventory.getStackInSlot(i).func_77973_b() != ModItems.thermo_element) continue;
            rtg += 15;
        }
        for (i = 0; i < te.pellets.length; ++i) {
            if (te.pellets[i] == null) continue;
            temp += te.pellets[i].heat;
        }
        return output += (double)Math.min(te.temperature + temp, rtg) + (double)te.torque * 0.025;
    }

    private long calcASMBaseOutput(TileEntityAMSBase te) {
        int booster = 0;
        if (te.mode == 2) {
            booster += this.getBooster(te.func_145831_w(), te.func_174877_v().func_177982_a(6, 0, 0), 4);
            booster += this.getBooster(te.func_145831_w(), te.func_174877_v().func_177982_a(-6, 0, 0), 5);
            booster += this.getBooster(te.func_145831_w(), te.func_174877_v().func_177982_a(0, 0, 6), 2);
            booster += this.getBooster(te.func_145831_w(), te.func_174877_v().func_177982_a(0, 0, -6), 3);
        }
        float powerMod = 1.0f;
        long powerBase = ItemAMSCore.getPowerBase((ItemStack)te.inventory.getStackInSlot(12));
        for (int j = 8; j < 12; ++j) {
            powerMod *= ItemCatalyst.getPowerMod((ItemStack)te.inventory.getStackInSlot(j));
        }
        powerBase *= (long)te.efficiency;
        powerBase = (long)((double)powerBase * Math.pow(1.25, booster));
        if (this.getFuelPower(te.tanks[2].getFluid()) > 0 && this.getFuelPower(te.tanks[3].getFluid()) > 0 && te.tanks[2].getFluidAmount() > 0 && te.tanks[3].getFluidAmount() > 0) {
            return (long)((float)powerBase * powerMod * this.gauss(1.0f, (te.heat - 2500) / 5000) / 1000.0f * (float)this.getFuelPower(te.tanks[2].getFluid()) * (float)this.getFuelPower(te.tanks[3].getFluid()));
        }
        return 0L;
    }

    private int getBooster(World world, BlockPos pos, int meta) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAMSLimiter && !((TileEntityAMSLimiter)te).locked && te.func_145832_p() == meta) {
            return 1;
        }
        return 0;
    }

    private int getFuelPower(FluidStack type) {
        if (type == null) {
            return 0;
        }
        if (type.getFluid() == ModForgeFluids.deuterium) {
            return 50;
        }
        if (type.getFluid() == ModForgeFluids.tritium) {
            return 75;
        }
        return 0;
    }

    private float gauss(float a, float x) {
        double amplifier = 0.1;
        return (float)(1.0 / Math.sqrt((double)a * Math.PI) * Math.pow(Math.E, -1.0 * Math.pow(x, 2.0) / amplifier));
    }

    private double getSmallReactorConversion(TileEntityMachineReactorSmall te) {
        double conversion = 1.0;
        conversion *= this.getInteractionForBlock(te.func_145831_w(), te.func_174877_v().func_177982_a(1, 1, 0));
        conversion *= this.getInteractionForBlock(te.func_145831_w(), te.func_174877_v().func_177982_a(-1, 1, 0));
        conversion *= this.getInteractionForBlock(te.func_145831_w(), te.func_174877_v().func_177982_a(0, 1, 1));
        return conversion *= this.getInteractionForBlock(te.func_145831_w(), te.func_174877_v().func_177982_a(0, 1, -1));
    }

    private double getInteractionForBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        double conversion = 1.0;
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            conversion *= 0.5;
        } else if (block == Blocks.field_150451_bX) {
            conversion *= 1.15;
        } else if (block == ModBlocks.block_beryllium) {
            conversion *= 1.05;
        } else if (block == ModBlocks.block_schrabidium) {
            conversion *= 1.25;
        }
        return conversion;
    }

    private Fluid getFluid(FluidTank tank, ItemStack stack) {
        Fluid fluid = null;
        if (tank.getFluid() != null) {
            fluid = tank.getFluid().getFluid();
        }
        if (fluid != null) {
            return fluid;
        }
        if (!stack.func_190926_b()) {
            FluidStack contained;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (handler != null) {
                    fluid = FluidUtil.getFluidContained((ItemStack)stack).getFluid();
                }
            } else if (stack.func_77973_b() instanceof IItemFluidHandler) {
                IItemFluidHandler handler = (IItemFluidHandler)stack.func_77973_b();
                FluidStack contained2 = handler.drain(stack, Integer.MAX_VALUE, false);
                fluid = contained2.getFluid();
            } else if (stack.func_77942_o() && (contained = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"))) != null) {
                fluid = contained.getFluid();
            }
        }
        return fluid;
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = HBMHooks.map.get(te);
        if (values == null) {
            HBMHooks.map.put(te, null);
        }
        return values;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitHBM::new);
        ItemCardMain.register(ItemCardHBM::new);
    }

    @Override
    public void loadOreInfo() {
        this.loadOre(1, 32, 30, 10, ModBlocks.gas_flammable);
        this.loadOre(1, 32, 30, 10, ModBlocks.gas_explosive);
        this.loadOre(25, 6, 30, 10, ModBlocks.ore_gneiss_iron);
        this.loadOre(10, 6, 30, 10, ModBlocks.ore_gneiss_gold);
        this.loadOre(WorldConfig.uraniumSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_uranium);
        this.loadOre(WorldConfig.copperSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_copper);
        this.loadOre(WorldConfig.asbestosSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_asbestos);
        this.loadOre(WorldConfig.lithiumSpawn, 6, 30, 10, ModBlocks.ore_gneiss_lithium);
        this.loadOre(WorldConfig.rareSpawn, 6, 30, 10, ModBlocks.ore_gneiss_asbestos);
        this.loadOre(WorldConfig.gassshaleSpawn * 3, 10, 30, 10, ModBlocks.ore_gneiss_gas);
        this.loadOre(WorldConfig.uraniumSpawn, 5, 5, 20, ModBlocks.ore_uranium);
        this.loadOre(WorldConfig.thoriumSpawn, 5, 5, 25, ModBlocks.ore_thorium);
        this.loadOre(WorldConfig.titaniumSpawn, 6, 5, 30, ModBlocks.ore_titanium);
        this.loadOre(WorldConfig.sulfurSpawn, 8, 5, 30, ModBlocks.ore_sulfur);
        this.loadOre(WorldConfig.aluminiumSpawn, 6, 5, 40, ModBlocks.ore_aluminium);
        this.loadOre(WorldConfig.copperSpawn, 6, 5, 45, ModBlocks.ore_copper);
        this.loadOre(WorldConfig.fluoriteSpawn, 4, 5, 45, ModBlocks.ore_fluorite);
        this.loadOre(WorldConfig.niterSpawn, 6, 5, 30, ModBlocks.ore_niter);
        this.loadOre(WorldConfig.tungstenSpawn, 8, 5, 30, ModBlocks.ore_tungsten);
        this.loadOre(WorldConfig.leadSpawn, 9, 5, 30, ModBlocks.ore_lead);
        this.loadOre(WorldConfig.berylliumSpawn, 4, 5, 30, ModBlocks.ore_beryllium);
        this.loadOre(WorldConfig.rareSpawn, 5, 5, 20, ModBlocks.ore_rare);
        this.loadOre(WorldConfig.ligniteSpawn, 24, 35, 25, ModBlocks.ore_lignite);
        this.loadOre(WorldConfig.asbestosSpawn, 4, 16, 16, ModBlocks.ore_asbestos);
        this.loadOre(WorldConfig.cinnebarSpawn, 4, 8, 16, ModBlocks.ore_cinnebar);
        this.loadOre(WorldConfig.cobaltSpawn, 4, 4, 8, ModBlocks.ore_cobalt);
        this.loadOre(WorldConfig.ironClusterSpawn, 6, 5, 50, ModBlocks.cluster_iron);
        this.loadOre(WorldConfig.titaniumClusterSpawn, 6, 5, 30, ModBlocks.cluster_titanium);
        this.loadOre(WorldConfig.aluminiumClusterSpawn, 6, 5, 40, ModBlocks.cluster_aluminium);
        this.loadOre(1, 64, 32, 32, ModBlocks.ore_coal_oil);
    }

    private void loadOre(int veinCount, int amount, int minHeight, int variance, Block block) {
        EnergyControl.oreHelper.put(OreHelper.getId(block, 0), new OreHelper(minHeight, minHeight + variance, amount, veinCount));
    }
}

