/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.blocks;

import com.zuxelus.energycontrol.EnergyControl;
import ic2.api.tile.IWrenchable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="ic2", iface="ic2.api.tile.IWrenchable")
public class BlockLight
extends Block
implements IWrenchable {
    public static final int DAMAGE_WHITE_OFF = 0;
    public static final int DAMAGE_WHITE_ON = 1;
    public static final int DAMAGE_ORANGE_OFF = 2;
    public static final int DAMAGE_ORANGE_ON = 3;
    public static final int DAMAGE_MAX = 3;
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)3);
    public static Map<Integer, Boolean> blocks;

    public BlockLight() {
        super(Material.field_151591_t);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(EnergyControl.creativeTab);
        blocks = new HashMap<Integer, Boolean>();
        this.register(0, false);
        this.register(1, true);
        this.register(2, false);
        this.register(3, true);
    }

    public void register(int damage, boolean isOn) {
        blocks.put(damage, isOn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public final IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta));
    }

    public final int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 1 || meta % 2 == 1) {
            return 15;
        }
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        int i = this.func_176201_c(state);
        if (i % 2 == 0) {
            return i;
        }
        return i - 1;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateBlockState(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.updateBlockState(world, pos, state);
    }

    private void updateBlockState(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        int meta = this.func_176201_c(state);
        if (meta % 2 == 1) {
            if (world.func_175687_A(pos) == 0) {
                world.func_175656_a(pos, this.func_176203_a(meta - 1));
            }
        } else if (world.func_175687_A(pos) > 0) {
            world.func_175656_a(pos, this.func_176203_a(meta + 1));
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i <= 3; ++i) {
            if (i % 2 != 0) continue;
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public EnumFacing getFacing(World world, BlockPos pos) {
        return EnumFacing.UP;
    }

    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return false;
    }

    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        return this.getDrops((IBlockAccess)world, pos, state, 1);
    }
}

