/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol;

import com.zuxelus.energycontrol.EnCtrlTab;
import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.containers.slots.SlotHandler;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.network.ChannelHandler;
import com.zuxelus.energycontrol.proxy.IProxy;
import com.zuxelus.energycontrol.recipes.RecipesNew;
import com.zuxelus.energycontrol.tileentities.ScreenManager;
import com.zuxelus.energycontrol.websockets.SocketClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="energycontrol", version="1.12.2-0.3.2", dependencies="after:ic2;after:techreborn;after:comboarmors@[1.12.2-0.0.9,)", acceptedMinecraftVersions="[1.12.2]")
public class EnergyControl {
    public static final String MODID = "energycontrol";
    public static final String VERSION = "1.12.2-0.3.2";
    @SidedProxy(clientSide="com.zuxelus.energycontrol.proxy.ClientProxy", serverSide="com.zuxelus.energycontrol.proxy.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="energycontrol")
    public static EnergyControl instance;
    public static EnCtrlTab creativeTab;
    public static Logger logger;
    public static Map<String, OreHelper> oreHelper;
    public ScreenManager screenManager = new ScreenManager();
    @SideOnly(value=Side.CLIENT)
    public List<String> availableAlarms;
    @SideOnly(value=Side.CLIENT)
    public List<String> serverAllowedAlarms;
    public static Map<EntityPlayer, Boolean> altPressed;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.importSound(event.getModConfigurationDirectory());
        ChannelHandler.init();
        CrossModLoader.preInit();
        ModItems.registerTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new SlotHandler());
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.registerEventHandlers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerSpecialRenderers();
        CrossModLoader.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        RecipesNew.addRecipes();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        OreHelper.initList(event.getServer().field_71305_c);
        if (EnergyControlConfig.webSocket.wsEnabled && !EnergyControlConfig.webSocket.wsHost.isEmpty()) {
            SocketClient.connect(EnergyControlConfig.webSocket.wsHost, EnergyControlConfig.webSocket.wsPort);
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        if (EnergyControlConfig.webSocket.wsEnabled) {
            SocketClient.close();
        }
    }

    static {
        creativeTab = new EnCtrlTab();
        altPressed = new HashMap<EntityPlayer, Boolean>();
    }
}

