/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.thread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskProfiler {
    public HashMap<String, Long> times = new HashMap();
    public String currentSection;
    private long startTime;
    private long totalTime;
    private long startTimeOnce;
    private String currentOnceSection;

    public void start(String section) {
        if (this.currentSection != null) {
            this.end();
        }
        this.currentSection = section;
        this.startTime = System.nanoTime();
    }

    public void end() {
        long time = System.nanoTime() - this.startTime;
        this.totalTime += time;
        Long prev = this.times.get(this.currentSection);
        if (prev == null) {
            prev = 0L;
        }
        this.times.put(this.currentSection, prev + time);
        this.currentSection = null;
    }

    public void startOnce(String name) {
        this.currentOnceSection = name;
        this.startTimeOnce = System.nanoTime();
    }

    public ProfilerResult endOnce() {
        long end = System.nanoTime() - this.startTimeOnce;
        return new ProfilerResult(this.currentOnceSection, end, end);
    }

    public List<ProfilerResult> getResults() {
        ArrayList<ProfilerResult> results = new ArrayList<ProfilerResult>(this.times.size());
        for (Map.Entry<String, Long> e : this.times.entrySet()) {
            results.add(new ProfilerResult(e.getKey(), e.getValue(), this.totalTime));
        }
        return results;
    }

    public void clear() {
        if (this.currentSection != null) {
            this.end();
        }
        this.times.clear();
        this.totalTime = 0L;
    }

    public static class ProfilerResult {
        public final String name;
        public final long time;
        public final double fraction;

        public ProfilerResult(String name, long time, long totalTime) {
            this.name = name;
            this.time = time;
            this.fraction = (double)time / (double)totalTime;
        }
    }
}

