/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.multiblock;

import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockCuboid;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockTinker;
import slimeknights.tconstruct.smeltery.tileentity.TileSearedFurnace;

public class MultiblockSearedFurnace
extends MultiblockTinker {
    public boolean hasTank;

    public MultiblockSearedFurnace(TileSearedFurnace furnace) {
        super(furnace, true, true, true);
    }

    @Override
    public MultiblockDetection.MultiblockStructure detectMultiblock(World world, BlockPos center, int limit) {
        this.hasTank = false;
        MultiblockDetection.MultiblockStructure ret = super.detectMultiblock(world, center, limit);
        if (!this.hasTank) {
            return null;
        }
        return ret;
    }

    @Override
    public boolean isValidBlock(World world, BlockPos pos) {
        if (pos.equals((Object)this.tile.func_174877_v())) {
            return true;
        }
        return world.func_180495_p(pos).func_177230_c() == TinkerSmeltery.searedBlock && this.isValidSlave(world, pos);
    }

    @Override
    public boolean isCeilingBlock(World world, BlockPos pos) {
        if (pos.equals((Object)this.tile.func_174877_v())) {
            return true;
        }
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSlab && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            return false;
        }
        return TinkerSmeltery.searedStairsSlabs.contains((Object)state.func_177230_c());
    }

    @Override
    public boolean isFrameBlock(World world, BlockPos pos, MultiblockCuboid.EnumFrameType type) {
        if (pos.equals((Object)this.tile.func_174877_v())) {
            return true;
        }
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == TinkerSmeltery.searedTank) {
            this.hasTank = true;
            return true;
        }
        if (type != MultiblockCuboid.EnumFrameType.WALL) {
            return true;
        }
        return state.func_177230_c() == TinkerSmeltery.searedBlock;
    }
}

