/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.packets;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class PacketRemoveTesseractReferences
implements BasePacket {
    private Collection<Pair<Integer, BlockPos>> references;

    public PacketRemoveTesseractReferences(Collection<TesseractReference> references) {
        this.references = references.stream().map(reference -> Pair.of((Object)reference.getDimension(), (Object)reference.getPos())).collect(Collectors.toSet());
    }

    public PacketRemoveTesseractReferences() {
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.references.size());
        for (Pair<Integer, BlockPos> reference : this.references) {
            buffer.writeInt(((Integer)reference.left()).intValue());
            buffer.func_179255_a((BlockPos)reference.right());
        }
    }

    public void read(PacketBuffer buffer) {
        int size = buffer.readInt();
        this.references = new ArrayList<Pair<Integer, BlockPos>>(size);
        for (int i = 0; i < size; ++i) {
            this.references.add((Pair<Integer, BlockPos>)Pair.of((Object)buffer.readInt(), (Object)buffer.func_179259_c()));
        }
    }

    public void handle(PacketContext context) {
        if (context.getHandlingSide().isServer()) {
            return;
        }
        for (Pair<Integer, BlockPos> reference : this.references) {
            TesseractTracker.CLIENT.remove((Integer)reference.left(), (BlockPos)reference.right());
        }
    }
}

