/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.AgeingMobs.lists;

import com.svennieke.AgeingMobs.AgeingMobs;
import com.svennieke.AgeingMobs.config.AgeingMobsConfigGen;
import com.svennieke.AgeingMobs.endermite.EndermiteToShulkerAgeingInfo;
import com.svennieke.AgeingMobs.lists.info.BiomeBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.BiomeTypeBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.BlockBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.BossAgingInfo;
import com.svennieke.AgeingMobs.lists.info.DimensionBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.EntityBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.HeightBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.LightBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.LiquidBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.MagicBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.MoonBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.RegularAgingInfo;
import com.svennieke.AgeingMobs.lists.info.TimeBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.WeatherBasedAgingInfo;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Optional;

public class AgeList {
    public static ArrayList<RegularAgingInfo> agingList = new ArrayList();

    public static void initializeAgeing() {
        if (AgeingMobsConfigGen.general.chargedcreeper.creeperAgeing) {
            AgeList.addWeatherBasedAgeing("CreeperToCharged", "minecraft:creeper", AgeList.createNBTTag(""), "minecraft:creeper", AgeList.createNBTTag("{powered:1b}"), "thunder", AgeingMobsConfigGen.general.chargedcreeper.creeperAgeingTime);
        }
        if (AgeingMobsConfigGen.general.zombiehusk.zombieToHuskAgeing) {
            AgeList.addBiomeTypeBasedAgeing("ZombieToHusk", "minecraft:zombie", AgeList.createNBTTag(""), "minecraft:husk", AgeList.createNBTTag("{IsBaby:0}"), BiomeDictionary.Type.HOT, AgeingMobsConfigGen.general.zombiehusk.zombieToHuskAgeingTime);
            AgeList.addBiomeTypeBasedAgeing("BabyZombieToBabyHusk", "minecraft:zombie", AgeList.createNBTTag("{IsBaby:1b}"), "minecraft:husk", AgeList.createNBTTag("{IsBaby:1b}"), BiomeDictionary.Type.HOT, AgeingMobsConfigGen.general.zombiehusk.zombieToHuskAgeingTime);
        }
        if (AgeingMobsConfigGen.general.huskzombie.huskToZombieAgeing) {
            AgeList.addBiomeTypeBasedAgeing("HuskToZombie", "minecraft:husk", AgeList.createNBTTag(""), "minecraft:zombie", AgeList.createNBTTag("{IsBaby:0}"), BiomeDictionary.Type.COLD, AgeingMobsConfigGen.general.huskzombie.huskToZombieAgeingTime);
            AgeList.addBiomeTypeBasedAgeing("BabyHuskToBabyZombie", "minecraft:husk", AgeList.createNBTTag("{IsBaby:1b}"), "minecraft:zombie", AgeList.createNBTTag("{IsBaby:1b}"), BiomeDictionary.Type.COLD, AgeingMobsConfigGen.general.huskzombie.huskToZombieAgeingTime);
        }
        if (AgeingMobsConfigGen.general.villagervindicator.villagerToVindicatorAgeing) {
            AgeList.addDarknessBasedAgeing("VillagerToVindicator", "minecraft:villager", AgeList.createNBTTag(""), "minecraft:vindication_illager", AgeList.createNBTTag(""), AgeingMobsConfigGen.general.villagervindicator.minimumLightLevel, AgeingMobsConfigGen.general.villagervindicator.maximumLightLevel, false, true, AgeingMobsConfigGen.general.villagervindicator.villagerToVindicatorAgeingTime);
        }
        if (AgeingMobsConfigGen.general.vindicatorevoker.vindicatorToEvokerAgeing) {
            AgeList.addMagicBasedAgeing("VindicatorToEvoker", "minecraft:vindication_illager", AgeList.createNBTTag(""), "minecraft:evocation_illager", AgeList.createNBTTag(""), AgeingMobsConfigGen.general.vindicatorevoker.vindicatorToEvokerAgeingTime);
        }
        if (AgeingMobsConfigGen.general.guardianelder.guardianToElderAgeing) {
            AgeList.addBossAgeing("GuardianToElder", "minecraft:guardian", AgeList.createNBTTag(""), "minecraft:elder_guardian", AgeList.createNBTTag(""), AgeingMobsConfigGen.general.guardianelder.guardianToElderAgeingMax, AgeingMobsConfigGen.general.guardianelder.guardianToElderRange, AgeingMobsConfigGen.general.guardianelder.guardianToElderAgeingTime);
        }
        if (AgeingMobsConfigGen.general.babyzombie.babyToZombieAgeing) {
            AgeList.addRegularAgeing("BabyToZombie", "minecraft:zombie", AgeList.createNBTTag("{IsBaby:1b}"), "minecraft:zombie", AgeList.createNBTTag("{IsBaby:0}"), AgeingMobsConfigGen.general.babyzombie.babyToZombieAgeingTime);
            AgeList.addRegularAgeing("BabyToHusk", "minecraft:husk", AgeList.createNBTTag("{IsBaby:1b}"), "minecraft:husk", AgeList.createNBTTag("{IsBaby:0}"), AgeingMobsConfigGen.general.babyzombie.babyToZombieAgeingTime);
        }
        if (AgeingMobsConfigGen.general.endermiteshulker.endermiteToShulkerAgeing) {
            AgeList.addEndermite();
        }
        if (AgeingMobsConfigGen.general.skeletonstray.skeletonToStrayAgeing) {
            AgeList.addBiomeTypeBasedAgeing("SkeletonToStray", "minecraft:skeleton", AgeList.createNBTTag(""), "minecraft:stray", AgeList.createNBTTag(""), BiomeDictionary.Type.COLD, AgeingMobsConfigGen.general.skeletonstray.skeletonToStrayAgeingTime);
        }
        if (AgeingMobsConfigGen.general.strayskeleton.strayToSkeletonAgeing) {
            AgeList.addBiomeTypeBasedAgeing("StrayToSkeleton", "minecraft:stray", AgeList.createNBTTag(""), "minecraft:skeleton", AgeList.createNBTTag(""), BiomeDictionary.Type.HOT, AgeingMobsConfigGen.general.strayskeleton.strayToSkeletonAgeingTime);
        }
        if (AgeingMobsConfigGen.general.rabbitkiller.rabbitToKillerAgeing) {
            AgeList.addDarknessBasedAgeing("RabbitToKiller", "minecraft:rabbit", AgeList.createNBTTag(""), "minecraft:rabbit", AgeList.createNBTTag("{RabbitType:99}"), AgeingMobsConfigGen.general.rabbitkiller.minimumLightLevel, AgeingMobsConfigGen.general.rabbitkiller.maximumLightLevel, true, false, AgeingMobsConfigGen.general.rabbitkiller.rabbitToKillerAgeingTime);
        }
        if (AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeing) {
            AgeList.addBlockBasedAgeing("CowToMooshroom", "minecraft:cow", AgeList.createNBTTag(""), "minecraft:mooshroom", AgeList.createNBTTag(""), Blocks.field_150391_bh.func_176223_P(), false, 0, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingTime);
            AgeList.addBlockBasedAgeing("CowToMooshroom", "minecraft:cow", AgeList.createNBTTag(""), "minecraft:mooshroom", AgeList.createNBTTag(""), Blocks.field_150338_P.func_176223_P(), true, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingRadius, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingTime);
            AgeList.addBlockBasedAgeing("CowToMooshroom", "minecraft:cow", AgeList.createNBTTag(""), "minecraft:mooshroom", AgeList.createNBTTag(""), Blocks.field_150420_aW.func_176223_P(), true, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingRadius, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingTime);
            AgeList.addBlockBasedAgeing("CowToMooshroom", "minecraft:cow", AgeList.createNBTTag(""), "minecraft:mooshroom", AgeList.createNBTTag(""), Blocks.field_150337_Q.func_176223_P(), true, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingRadius, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingTime);
            AgeList.addBlockBasedAgeing("CowToMooshroom", "minecraft:cow", AgeList.createNBTTag(""), "minecraft:mooshroom", AgeList.createNBTTag(""), Blocks.field_150419_aX.func_176223_P(), true, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingRadius, AgeingMobsConfigGen.general.cowmooshroom.cowToMooshroomAgeingTime);
        }
        if (AgeingMobsConfigGen.general.skeletonwitherskelly.skeletonToWitherSkeletonAgeing) {
            AgeList.addDimensionBasedAgeing("SkeletonToWitherSkelly", "minecraft:skeleton", AgeList.createNBTTag(""), "minecraft:wither_skeleton", AgeList.createNBTTag(""), -1, AgeingMobsConfigGen.general.skeletonwitherskelly.skeletonToWitherSkeletonAgeingTime);
        }
        if (AgeingMobsConfigGen.general.slimemagma.slimeToMagmaCubeAgeing) {
            AgeList.addDimensionBasedAgeing("SlimeToMagmaCube", "minecraft:slime", AgeList.createNBTTag(""), "minecraft:magma_cube", AgeList.createNBTTag(""), -1, AgeingMobsConfigGen.general.slimemagma.slimeToMagmaCubeAgeingTime);
        }
        if (AgeingMobsConfigGen.general.batvex.batToVexAgeing) {
            AgeList.addRegularAgeing("BatToVex", "minecraft:bat", AgeList.createNBTTag(""), "minecraft:vex", AgeList.createNBTTag(""), AgeingMobsConfigGen.general.batvex.batToVexAgeingTime);
        }
    }

    public static void addRegularAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int tickTime) {
        RegularAgingInfo regular_info = new RegularAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, tickTime);
        if (agingList.contains(regular_info)) {
            return;
        }
        agingList.add(regular_info);
    }

    public static void addBossAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int maxInArea, int checkRadius, int tickTime) {
        BossAgingInfo boss_info = new BossAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, maxInArea, checkRadius, tickTime);
        if (agingList.contains(boss_info)) {
            return;
        }
        agingList.add(boss_info);
    }

    public static void addBiomeBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, Biome biome, int tickTime) {
        BiomeBasedAgingInfo biomeBased_info = new BiomeBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, biome, tickTime);
        if (agingList.contains(biomeBased_info)) {
            return;
        }
        agingList.add(biomeBased_info);
    }

    public static void addBiomeTypeBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, BiomeDictionary.Type biomeType, int tickTime) {
        BiomeTypeBasedAgingInfo biomeTypeBased_info = new BiomeTypeBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, biomeType, tickTime);
        if (agingList.contains(biomeTypeBased_info)) {
            return;
        }
        agingList.add(biomeTypeBased_info);
    }

    public static void addWeatherBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String weather, int tickTime) {
        WeatherBasedAgingInfo weatherBased_info = new WeatherBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, weather, tickTime);
        if (agingList.contains(weatherBased_info)) {
            return;
        }
        agingList.add(weatherBased_info);
    }

    public static void addTimeBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int minTime, int maxTime, int tickTime) {
        TimeBasedAgingInfo heightBased_info = new TimeBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, minTime, maxTime, tickTime);
        if (agingList.contains(heightBased_info)) {
            return;
        }
        agingList.add(heightBased_info);
    }

    public static void addMoonBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String moonPhase, int tickTime) {
        MoonBasedAgingInfo moonBased_info = new MoonBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, moonPhase, tickTime);
        if (agingList.contains(moonBased_info)) {
            return;
        }
        agingList.add(moonBased_info);
    }

    public static void addMagicBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int tickTime) {
        MagicBasedAgingInfo magicBased_info = new MagicBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, tickTime);
        if (agingList.contains(magicBased_info)) {
            return;
        }
        agingList.add(magicBased_info);
    }

    public static void addDarknessBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int lightLevelMin, int lightLevelMax, boolean alone, boolean reversable, int tickTime) {
        LightBasedAgingInfo darknessBased_info = new LightBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, lightLevelMin, lightLevelMax, alone, reversable, tickTime);
        if (agingList.contains(darknessBased_info)) {
            return;
        }
        agingList.add(darknessBased_info);
    }

    public static void addDimensionBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int dimension, int tickTime) {
        DimensionBasedAgingInfo dimensionBased_info = new DimensionBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, dimension, tickTime);
        if (agingList.contains(dimensionBased_info)) {
            return;
        }
        agingList.add(dimensionBased_info);
    }

    public static void addBlockBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, IBlockState state, boolean nearby, int radius, int tickTime) {
        BlockBasedAgingInfo blockBased_info = new BlockBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, state, nearby, radius, tickTime);
        if (agingList.contains(blockBased_info)) {
            return;
        }
        agingList.add(blockBased_info);
    }

    public static void addLiquidBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String liquid, boolean reversible, int tickTime) {
        LiquidBasedAgingInfo liquidBased_info = new LiquidBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, liquid, reversible, tickTime);
        if (agingList.contains(liquidBased_info)) {
            return;
        }
        agingList.add(liquidBased_info);
    }

    public static void addHeightBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int minHeight, int maxHeight, int tickHeight) {
        HeightBasedAgingInfo heightBased_info = new HeightBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, minHeight, maxHeight, tickHeight);
        if (agingList.contains(heightBased_info)) {
            return;
        }
        agingList.add(heightBased_info);
    }

    public static void addEntityBasedAgeing(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String entityNearby, NBTTagCompound entityNearbyData, int radius, int tickTime) {
        EntityBasedAgingInfo entityBased_info = new EntityBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, entityNearby, entityNearbyData, radius, tickTime);
        if (agingList.contains(entityBased_info)) {
            return;
        }
        agingList.add(entityBased_info);
    }

    public static void addEndermite() {
        EndermiteToShulkerAgeingInfo endermite_info = new EndermiteToShulkerAgeingInfo("EndermiteToShulker", "minecraft:endermite", "minecraft:shulker", AgeingMobsConfigGen.general.endermiteshulker.endermiteToShulkerAgeingTime);
        if (agingList.contains(endermite_info)) {
            return;
        }
        agingList.add(endermite_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedRegularAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int tickTime) {
        RegularAgingInfo regular_info = new RegularAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, tickTime);
        regular_info.setGameStage(gamestage);
        if (agingList.contains(regular_info)) {
            return;
        }
        agingList.add(regular_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedBossAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int maxInArea, int checkRadius, int tickTime) {
        BossAgingInfo boss_info = new BossAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, maxInArea, checkRadius, tickTime);
        boss_info.setGameStage(gamestage);
        if (agingList.contains(boss_info)) {
            return;
        }
        agingList.add(boss_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedBiomeBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, Biome biome, int tickTime) {
        BiomeBasedAgingInfo biomeBased_info = new BiomeBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, biome, tickTime);
        biomeBased_info.setGameStage(gamestage);
        if (agingList.contains(biomeBased_info)) {
            return;
        }
        agingList.add(biomeBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedBiomeTypeBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, BiomeDictionary.Type biomeType, int tickTime) {
        BiomeTypeBasedAgingInfo biomeTypeBased_info = new BiomeTypeBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, biomeType, tickTime);
        biomeTypeBased_info.setGameStage(gamestage);
        if (agingList.contains(biomeTypeBased_info)) {
            return;
        }
        agingList.add(biomeTypeBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedWeatherBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String weather, int tickTime) {
        WeatherBasedAgingInfo weatherBased_info = new WeatherBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, weather, tickTime);
        weatherBased_info.setGameStage(gamestage);
        if (agingList.contains(weatherBased_info)) {
            return;
        }
        agingList.add(weatherBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedTimeBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int minTime, int maxTime, int tickTime) {
        TimeBasedAgingInfo heightBased_info = new TimeBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, minTime, maxTime, tickTime);
        heightBased_info.setGameStage(gamestage);
        if (agingList.contains(heightBased_info)) {
            return;
        }
        agingList.add(heightBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedMoonBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String moonPhase, int tickTime) {
        MoonBasedAgingInfo moonBased_info = new MoonBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, moonPhase, tickTime);
        moonBased_info.setGameStage(gamestage);
        if (agingList.contains(moonBased_info)) {
            return;
        }
        agingList.add(moonBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedMagicBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int tickTime) {
        MagicBasedAgingInfo magicBased_info = new MagicBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, tickTime);
        magicBased_info.setGameStage(gamestage);
        if (agingList.contains(magicBased_info)) {
            return;
        }
        agingList.add(magicBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedDarknessBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int lightLevelMin, int lightLevelMax, boolean alone, boolean reversable, int tickTime) {
        LightBasedAgingInfo darknessBased_info = new LightBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, lightLevelMin, lightLevelMax, alone, reversable, tickTime);
        darknessBased_info.setGameStage(gamestage);
        if (agingList.contains(darknessBased_info)) {
            return;
        }
        agingList.add(darknessBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedDimensionBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int dimension, int tickTime) {
        DimensionBasedAgingInfo dimensionBased_info = new DimensionBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, dimension, tickTime);
        dimensionBased_info.setGameStage(gamestage);
        if (agingList.contains(dimensionBased_info)) {
            return;
        }
        agingList.add(dimensionBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedBlockBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, IBlockState state, boolean nearby, int radius, int tickTime) {
        BlockBasedAgingInfo blockBased_info = new BlockBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, state, nearby, radius, tickTime);
        blockBased_info.setGameStage(gamestage);
        if (agingList.contains(blockBased_info)) {
            return;
        }
        agingList.add(blockBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedLiquidBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String liquid, boolean reversible, int tickTime) {
        LiquidBasedAgingInfo liquidBased_info = new LiquidBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, liquid, reversible, tickTime);
        liquidBased_info.setGameStage(gamestage);
        if (agingList.contains(liquidBased_info)) {
            return;
        }
        agingList.add(liquidBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedHeightBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int minHeight, int maxHeight, int tickTime) {
        HeightBasedAgingInfo heightBased_info = new HeightBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, minHeight, maxHeight, tickTime);
        heightBased_info.setGameStage(gamestage);
        if (agingList.contains(heightBased_info)) {
            return;
        }
        agingList.add(heightBased_info);
    }

    @Optional.Method(modid="gamestages")
    public static void addStagedEntityBasedAgeing(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String entityNearby, NBTTagCompound entityNearbyData, int radius, int tickTime) {
        EntityBasedAgingInfo entityBased_info = new EntityBasedAgingInfo(uniqueID, entity, entityData, transformedEntity, changedEntityData, entityNearby, entityNearbyData, radius, tickTime);
        entityBased_info.setGameStage(gamestage);
        if (agingList.contains(entityBased_info)) {
            return;
        }
        agingList.add(entityBased_info);
    }

    public static NBTTagCompound createNBTTag(String nbtData) {
        NBTTagCompound tag = new NBTTagCompound();
        try {
            String data = nbtData;
            tag = data.startsWith("{") && data.endsWith("}") ? JsonToNBT.func_180713_a((String)data) : JsonToNBT.func_180713_a((String)("{" + data + "}"));
        }
        catch (NBTException nbtexception) {
            AgeingMobs.logger.error("nope... " + (Object)((Object)nbtexception));
        }
        return tag;
    }
}

