/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.AgeingMobs.handlers;

import com.svennieke.AgeingMobs.AgeingMobs;
import com.svennieke.AgeingMobs.config.AgeingMobsConfigGen;
import com.svennieke.AgeingMobs.endermite.AIHideInPurpur;
import com.svennieke.AgeingMobs.endermite.EndermiteToShulkerAgeingInfo;
import com.svennieke.AgeingMobs.lists.AgeList;
import com.svennieke.AgeingMobs.lists.info.BiomeBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.BiomeTypeBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.BlockBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.BossAgingInfo;
import com.svennieke.AgeingMobs.lists.info.DimensionBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.EntityBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.HeightBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.LightBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.LiquidBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.MagicBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.MoonBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.RegularAgingInfo;
import com.svennieke.AgeingMobs.lists.info.TimeBasedAgingInfo;
import com.svennieke.AgeingMobs.lists.info.WeatherBasedAgingInfo;
import com.svennieke.AgeingMobs.util.AgeingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.darkhax.bookshelf.util.EntityUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AgeingHandler {
    private int tickCounter = 0;

    @SubscribeEvent
    public void AgeHandler(TickEvent.WorldTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && event.side.isServer()) {
            World world = event.world;
            if (this.tickCounter >= 20) {
                this.tickCounter = 0;
                if (AgeList.agingList != null && !AgeList.agingList.isEmpty()) {
                    for (RegularAgingInfo info : AgeList.agingList) {
                        if (world.field_72996_f == null || world.field_72996_f.isEmpty() || world.field_72995_K) continue;
                        ArrayList loadedEntityList = new ArrayList(world.field_72996_f);
                        for (Entity entity : loadedEntityList) {
                            if (entity instanceof EntityPlayer || entity instanceof FakePlayer || !EntityList.func_180123_a((Entity)entity, (ResourceLocation)AgeingHelper.getEntityLocation(info.getEntity()))) continue;
                            if (info.getEntity().equals(info.getEvolvedEntity())) {
                                if (!info.getChangedEntityData().func_82582_d()) {
                                    this.CheckList(info, entity, world);
                                    continue;
                                }
                                AgeingMobs.logger.error("An error has occured. A mob can not transform into itself. See id: %s", new Object[]{info.getUniqueID()});
                                if (!AgeList.agingList.contains(info)) continue;
                                AgeList.agingList.remove(info);
                                continue;
                            }
                            this.CheckList(info, entity, world);
                        }
                    }
                }
            }
            ++this.tickCounter;
        }
    }

    public void CheckList(RegularAgingInfo info, Entity entity, World world) {
        if (info.getEntity().equals(info.getEvolvedEntity())) {
            if (info.getEntityData().equals((Object)info.getChangedEntityData())) {
                AgeingMobs.logger.error("Aged Entity nbt identical to the original: %s", new Object[]{info.getUniqueID()});
            } else if (info.getEntityData().func_82582_d()) {
                if (!info.getChangedEntityData().func_82582_d()) {
                    NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                    NBTTagCompound entityTag2 = info.getChangedEntityData();
                    if (!entityTag2.func_82582_d() && !NBTUtil.func_181123_a((NBTBase)entityTag2, (NBTBase)entityTag, (boolean)true)) {
                        this.extraChecks(info, entity, world);
                    }
                } else {
                    AgeingMobs.logger.error("Aged Entity identical to the original: %s", new Object[]{info.getUniqueID()});
                }
            } else if (!info.getChangedEntityData().func_82582_d()) {
                NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                NBTTagCompound entityTag2 = info.getEntityData();
                NBTTagCompound entityTag3 = info.getChangedEntityData();
                if (!entityTag2.func_82582_d() && !entityTag3.func_82582_d() && NBTUtil.func_181123_a((NBTBase)entityTag2, (NBTBase)entityTag, (boolean)true) && !NBTUtil.func_181123_a((NBTBase)entityTag3, (NBTBase)entityTag, (boolean)true)) {
                    this.extraChecks(info, entity, world);
                }
            } else {
                NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                NBTTagCompound entityTag2 = info.getEntityData();
                if (!entityTag2.func_82582_d() && NBTUtil.func_181123_a((NBTBase)entityTag2, (NBTBase)entityTag, (boolean)true)) {
                    this.extraChecks(info, entity, world);
                }
            }
        } else if (!info.getEntityData().func_82582_d()) {
            NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
            NBTTagCompound entityTag2 = info.getEntityData();
            NBTTagCompound entityTag3 = info.getChangedEntityData();
            if (!entityTag2.func_82582_d() && !entityTag3.func_82582_d() && NBTUtil.func_181123_a((NBTBase)entityTag2, (NBTBase)entityTag, (boolean)true) && !NBTUtil.func_181123_a((NBTBase)entityTag3, (NBTBase)entityTag, (boolean)true)) {
                this.extraChecks(info, entity, world);
            }
        } else {
            this.extraChecks(info, entity, world);
        }
    }

    public void extraChecks(RegularAgingInfo info, Entity entity, World world) {
        if (Loader.isModLoaded((String)"gamestages")) {
            this.gamestageChecks(info, entity, world);
        } else {
            this.ExecuteAppropiateMethod(info, entity, world);
        }
    }

    @Optional.Method(modid="gamestages")
    public void gamestageChecks(RegularAgingInfo info, Entity entity, World world) {
        if (info.getGameStage() != null) {
            if (!info.getGameStage().isEmpty()) {
                for (EntityPlayer player : world.field_73010_i) {
                    if (!GameStageHelper.hasStage((EntityPlayer)player, (String)info.getGameStage()) || !(EntityUtils.getDistanceFromEntity((Entity)player, (Entity)entity) <= 32.0)) continue;
                    this.ExecuteAppropiateMethod(info, entity, world);
                    break;
                }
            } else {
                AgeingMobs.logger.error("Given stage of ageing is empty: %s", new Object[]{info.getUniqueID()});
                if (AgeList.agingList.contains(info)) {
                    AgeList.agingList.remove(info);
                }
            }
        } else {
            this.ExecuteAppropiateMethod(info, entity, world);
        }
    }

    public void ExecuteAppropiateMethod(RegularAgingInfo info, Entity entity, World world) {
        if (info instanceof BiomeBasedAgingInfo) {
            BiomeBasedAgingInfo biomeInfo = (BiomeBasedAgingInfo)info;
            this.biomeChecks(biomeInfo, entity, world);
        } else if (info instanceof BiomeTypeBasedAgingInfo) {
            BiomeTypeBasedAgingInfo biomeTypeInfo = (BiomeTypeBasedAgingInfo)info;
            this.biomeTypeChecks(biomeTypeInfo, entity, world);
        } else if (info instanceof BlockBasedAgingInfo) {
            BlockBasedAgingInfo blockInfo = (BlockBasedAgingInfo)info;
            this.blockChecks(blockInfo, entity, world);
        } else if (info instanceof BossAgingInfo) {
            BossAgingInfo bossInfo = (BossAgingInfo)info;
            this.bossChecks(bossInfo, entity, world);
        } else if (info instanceof DimensionBasedAgingInfo) {
            DimensionBasedAgingInfo dimensionInfo = (DimensionBasedAgingInfo)info;
            this.dimensionChecks(dimensionInfo, entity, world);
        } else if (info instanceof EndermiteToShulkerAgeingInfo) {
            EndermiteToShulkerAgeingInfo endermiteInfo = (EndermiteToShulkerAgeingInfo)info;
            if (entity instanceof EntityEndermite) {
                String uniqueTag = "ageingmobs:" + endermiteInfo.getUniqueID();
                EntityEndermite endermite = (EntityEndermite)entity;
                NBTTagCompound data = endermite.getEntityData();
                if (!data.func_74767_n(uniqueTag + "Done")) {
                    this.AgeTheEndermite(endermiteInfo, endermite, world);
                }
            }
        } else if (info instanceof LightBasedAgingInfo) {
            LightBasedAgingInfo lightInfo = (LightBasedAgingInfo)info;
            this.LightChecks(lightInfo, entity, world);
        } else if (info instanceof MagicBasedAgingInfo) {
            MagicBasedAgingInfo magicInfo = (MagicBasedAgingInfo)info;
            this.magicChecks(magicInfo, entity, world);
        } else if (info instanceof MoonBasedAgingInfo) {
            MoonBasedAgingInfo moonInfo = (MoonBasedAgingInfo)info;
            this.moonChecks(moonInfo, entity, world);
        } else if (info instanceof TimeBasedAgingInfo) {
            TimeBasedAgingInfo timeInfo = (TimeBasedAgingInfo)info;
            this.timeChecks(timeInfo, entity, world);
        } else if (info instanceof WeatherBasedAgingInfo) {
            WeatherBasedAgingInfo weatherInfo = (WeatherBasedAgingInfo)info;
            this.weatherChecks(weatherInfo, entity, world);
        } else if (info instanceof LiquidBasedAgingInfo) {
            LiquidBasedAgingInfo liquidInfo = (LiquidBasedAgingInfo)info;
            this.liquidChecks(liquidInfo, entity, world);
        } else if (info instanceof HeightBasedAgingInfo) {
            HeightBasedAgingInfo heightInfo = (HeightBasedAgingInfo)info;
            this.heightChecks(heightInfo, entity, world);
        } else if (info instanceof EntityBasedAgingInfo) {
            EntityBasedAgingInfo entityInfo = (EntityBasedAgingInfo)info;
            this.entityChecks(entityInfo, entity, world);
        } else {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void biomeChecks(BiomeBasedAgingInfo info, Entity entity, World world) {
        if (world.func_180494_b(entity.func_180425_c()).equals(info.getBiome())) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void biomeTypeChecks(BiomeTypeBasedAgingInfo info, Entity entity, World world) {
        if (BiomeDictionary.getTypes((Biome)world.func_180494_b(entity.func_180425_c())).contains(info.getBiomeType())) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void blockChecks(BlockBasedAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        Block checkForBlock = info.getState().func_177230_c();
        if (info.isNearBlock()) {
            int radius = info.getRadius();
            for (BlockPos location : BlockPos.func_177980_a((BlockPos)entityPos.func_177982_a(-radius, -radius, -radius), (BlockPos)entityPos.func_177982_a(radius, radius, radius))) {
                if (!world.func_180495_p(location).func_177230_c().equals(checkForBlock)) continue;
                this.AgeTheMob(info, entity, world);
            }
        } else if (world.func_180495_p(entityPos.func_177977_b()).func_177230_c().equals(checkForBlock)) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void bossChecks(BossAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        if (info.getMaxInArea() != 0) {
            int checkRadius = info.getCheckRadius();
            int bossAmount = 0;
            AxisAlignedBB areaHitbox = new AxisAlignedBB((double)((float)entityPos.func_177958_n() - 0.5f), (double)((float)entityPos.func_177956_o() - 0.5f), (double)((float)entityPos.func_177952_p() - 0.5f), (double)((float)entityPos.func_177958_n() + 0.5f), (double)((float)entityPos.func_177956_o() + 0.5f), (double)((float)entityPos.func_177952_p() + 0.5f)).func_72321_a((double)(-checkRadius), (double)(-checkRadius), (double)(-checkRadius)).func_72321_a((double)checkRadius, (double)checkRadius, (double)checkRadius);
            if (!world.func_72872_a(Entity.class, areaHitbox).isEmpty()) {
                for (Entity foundEntity : world.func_72872_a(Entity.class, areaHitbox)) {
                    if (foundEntity instanceof EntityPlayer || foundEntity instanceof FakePlayer || !EntityList.func_180123_a((Entity)foundEntity, (ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()))) continue;
                    if (!info.getChangedEntityData().func_82582_d()) {
                        NBTTagCompound entityTag = AgeingHelper.entityToNBT(foundEntity);
                        NBTTagCompound entityTag2 = info.getChangedEntityData();
                        if (NBTUtil.func_181123_a((NBTBase)entityTag2, (NBTBase)entityTag, (boolean)true)) continue;
                        ++bossAmount;
                        continue;
                    }
                    ++bossAmount;
                }
            }
            if (bossAmount < info.getMaxInArea()) {
                this.AgeTheMob(info, entity, world);
            }
        } else {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void dimensionChecks(DimensionBasedAgingInfo info, Entity entity, World world) {
        if (entity.field_71093_bK == info.getDimensionID()) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void LightChecks(LightBasedAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        int minLevel = info.getLightLevelMin();
        int maxLevel = info.getLightLevelMax();
        int entityLight = world.func_175642_b(EnumSkyBlock.BLOCK, entity.func_180425_c());
        if (entityLight >= minLevel && entityLight <= maxLevel) {
            if (info.isAloneBased()) {
                AxisAlignedBB areaHitbox = new AxisAlignedBB((double)((float)entityPos.func_177958_n() - 0.5f), (double)((float)entityPos.func_177956_o() - 0.5f), (double)((float)entityPos.func_177952_p() - 0.5f), (double)((float)entityPos.func_177958_n() + 0.5f), (double)((float)entityPos.func_177956_o() + 0.5f), (double)((float)entityPos.func_177952_p() + 0.5f)).func_72321_a(-5.0, -5.0, -5.0).func_72321_a(5.0, 5.0, 5.0);
                if (!world.func_72872_a(Entity.class, areaHitbox).contains(EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEntity()), (World)world))) {
                    this.AgeTheMob(info, entity, world);
                }
            } else {
                this.AgeTheMob(info, entity, world);
            }
        } else if (info.isReversable()) {
            this.BabifyTheMob(info, entity, world);
        }
    }

    public void magicChecks(MagicBasedAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        String[] magicalBlocks = AgeingMobsConfigGen.list.magical_blocks;
        if (magicalBlocks.length != 0) {
            HashMap<IBlockState, Double> importanceList = new HashMap<IBlockState, Double>();
            double totalImportance = 0.0;
            for (int i = 0; i < magicalBlocks.length; ++i) {
                String block = magicalBlocks[i];
                String[] blockInfo = block.split(";");
                if (blockInfo.length > 2) {
                    AgeingMobs.logger.error("An error has occured. %s is using the wrong syntax.", new Object[]{block});
                    continue;
                }
                if (blockInfo.length != 2) continue;
                String blockName = blockInfo[0];
                double importance = Double.valueOf(blockInfo[1]);
                IBlockState state = Block.func_149684_b((String)blockName).func_176223_P();
                if (importanceList.containsKey(state)) continue;
                importanceList.put(state, importance);
            }
            for (BlockPos location : BlockPos.func_177980_a((BlockPos)entityPos.func_177982_a(-5, -5, -5), (BlockPos)entityPos.func_177982_a(5, 5, 5))) {
                IBlockState foundState = world.func_180495_p(location);
                if (!importanceList.containsKey(foundState)) continue;
                double importanceFound = (Double)importanceList.get(foundState);
                totalImportance += importanceFound;
            }
            if (totalImportance > 0.0) {
                this.AgeTheMobMagic(info, entity, world, totalImportance > 5.0 ? 5.0 : totalImportance);
            }
        } else {
            AgeingMobs.logger.error("An error has occured. %s is using Magical Blocks but your config has no magical blocks specified.", new Object[]{info.getUniqueID()});
            if (AgeList.agingList.contains(info)) {
                AgeList.agingList.remove(info);
            }
        }
    }

    public void moonChecks(MoonBasedAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        WorldProvider provider = world.field_73011_w;
        int moonPhase = provider.func_76559_b(world.func_72820_D());
        String[] moonDimensions = AgeingMobsConfigGen.list.moon_dimensions;
        if (moonDimensions.length != 0) {
            int wantedPhase;
            ArrayList<Integer> dimensions = new ArrayList<Integer>();
            for (int i = 0; i < moonDimensions.length; ++i) {
                int dim = Integer.valueOf(moonDimensions[i]);
                if (dimensions.contains(dim)) continue;
                dimensions.add(dim);
            }
            if (dimensions.contains(entity.field_71093_bK) && !world.func_72935_r() && moonPhase == (wantedPhase = this.moonPhaseFromString(info.getMoonPhase()))) {
                this.AgeTheMob(info, entity, world);
            }
        } else {
            AgeingMobs.logger.error("An error has occured. %s is using a moon phae but your config has no moon dimensions.", new Object[]{info.getUniqueID()});
        }
    }

    public int moonPhaseFromString(String moonPhase) {
        switch (moonPhase) {
            case "Full Moon": {
                return 0;
            }
            case "Waning Gibbous": {
                return 1;
            }
            case "Last Quarter": {
                return 2;
            }
            case "Waning Crescent": {
                return 3;
            }
            case "New Moon": {
                return 4;
            }
            case "Waxing Crescent": {
                return 5;
            }
            case "First Quarter": {
                return 6;
            }
            case "Waxing Gibbous": {
                return 7;
            }
        }
        return 0;
    }

    public void timeChecks(TimeBasedAgingInfo info, Entity entity, World world) {
        long minTime = info.getMinTime();
        long maxTime = info.getMaxTime();
        long worldTime = world.func_72820_D();
        if (worldTime <= maxTime && worldTime >= minTime) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void weatherChecks(WeatherBasedAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        WorldProvider provider = entity.field_70170_p.field_73011_w;
        int wantedWeather = this.weatherPhaseFromString(info.getWeather());
        if (wantedWeather == 0) {
            if (!world.func_72896_J()) {
                this.AgeTheMob(info, entity, world);
            }
        } else if (wantedWeather == 1) {
            if (world.func_72896_J() && !world.func_72911_I()) {
                this.AgeTheMob(info, entity, world);
            }
        } else if (wantedWeather == 2) {
            if (world.func_72911_I()) {
                this.AgeTheMob(info, entity, world);
            }
        } else {
            AgeingMobs.logger.error("An error has occured. %s is using the wrong syntax.", new Object[]{info.getUniqueID()});
        }
    }

    public int weatherPhaseFromString(String weatherPhase) {
        switch (weatherPhase) {
            case "clear": {
                return 0;
            }
            case "rain": {
                return 1;
            }
            case "thunder": {
                return 2;
            }
        }
        return 0;
    }

    public void liquidChecks(LiquidBasedAgingInfo info, Entity entity, World world) {
        Fluid fluid = FluidRegistry.getFluid((String)info.getLiquid());
        AxisAlignedBB bb = entity.func_174813_aQ().func_72314_b(0.0, (double)-0.4f, 0.0).func_186664_h(0.001);
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int l3 = j2; l3 < k2; ++l3) {
            block1: for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    IBlockState state = world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(l3, i4, j4));
                    if (state.func_185904_a() == Material.field_151579_a || state.func_177230_c() != fluid.getBlock()) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    this.AgeTheMob(info, entity, world);
                    continue block1;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
    }

    public void heightChecks(HeightBasedAgingInfo info, Entity entity, World world) {
        int minHeight = info.getMinHeight();
        int maxHeight = info.getMaxHeight();
        int entityHeight = entity.func_180425_c().func_177956_o();
        if (entityHeight >= minHeight && entityHeight <= maxHeight) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void entityChecks(EntityBasedAgingInfo info, Entity entity, World world) {
        BlockPos entityPos = entity.func_180425_c();
        int checkRadius = info.getRadius();
        int nearbyEntityAmount = 0;
        AxisAlignedBB areaHitbox = new AxisAlignedBB((double)((float)entityPos.func_177958_n() - 0.5f), (double)((float)entityPos.func_177956_o() - 0.5f), (double)((float)entityPos.func_177952_p() - 0.5f), (double)((float)entityPos.func_177958_n() + 0.5f), (double)((float)entityPos.func_177956_o() + 0.5f), (double)((float)entityPos.func_177952_p() + 0.5f)).func_72321_a((double)(-checkRadius), (double)(-checkRadius), (double)(-checkRadius)).func_72321_a((double)checkRadius, (double)checkRadius, (double)checkRadius);
        if (!world.func_72872_a(Entity.class, areaHitbox).isEmpty()) {
            for (Entity foundEntity : world.func_72872_a(Entity.class, areaHitbox)) {
                if (foundEntity instanceof EntityPlayer || foundEntity instanceof FakePlayer || !EntityList.func_180123_a((Entity)foundEntity, (ResourceLocation)AgeingHelper.getEntityLocation(info.getNearbyEntity()))) continue;
                if (!info.getChangedEntityData().func_82582_d()) {
                    NBTTagCompound entityTag = AgeingHelper.entityToNBT(foundEntity);
                    NBTTagCompound entityTag2 = info.getNearbyEntityData();
                    if (NBTUtil.func_181123_a((NBTBase)entityTag2, (NBTBase)entityTag, (boolean)true)) continue;
                    ++nearbyEntityAmount;
                    continue;
                }
                ++nearbyEntityAmount;
            }
        }
        if (nearbyEntityAmount != 0) {
            this.AgeTheMob(info, entity, world);
        }
    }

    public void AgeTheMob(RegularAgingInfo info, Entity entity, World world) {
        int maxTime = info.getTickTime();
        String uniqueTag = "ageingmobs:" + info.getUniqueID();
        NBTTagCompound tag = entity.getEntityData();
        if (!tag.func_74764_b(uniqueTag)) {
            tag.func_74768_a(uniqueTag, 0);
        }
        if (tag.func_74762_e(uniqueTag) >= maxTime) {
            if (info.getEntity().equals(info.getEvolvedEntity())) {
                if (!info.getChangedEntityData().func_82582_d()) {
                    BlockPos originalPos = entity.func_180425_c();
                    Entity agedEntity = null;
                    agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()), (World)entity.field_70170_p);
                    if (agedEntity != null) {
                        agedEntity.func_82149_j(entity);
                        world.func_72838_d(agedEntity);
                        NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                        NBTTagCompound entityTagCopy = entityTag.func_74737_b();
                        NBTTagCompound entityTag2 = info.getChangedEntityData();
                        if (!entityTag2.func_82582_d()) {
                            entityTag.func_179237_a(entityTag2);
                            UUID uuid = agedEntity.func_110124_au();
                            agedEntity.func_70020_e(entityTag);
                            agedEntity.func_184221_a(uuid);
                        }
                    } else {
                        AgeingMobs.logger.error("Aged Entity invalid [Line 661, Report this to the author of Ageing Mobs]: " + info.getEvolvedEntity().toString());
                    }
                    tag.func_82580_o(uniqueTag);
                    entity.captureDrops = false;
                    world.func_72900_e(entity);
                }
            } else if (!info.getChangedEntityData().func_82582_d()) {
                BlockPos originalPos = entity.func_180425_c();
                Entity agedEntity = null;
                agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()), (World)entity.field_70170_p);
                if (agedEntity != null) {
                    agedEntity.func_82149_j(entity);
                    NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                    NBTTagCompound entityTagCopy = entityTag.func_74737_b();
                    NBTTagCompound entityTag2 = info.getChangedEntityData();
                    if (!entityTag2.func_82582_d()) {
                        UUID uuid = agedEntity.func_110124_au();
                        entityTag.func_179237_a(entityTag2);
                        agedEntity.func_70020_e(entityTag);
                        agedEntity.func_184221_a(uuid);
                    }
                    world.func_72838_d(agedEntity);
                } else {
                    AgeingMobs.logger.error("Aged Entity invalid [Line 646, Report this to the author of Ageing Mobs]: " + info.getEvolvedEntity().toString());
                }
                tag.func_82580_o(uniqueTag);
                entity.captureDrops = false;
                world.func_72900_e(entity);
            } else {
                BlockPos originalPos = entity.func_180425_c();
                Entity agedEntity = null;
                agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()), (World)entity.field_70170_p);
                System.out.println(info.getEvolvedEntity().toString());
                if (agedEntity != null) {
                    agedEntity.func_82149_j(entity);
                    world.func_72838_d(agedEntity);
                } else {
                    AgeingMobs.logger.error("Aged Entity invalid [Line 666, Report this to the author of Ageing Mobs]: " + info.getEvolvedEntity().toString());
                }
                tag.func_82580_o(uniqueTag);
                entity.captureDrops = false;
                world.func_72900_e(entity);
            }
        } else {
            int currentAge = tag.func_74762_e(uniqueTag);
            tag.func_74768_a(uniqueTag, ++currentAge);
        }
    }

    public void AgeTheMobMagic(RegularAgingInfo info, Entity entity, World world, Double efficiency) {
        int maxTime = info.getTickTime();
        String uniqueTag = "ageingmobs:" + info.getUniqueID();
        NBTTagCompound tag = entity.getEntityData();
        if (!tag.func_74764_b(uniqueTag)) {
            tag.func_74780_a(uniqueTag, 0.0);
        }
        if (tag.func_74769_h(uniqueTag) >= (double)maxTime) {
            if (info.getEntity().equals(info.getEvolvedEntity())) {
                if (!info.getChangedEntityData().func_82582_d()) {
                    BlockPos originalPos = entity.func_180425_c();
                    Entity agedEntity = null;
                    agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()), (World)entity.field_70170_p);
                    if (agedEntity != null) {
                        agedEntity.func_82149_j(entity);
                        world.func_72838_d(agedEntity);
                        NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                        NBTTagCompound entityTagCopy = entityTag.func_74737_b();
                        NBTTagCompound entityTag2 = info.getChangedEntityData();
                        if (!entityTag2.func_82582_d()) {
                            entityTag.func_179237_a(entityTag2);
                            UUID uuid = agedEntity.func_110124_au();
                            agedEntity.func_70020_e(entityTag);
                            agedEntity.func_184221_a(uuid);
                        }
                    } else {
                        AgeingMobs.logger.error("Magic Aged Entity invalid [Line 722, Report this to the author of Ageing Mobs]: " + info.getEvolvedEntity().toString());
                    }
                    tag.func_82580_o(uniqueTag);
                    entity.captureDrops = false;
                    world.func_72900_e(entity);
                }
            } else if (!info.getChangedEntityData().func_82582_d()) {
                BlockPos originalPos = entity.func_180425_c();
                Entity agedEntity = null;
                agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()), (World)entity.field_70170_p);
                if (agedEntity != null) {
                    agedEntity.func_82149_j(entity);
                    NBTTagCompound entityTag = AgeingHelper.entityToNBT(entity);
                    NBTTagCompound entityTagCopy = entityTag.func_74737_b();
                    NBTTagCompound entityTag2 = info.getChangedEntityData();
                    if (!entityTag2.func_82582_d()) {
                        UUID uuid = agedEntity.func_110124_au();
                        entityTag.func_179237_a(entityTag2);
                        agedEntity.func_70020_e(entityTag);
                        agedEntity.func_184221_a(uuid);
                    }
                    world.func_72838_d(agedEntity);
                } else {
                    AgeingMobs.logger.error("Magic Aged Entity invalid [Line 757, Report this to the author of Ageing Mobs]: " + info.getEvolvedEntity().toString());
                }
                tag.func_82580_o(uniqueTag);
                entity.captureDrops = false;
                world.func_72900_e(entity);
            } else {
                BlockPos originalPos = entity.func_180425_c();
                Entity agedEntity = null;
                agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(info.getEvolvedEntity()), (World)entity.field_70170_p);
                System.out.println(info.getEvolvedEntity().toString());
                if (agedEntity != null) {
                    agedEntity.func_82149_j(entity);
                    world.func_72838_d(agedEntity);
                } else {
                    AgeingMobs.logger.error("Magic Aged Entity invalid [Line 777, Report this to the author of Ageing Mobs]: " + info.getEvolvedEntity().toString());
                }
                tag.func_82580_o(uniqueTag);
                entity.captureDrops = false;
                world.func_72900_e(entity);
            }
        } else {
            double currentAge = tag.func_74769_h(uniqueTag);
            tag.func_74780_a(uniqueTag, currentAge += efficiency.doubleValue());
        }
    }

    public void BabifyTheMob(RegularAgingInfo info, Entity entity, World world) {
        String uniqueTag = "ageingmobs:" + info.getUniqueID();
        NBTTagCompound tag = entity.getEntityData();
        if (tag.func_74762_e(uniqueTag) == 0) {
            tag.func_82580_o(uniqueTag);
        }
        int currentAge = tag.func_74762_e(uniqueTag);
        tag.func_74768_a(uniqueTag, --currentAge);
    }

    public void AgeTheEndermite(EndermiteToShulkerAgeingInfo info, EntityEndermite endermite, World world) {
        int maxTime = info.getTickTime();
        BlockPos entityPos = endermite.func_180425_c();
        String uniqueTag = "ageingmobs:" + info.getUniqueID();
        NBTTagCompound tag = endermite.getEntityData();
        if (!tag.func_74764_b(uniqueTag)) {
            tag.func_74768_a(uniqueTag, 0);
        }
        if (tag.func_74762_e(uniqueTag) >= maxTime) {
            endermite.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIHideInPurpur(endermite));
            tag.func_74757_a(uniqueTag + "Done", true);
            tag.func_82580_o(uniqueTag);
        } else {
            int currentAge = tag.func_74762_e(uniqueTag);
            tag.func_74768_a(uniqueTag, ++currentAge);
        }
    }
}

