/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.AgeingMobs.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="ageingmobs")
@Config.LangKey(value="ageingmobs.config.title")
public class AgeingMobsConfigGen {
    @Config.Comment(value={"General Settings"})
    @Config.Name(value="General Settings")
    public static General general = new General();
    @Config.Comment(value={"List Settings"})
    @Config.Name(value="List Settings")
    public static List list = new List();

    @Mod.EventBusSubscriber(modid="ageingmobs")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ageingmobs")) {
                ConfigManager.sync((String)"ageingmobs", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class List {
        @Config.Comment(value={"Blocks that are seen as magical, by removing the blocks they won't be seen as magical by the mod. syntax: modid:block;effectiveness"})
        @Config.Name(value="Magical Block List")
        public String[] magical_blocks = new String[]{"minecraft:bookshelf;0.2", "minecraft:brewing_stand;0.5", "minecraft:enchanting_table;1"};
        @Config.Comment(value={"Dimensions that the mod recognizes having a moon. By default only has the overworld"})
        @Config.Name(value="Dimensions with a moon")
        public String[] moon_dimensions = new String[]{"0"};
    }

    public static class General {
        @Config.Comment(value={"Creeper -> Charged Creeper"})
        @Config.Name(value="Creeper -> Charged Creeper")
        public ChargedCreeper chargedcreeper = new ChargedCreeper();
        @Config.Comment(value={"Zombie -> Husk"})
        @Config.Name(value="Zombie -> Husk")
        public ZombieHusk zombiehusk = new ZombieHusk();
        @Config.Comment(value={"Husk -> Zombie"})
        @Config.Name(value="Husk -> Zombie")
        public HuskZombie huskzombie = new HuskZombie();
        @Config.Comment(value={"Villager -> Vindicator"})
        @Config.Name(value="Villager -> Vindicator")
        public VillagerVindicator villagervindicator = new VillagerVindicator();
        @Config.Comment(value={"Vindicator -> Evoker"})
        @Config.Name(value="Vindicator -> Evoker")
        public VindicatorEvoker vindicatorevoker = new VindicatorEvoker();
        @Config.Comment(value={"Guardian -> Elder Guardian"})
        @Config.Name(value="Guardian -> Elder Guardian")
        public GuardianElder guardianelder = new GuardianElder();
        @Config.Comment(value={"Baby Zombie -> Zombie"})
        @Config.Name(value="Baby Zombie -> Zombie")
        public BabyZombie babyzombie = new BabyZombie();
        @Config.Comment(value={"Endermite -> Shulker"})
        @Config.Name(value="Endermite -> Shulker")
        public EndermiteShulker endermiteshulker = new EndermiteShulker();
        @Config.Comment(value={"Skeleton -> Stray"})
        @Config.Name(value="Skeleton -> Stray")
        public SkeletonStray skeletonstray = new SkeletonStray();
        @Config.Comment(value={"Stray -> Skeleton"})
        @Config.Name(value="Stray -> Skeleton")
        public StraySkeleton strayskeleton = new StraySkeleton();
        @Config.Comment(value={"Rabbit -> Killer"})
        @Config.Name(value="Rabbit -> Killer")
        public RabbitKiller rabbitkiller = new RabbitKiller();
        @Config.Comment(value={"Cow -> Mooshroom"})
        @Config.Name(value="Cow -> Mooshroom")
        public CowMooshroom cowmooshroom = new CowMooshroom();
        @Config.Comment(value={"Skeleton -> Wither Skeleton"})
        @Config.Name(value="Skeleton -> Wither Skeleton")
        public SkeletonWitherSkeleton skeletonwitherskelly = new SkeletonWitherSkeleton();
        @Config.Comment(value={"Slime -> Magma Cube"})
        @Config.Name(value="Slime -> Magma Cube")
        public SlimeMagmaCube slimemagma = new SlimeMagmaCube();
        @Config.Comment(value={"Bat -> Vex"})
        @Config.Name(value="Bat -> Vex")
        public BatVex batvex = new BatVex();

        public class BatVex {
            @Config.Comment(value={"Setting this to false disables the bat -> vex ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean batToVexAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 666)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int batToVexAgeingTime = 666;
        }

        public class SlimeMagmaCube {
            @Config.Comment(value={"Setting this to false disables the slime -> magma cube ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean slimeToMagmaCubeAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 120)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int slimeToMagmaCubeAgeingTime = 120;
        }

        public class SkeletonWitherSkeleton {
            @Config.Comment(value={"Setting this to false disables the skeleton -> wither skeleton ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean skeletonToWitherSkeletonAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 120)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int skeletonToWitherSkeletonAgeingTime = 120;
        }

        public class CowMooshroom {
            @Config.Comment(value={"Setting this to false disables the cow -> mooshroom ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean cowToMooshroomAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 900)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int cowToMooshroomAgeingTime = 900;
            @Config.Comment(value={"This specifies radius (not the diameter) around the original mob in which it checks for magic blocks (Default: 5)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int cowToMooshroomAgeingRadius = 5;
        }

        public class RabbitKiller {
            @Config.Comment(value={"Setting this to false disables the rabbit -> killer rabbit ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean rabbitToKillerAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 300)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int rabbitToKillerAgeingTime = 300;
            @Config.Comment(value={"This specifies the minimum light level from which the mob starts to age (Default: 0)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0, max=15)
            public int minimumLightLevel = 0;
            @Config.Comment(value={"This specifies the maximum light level from which the mob starts to age (Default: 3)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0, max=15)
            public int maximumLightLevel = 3;
        }

        public class StraySkeleton {
            @Config.Comment(value={"Setting this to false disables the stray -> skeleton ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean strayToSkeletonAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 30)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int strayToSkeletonAgeingTime = 30;
        }

        public class SkeletonStray {
            @Config.Comment(value={"Setting this to false disables the skeleton -> stray ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean skeletonToStrayAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 30)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int skeletonToStrayAgeingTime = 30;
        }

        public class EndermiteShulker {
            @Config.Comment(value={"Setting this to false disables the endermite -> shulker ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean endermiteToShulkerAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 360)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int endermiteToShulkerAgeingTime = 360;
            @Config.Comment(value={"This specifies the time in second which dictates how long you need to wait when the endermite insert themselves into a purpur block (Default: 60)"})
            @Config.RangeInt(min=1)
            public int endermiteToShulkerBlockTime = 60;
        }

        public class BabyZombie {
            @Config.Comment(value={"Setting this to false disables the baby -> zombie ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean babyToZombieAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 1200)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int babyToZombieAgeingTime = 1200;
        }

        public class GuardianElder {
            @Config.Comment(value={"Setting this to false disables the guardian -> elder ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean guardianToElderAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 1800)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int guardianToElderAgeingTime = 1800;
            @Config.Comment(value={"This specifies max amount of elder guardians in the area, 0 = infinite (Default: 3)"})
            public int guardianToElderAgeingMax = 3;
            @Config.Comment(value={"This specifies radius (not the diameter) around the original mob in which it checks for the boss mob (16 = infinite (Default: 16)"})
            @Config.RangeInt(min=1)
            public int guardianToElderRange = 16;
        }

        public class VindicatorEvoker {
            @Config.Comment(value={"Setting this to false disables the vindicator -> evoker ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean vindicatorToEvokerAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 600)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int vindicatorToEvokerAgeingTime = 600;
        }

        public class VillagerVindicator {
            @Config.Comment(value={"Setting this to false disables the villager -> vindicator ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean villagerToVindicatorAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 1200)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int villagerToVindicatorAgeingTime = 1200;
            @Config.Comment(value={"This specifies the minimum light level from which the mob starts to age (Default: 0)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0, max=15)
            public int minimumLightLevel = 0;
            @Config.Comment(value={"This specifies the maximum light level from which the mob starts to age (Default: 8)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0, max=15)
            public int maximumLightLevel = 8;
        }

        public class HuskZombie {
            @Config.Comment(value={"Setting this to false disables the husk -> zombie ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean huskToZombieAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 30)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int huskToZombieAgeingTime = 30;
        }

        public class ZombieHusk {
            @Config.Comment(value={"Setting this to false disables the zombie -> husk ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean zombieToHuskAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 30)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int zombieToHuskAgeingTime = 30;
        }

        public class ChargedCreeper {
            @Config.Comment(value={"Setting this to false disables the creeper -> charged creeper ageing (Default: true)"})
            @Config.RequiresMcRestart
            public boolean creeperAgeing = true;
            @Config.Comment(value={"This specifies the time in second which dictates how long a mob needs to age (Default: 900)"})
            @Config.RequiresMcRestart
            @Config.RangeInt(min=1)
            public int creeperAgeingTime = 900;
        }
    }
}

