/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.AgeingMobs.compat.jei.dimension;

import com.svennieke.AgeingMobs.compat.jei.JeiRenderHelpers;
import com.svennieke.AgeingMobs.util.AgeingHelper;
import java.util.UUID;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DimensionWrapper
implements IRecipeWrapper {
    private final ItemStack egg1;
    private final ItemStack egg2;
    private final String entity;
    private final NBTTagCompound entityData;
    private final String evolvedEntity;
    private final NBTTagCompound changedEntityData;
    private final int tickTime;
    private final int dimensionID;

    public DimensionWrapper(ItemStack egg1, ItemStack egg2, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, int tickTime, int dimensionID) {
        this.entity = entity;
        this.entityData = entityData;
        this.evolvedEntity = transformedEntity;
        this.changedEntityData = changedEntityData;
        this.tickTime = tickTime;
        this.dimensionID = dimensionID;
        this.egg1 = egg1;
        this.egg2 = egg2;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.egg1);
        ingredients.setOutput(ItemStack.class, (Object)this.egg2);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Entity originalEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(this.entity), (World)minecraft.field_71441_e);
        Entity agedEntity = EntityList.func_188429_b((ResourceLocation)AgeingHelper.getEntityLocation(this.evolvedEntity), (World)minecraft.field_71441_e);
        if (originalEntity != null && agedEntity != null) {
            UUID uuid;
            NBTTagCompound nbttagcompound1;
            NBTTagCompound nbttagcompound;
            if (!this.entityData.func_82582_d()) {
                nbttagcompound = AgeingHelper.entityToNBT(originalEntity);
                nbttagcompound1 = nbttagcompound.func_74737_b();
                uuid = originalEntity.func_110124_au();
                nbttagcompound.func_179237_a(this.entityData);
                originalEntity.func_184221_a(uuid);
                originalEntity.func_70020_e(nbttagcompound);
            }
            if (!this.changedEntityData.func_82582_d()) {
                nbttagcompound = AgeingHelper.entityToNBT(agedEntity);
                nbttagcompound1 = nbttagcompound.func_74737_b();
                uuid = agedEntity.func_110124_au();
                nbttagcompound.func_179237_a(this.changedEntityData);
                agedEntity.func_184221_a(uuid);
                agedEntity.func_70020_e(nbttagcompound);
            }
            float scale = JeiRenderHelpers.getScale(originalEntity);
            int offsetY = JeiRenderHelpers.getOffsetY(originalEntity);
            float scale2 = JeiRenderHelpers.getScale(agedEntity);
            int offsetY2 = JeiRenderHelpers.getOffsetY(agedEntity);
            FontRenderer fontRenderer = minecraft.field_71466_p;
            String mobName = originalEntity.func_70005_c_();
            String agedMobName = agedEntity.func_70005_c_();
            fontRenderer.func_175065_a(mobName, (float)(30 - fontRenderer.func_78256_a(mobName) / 2), 90.0f, -1, true);
            fontRenderer.func_175065_a(agedMobName, (float)(114 - fontRenderer.func_78256_a(agedMobName) / 2), 90.0f, -1, true);
            String timeNeeded = AgeingHelper.getTiming(this.tickTime);
            fontRenderer.func_175065_a(timeNeeded, (float)(72 - fontRenderer.func_78256_a(timeNeeded) / 2), 2.0f, -1, true);
            String dimensionIDName = "Dimension: " + String.valueOf(this.dimensionID);
            fontRenderer.func_175065_a(dimensionIDName, (float)(72 - fontRenderer.func_78256_a(dimensionIDName) / 2), 16.0f, -1, true);
            JeiRenderHelpers.renderEntity(28, 70 - offsetY, scale, 29 - mouseX, 35 - offsetY - mouseY, originalEntity);
            JeiRenderHelpers.renderEntity(116, 70 - offsetY2, scale2, 117 - mouseX, 35 - offsetY2 - mouseY, agedEntity);
        }
    }
}

