/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.AgeingMobs.compat.ct;

import com.svennieke.AgeingMobs.lists.AgeList;
import crafttweaker.IAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;

public class AddLiquidAgeingAction
implements IAction {
    private String uniqueID;
    private String entity;
    private NBTTagCompound entityData;
    private String transformedEntity;
    private NBTTagCompound changedEntityData;
    private int tickTime;
    private String liquid;
    private boolean reversible;
    private String gamestage;

    public AddLiquidAgeingAction(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String liquid, boolean reversible, int tickTime) {
        this.uniqueID = uniqueID;
        this.entity = entity;
        this.entityData = entityData;
        this.transformedEntity = transformedEntity;
        this.changedEntityData = changedEntityData;
        this.tickTime = tickTime;
        this.liquid = liquid;
        this.reversible = reversible;
    }

    public AddLiquidAgeingAction(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String liquid, boolean reversible, int tickTime) {
        this.uniqueID = uniqueID;
        this.entity = entity;
        this.entityData = entityData;
        this.transformedEntity = transformedEntity;
        this.changedEntityData = changedEntityData;
        this.tickTime = tickTime;
        this.liquid = liquid;
        this.reversible = reversible;
        this.gamestage = gamestage;
    }

    public void apply() {
        if (FluidRegistry.isFluidRegistered((String)this.liquid)) {
            if (this.gamestage != null && !this.gamestage.isEmpty()) {
                AgeList.addStagedLiquidBasedAgeing(this.uniqueID, this.gamestage, this.entity, this.entityData, this.transformedEntity, this.changedEntityData, this.liquid, this.reversible, this.tickTime);
            } else {
                AgeList.addLiquidBasedAgeing(this.uniqueID, this.entity, this.entityData, this.transformedEntity, this.changedEntityData, this.liquid, this.reversible, this.tickTime);
            }
        }
    }

    public String describe() {
        if (FluidRegistry.isFluidRegistered((String)this.liquid)) {
            if (this.gamestage != null && !this.gamestage.isEmpty()) {
                return String.format("%s has been added to the staged Liquid ageing list.", this.uniqueID);
            }
            return String.format("%s has been added to the Liquid ageing list.", this.uniqueID);
        }
        return String.format("%s used a liquid that we don't know about %s.", this.uniqueID, this.liquid);
    }
}

