/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.AgeingMobs.compat.ct;

import com.svennieke.AgeingMobs.lists.AgeList;
import crafttweaker.IAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AddBiomeAgeingAction
implements IAction {
    private String uniqueID;
    private String entity;
    private NBTTagCompound entityData;
    private String transformedEntity;
    private NBTTagCompound changedEntityData;
    private int tickTime;
    private Biome biome;
    private String gamestage;

    public AddBiomeAgeingAction(String uniqueID, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String biome, int tickTime) {
        Biome selectedBiome;
        this.uniqueID = uniqueID;
        this.entity = entity;
        this.entityData = entityData;
        this.transformedEntity = transformedEntity;
        this.changedEntityData = changedEntityData;
        this.tickTime = tickTime;
        this.biome = selectedBiome = (Biome)ForgeRegistries.BIOMES.getValue(AddBiomeAgeingAction.getBiomeResourceLocation(biome));
    }

    public AddBiomeAgeingAction(String uniqueID, String gamestage, String entity, NBTTagCompound entityData, String transformedEntity, NBTTagCompound changedEntityData, String biome, int tickTime) {
        Biome selectedBiome;
        this.uniqueID = uniqueID;
        this.entity = entity;
        this.entityData = entityData;
        this.transformedEntity = transformedEntity;
        this.changedEntityData = changedEntityData;
        this.tickTime = tickTime;
        this.gamestage = gamestage;
        this.biome = selectedBiome = (Biome)ForgeRegistries.BIOMES.getValue(AddBiomeAgeingAction.getBiomeResourceLocation(biome));
    }

    public void apply() {
        if (this.gamestage != null && !this.gamestage.isEmpty()) {
            AgeList.addStagedBiomeBasedAgeing(this.uniqueID, this.gamestage, this.entity, this.entityData, this.transformedEntity, this.changedEntityData, this.biome, this.tickTime);
        } else {
            AgeList.addBiomeBasedAgeing(this.uniqueID, this.entity, this.entityData, this.transformedEntity, this.changedEntityData, this.biome, this.tickTime);
        }
    }

    public String describe() {
        if (this.gamestage != null && !this.gamestage.isEmpty()) {
            return String.format("%s has been added to the staged Biome ageing list.", this.uniqueID);
        }
        return String.format("%s has been added to the Biome ageing list.", this.uniqueID);
    }

    public static ResourceLocation getBiomeResourceLocation(String name) {
        String[] splitResource = name.split(":");
        if (splitResource.length != 2) {
            return new ResourceLocation(name);
        }
        return new ResourceLocation(splitResource[0], splitResource[1]);
    }
}

