/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib.toml;

import com.google.common.base.Strings;
import com.supermartijn642.configlib.toml.TomlElement;
import com.supermartijn642.configlib.toml.TomlTable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;

public class TomlSerializer {
    protected static void writeTomlTable(BufferedWriter write, TomlTable object) throws IOException {
        String elementKey;
        for (Map.Entry<String, TomlElement> element : object.entrySet()) {
            if (element.getValue().isTable()) continue;
            elementKey = element.getKey();
            if (elementKey.contains(" ")) {
                elementKey = '\"' + elementKey + '\"';
            }
            TomlSerializer.writeElement(write, 0, elementKey, element.getValue());
        }
        for (Map.Entry<String, TomlElement> element : object.entrySet()) {
            if (!element.getValue().isTable()) continue;
            elementKey = element.getKey();
            if (elementKey.contains(" ")) {
                elementKey = '\"' + elementKey + '\"';
            }
            TomlSerializer.writeElement(write, 0, elementKey, element.getValue());
        }
    }

    private static void writeElement(BufferedWriter writer, int indentation, String key, TomlElement element) throws IOException {
        if (element.comment != null) {
            TomlSerializer.comment(writer, indentation, element.comment.replace("\n", "\n#"));
        }
        if (element.valueHint != null) {
            TomlSerializer.comment(writer, indentation, element.valueHint);
        }
        if (!element.isEmpty()) {
            if (element.isTable()) {
                TomlSerializer.writeTable(writer, indentation, key, element.getAsTable());
            } else if (element.isInteger()) {
                TomlSerializer.writeValue(writer, indentation, key, Integer.toString(element.getAsInteger()));
            } else if (element.isDouble()) {
                TomlSerializer.writeValue(writer, indentation, key, Double.toString(element.getAsDouble()));
            } else if (element.isLong()) {
                TomlSerializer.writeValue(writer, indentation, key, Long.toString(element.getAsLong()));
            } else if (element.isBoolean()) {
                TomlSerializer.writeValue(writer, indentation, key, Boolean.toString(element.getAsBoolean()));
            } else if (element.isString()) {
                TomlSerializer.writeValue(writer, indentation, key, "\"" + element.getAsString() + "\"");
            }
        }
        if (!element.isTable()) {
            writer.newLine();
        }
    }

    private static void writeTable(BufferedWriter writer, int indentation, String key, TomlTable object) throws IOException {
        TomlSerializer.indentation(writer, indentation);
        writer.append("[").append(key).append("]");
        writer.newLine();
        for (Map.Entry<String, TomlElement> element : object.entrySet()) {
            if (element.getValue().isTable()) continue;
            TomlSerializer.writeElement(writer, indentation + 1, element.getKey(), element.getValue());
        }
        for (Map.Entry<String, TomlElement> element : object.entrySet()) {
            if (!element.getValue().isTable()) continue;
            String elementKey = element.getKey();
            if (elementKey.contains(" ")) {
                elementKey = '\"' + elementKey + '\"';
            }
            TomlSerializer.writeElement(writer, indentation + 1, key + "." + elementKey, element.getValue());
        }
    }

    private static void writeValue(BufferedWriter writer, int indentation, String key, String valueSerialized) throws IOException {
        TomlSerializer.indentation(writer, indentation);
        writer.write(key);
        writer.write(" = ");
        writer.write(valueSerialized);
        writer.newLine();
    }

    private static void indentation(BufferedWriter writer, int indentation) throws IOException {
        writer.write(Strings.repeat((String)"    ", (int)indentation));
    }

    private static void comment(BufferedWriter writer, int indentation, String comment) throws IOException {
        TomlSerializer.indentation(writer, indentation);
        writer.write("# ");
        writer.write(comment);
        writer.newLine();
    }
}

